/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.dbm.common.DbmElement;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmNamedObject;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmNode;
import com.intellij.dbm.common.DbmObjectListener;
import com.intellij.dbm.common.DbmRef;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmUtil;
import com.intellij.dbm.common.EmptyFamily;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.ObjectsRef;
import com.intellij.dbm.common.RelativeReference;
import com.intellij.dbm.common.Resolver;
import com.intellij.dbm.common.StateProperty;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Dates;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.util.Strings;

public abstract class DbmObject
extends DbmElement
implements DbmNamedObject,
DbmNode {
    public static final long NO_ID = 0L;
    @StateProperty
    @Nullable
    public String myName;
    @StateProperty
    public boolean myNameSurrogate;
    @StateProperty
    public long myObjectId;
    @StateProperty
    public boolean myObjectSurrogate;
    @NotNull
    private @NotNull ImmutableList<Family<@NotNull ? extends DbmObject>> myFamilies;
    private Family<@NotNull ? extends DbmObject> myParentFamily;
    @StateProperty
    @Nullable
    public String myComment;
    @StateProperty
    public long myStateNumber;
    @StateProperty
    public Date myCreatedTimestamp;
    @StateProperty
    public Date myModifiedTimestamp;
    private transient boolean mySyncPending;
    private transient boolean myDropped;
    @Nullable
    private transient String myDisplayOrder;
    private transient @Nullable Collection<@NotNull DbmObjectListener> myListeners;
    private static final ImmutableList<Family<? extends DbmObject>> NO_FAMILIES = ImmutableList.of();
    @StateProperty
    @NotNull
    public final ObjectsRef<DbmObject, DbmObject> myInternalDependencies;
    private final GeneralResolver myGeneralResolver;

    DbmObject(@NotNull DbmModel model, @Nullable String name) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/common/DbmObject", "<init>"));
        }
        super(model);
        this.myObjectId = 0L;
        this.myFamilies = NO_FAMILIES;
        this.myGeneralResolver = new GeneralResolver();
        this.myName = DbUtil.intern((String)name, null);
        this.myInternalDependencies = new ObjectsRef<DbmObject, DbmObject>(this, DbmObject.class);
    }

    @Override
    @NotNull
    public abstract ObjectKind kind();

    protected void assignFamilies(Family<? extends DbmObject> ... families) {
        ImmutableList.Builder b = ImmutableList.builder();
        for (Family<? extends DbmObject> family : families) {
            if (family instanceof EmptyFamily) continue;
            b.add(family);
        }
        this.myFamilies = b.build();
    }

    void setParentFamily(Family<? extends DbmObject> parentFamily) {
        this.myParentFamily = parentFamily;
    }

    @Nullable
    public abstract DbmObject parent();

    boolean hasInPath(@NotNull DbmObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/dbm/common/DbmObject", "hasInPath"));
        }
        if (this == object) {
            return true;
        }
        DbmObject parent = this.parent();
        if (parent != null) {
            return parent.hasInPath(object);
        }
        return false;
    }

    public int childIndex() {
        assert (this.myParentFamily != null);
        return this.myParentFamily.indexOf(this);
    }

    @Override
    @NotNull
    public String identity() {
        String naturalName = this.getNaturalNameOrNull();
        String string = naturalName != null ? naturalName : "#" + (this.childIndex() + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "identity"));
        }
        return string;
    }

    @Override
    @NotNull
    public String identity(DbmObject scope) {
        DbmObject parent = this.parent();
        if (parent == null || scope.hasInPath(parent)) {
            String string = this.identity();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "identity"));
            }
            return string;
        }
        String prefix = parent.identity(scope);
        String string = prefix + '.' + this.identity();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "identity"));
        }
        return string;
    }

    @Override
    @NotNull
    public String identity(boolean includingSurrogate) {
        String id;
        String string = id = includingSurrogate ? this.getNameOrNull() : this.getNaturalNameOrNull();
        if (id == null) {
            id = "#" + (this.childIndex() + 1);
        }
        String string2 = id;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "identity"));
        }
        return string2;
    }

    public boolean isIdentity(@NotNull String identity) {
        if (identity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identity", "com/intellij/dbm/common/DbmObject", "isIdentity"));
        }
        return this.identity().equals(identity);
    }

    @Override
    @NotNull
    public String description(boolean includeSurrogates) {
        if (this instanceof DasTypedObject) {
            String defaultExpression;
            DasTypedObject typedThis = (DasTypedObject)this;
            StringBuilder b = new StringBuilder(60);
            b.append(typedThis.getDataType().getSpecification());
            if (typedThis.isNotNull()) {
                b.append(" NN");
            }
            if ((defaultExpression = typedThis.getDefault()) != null && defaultExpression.length() > 0) {
                b.append(" default ").append(defaultExpression);
            }
            String string = b.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "description"));
            }
            return string;
        }
        String string = this.kind().code();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "description"));
        }
        return string;
    }

    @NotNull
    public final String getDisplayOrder() {
        String o = this.myDisplayOrder;
        if (o == null) {
            this.myDisplayOrder = o = this.calculateDisplayOrder();
        }
        String string = o;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "getDisplayOrder"));
        }
        return string;
    }

    @NotNull
    protected String calculateDisplayOrder() {
        String name = this.getName();
        char c = this.isNameSurrogate() ? (char)'.' : '@';
        String string = c + StringUtil.toLowerCase((String)name);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "calculateDisplayOrder"));
        }
        return string;
    }

    final void invalidateDisplayOrder() {
        this.myDisplayOrder = null;
    }

    public void drop() {
        if (this.myDropped) {
            return;
        }
        DbmObject parent = this.parent();
        if (parent != null) {
            parent.modifying();
        }
        if (this.myListeners != null) {
            DbmObjectListener[] listeners = this.myListeners.toArray(new DbmObjectListener[0]);
            this.myListeners = null;
            for (DbmObjectListener listener : listeners) {
                listener.objectIsDropped(this);
            }
        }
        this.detachAllReferences();
        this.dropChildren();
        this.model.doingObjectRemove(this);
        if (this.myParentFamily != null) {
            this.myParentFamily.removeObject(this);
        }
        this.dissociateIdentifiers();
        this.myDropped = true;
    }

    protected void dissociateIdentifiers() {
        this.setObjectId(0L);
    }

    public void dropChildren() {
        for (int i = this.myFamilies.size() - 1; i >= 0; --i) {
            Family family = (Family)this.myFamilies.get(i);
            for (DbmObject child : family) {
                child.drop();
            }
        }
    }

    @Override
    protected void modifying() {
        if (this.myDropped) {
            throw new IllegalStateException("Attempted to modify a dropped object: " + this.getName() + ": " + this.getClass().getSimpleName());
        }
        DbmObject parent = this.parent();
        if (parent != null) {
            parent.modifyingChild(this);
        }
        this.model.doingObjectModify(this);
        this.invalidateDisplayOrder();
    }

    protected void modifyingFamily(@NotNull Family<?> family) {
        if (family == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "family", "com/intellij/dbm/common/DbmObject", "modifyingFamily"));
        }
        this.modifying();
    }

    protected void modifyingChild(@NotNull DbmElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dbm/common/DbmObject", "modifyingChild"));
        }
    }

    public void setName(@Nullable String name) {
        String newName;
        if (Strings.eq((String)this.myName, (String)name)) {
            return;
        }
        String oldName = this.myName;
        this.modifying();
        if (name == null || name.isEmpty()) {
            newName = null;
        } else {
            this.myName = newName = DbUtil.intern((String)name);
        }
        this.nameIsChanged(oldName, newName);
    }

    @Override
    @NotNull
    public String getName() {
        String string = (String)ObjectUtils.notNull((Object)this.myName, (Object)DasUtil.NO_NAME);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "getName"));
        }
        return string;
    }

    @Override
    @Nullable
    public String getNameOrNull() {
        String theName = this.myName;
        return theName == null || theName == DasUtil.NO_NAME ? null : theName;
    }

    @Override
    @Nullable
    public String getNaturalNameOrNull() {
        return this.myNameSurrogate ? null : this.myName;
    }

    @Override
    @NotNull
    public String getNameOrEmpty() {
        String string = this.myName != null ? this.myName : DasUtil.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "getNameOrEmpty"));
        }
        return string;
    }

    @Override
    public boolean hasName() {
        return this.myName != null;
    }

    @Override
    public boolean hasNaturalName() {
        return this.myName != null && !this.myNameSurrogate;
    }

    @Override
    public boolean isName(@Nullable String name) {
        if (this.myName == null || name == null) {
            return StringUtil.nullize((String)this.myName) == StringUtil.nullize((String)name);
        }
        boolean caseSensitive = this.namespace().getCasing((ObjectKind)this.kind(), null).plain.sensitive;
        return caseSensitive ? this.myName.equals(name) : this.myName.equalsIgnoreCase(name);
    }

    protected void nameIsChanged(@Nullable String oldName, @Nullable String newName) {
    }

    @Override
    public boolean isNameSurrogate() {
        return this.myNameSurrogate;
    }

    public void setNameSurrogate(boolean nameSurrogate) {
        if (this.myNameSurrogate == nameSurrogate) {
            return;
        }
        this.modifying();
        this.myNameSurrogate = nameSurrogate;
    }

    public long getObjectId() {
        return this.myObjectId;
    }

    public void setObjectId(long newObjectId) {
        if (this.myObjectId == newObjectId) {
            return;
        }
        this.modifying();
        long oldObjectId = this.myObjectId;
        this.myObjectId = newObjectId;
        this.schema().justObjectIdChanged(this, oldObjectId, newObjectId);
    }

    @NotNull
    public DbmNamespace namespace() {
        DbmNamespace dbmNamespace = this instanceof DbmNamespace ? (DbmNamespace)this : this.schema();
        if (dbmNamespace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "namespace"));
        }
        return dbmNamespace;
    }

    @NotNull
    public DbmSchema schema() {
        for (DbmObject node = this; node != null; node = node.parent()) {
            if (!(node instanceof DbmSchema)) continue;
            DbmSchema dbmSchema = (DbmSchema)node;
            if (dbmSchema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "schema"));
            }
            return dbmSchema;
        }
        throw new IllegalStateException("The node (" + this.toString() + ") is not a child of a schema");
    }

    public long getStateNumber() {
        return this.myStateNumber;
    }

    public void setStateNumber(long stateNumber) {
        if (this.myStateNumber == stateNumber) {
            return;
        }
        this.modifying();
        this.myStateNumber = stateNumber;
    }

    public void setObjectIdAndStateNumber(long objectId, long stateNumber) {
        this.setObjectId(objectId);
        this.setStateNumber(stateNumber);
    }

    public boolean isObjectSurrogate() {
        return this.myObjectSurrogate;
    }

    public void setObjectSurrogate(boolean objectSurrogate) {
        if (this.myObjectSurrogate == objectSurrogate) {
            return;
        }
        this.modifying();
        this.myObjectSurrogate = objectSurrogate;
    }

    @Nullable
    public Date getCreatedTimestamp() {
        return Dates.copy(this.myCreatedTimestamp);
    }

    public void setCreatedTimestamp(@Nullable Date createdTimestamp) {
        if (Dates.eq(this.myCreatedTimestamp, createdTimestamp)) {
            return;
        }
        this.modifying();
        this.myCreatedTimestamp = Dates.copy(createdTimestamp);
    }

    public Date getModifiedTimestamp() {
        return Dates.copy(this.myModifiedTimestamp);
    }

    public void setModifiedTimestamp(@Nullable Date modifiedTimestamp) {
        if (Dates.eq(this.myModifiedTimestamp, modifiedTimestamp)) {
            return;
        }
        this.modifying();
        this.myModifiedTimestamp = Dates.copy(modifiedTimestamp);
    }

    public void setCreatedAndModifiedTimestamps(@Nullable Date createdTimestamp, @Nullable Date modifiedTimestamp) {
        this.setCreatedTimestamp(createdTimestamp);
        this.setModifiedTimestamp(modifiedTimestamp);
    }

    @NotNull
    public DbmObject[] getObjectPath() {
        int n = 0;
        DbmObject obj = this;
        while (obj != null) {
            obj = obj.parent();
            ++n;
        }
        DbmObject[] objectPath = new DbmObject[n];
        obj = this;
        for (int k = n - 1; obj != null && k >= 0; obj = obj.parent(), --k) {
            objectPath[k] = obj;
        }
        if (objectPath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "getObjectPath"));
        }
        return objectPath;
    }

    @NotNull
    public String[] getPathInContextOf(@NotNull DbmObject contextObject) {
        int common;
        if (contextObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextObject", "com/intellij/dbm/common/DbmObject", "getPathInContextOf"));
        }
        if (contextObject.getParentFamily() == this.myParentFamily) {
            String[] stringArray = new String[]{this.getNameOrEmpty()};
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "getPathInContextOf"));
            }
            return stringArray;
        }
        if (contextObject == this.parent()) {
            String[] stringArray = new String[]{contextObject.getNameOrEmpty(), this.getNameOrEmpty()};
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "getPathInContextOf"));
            }
            return stringArray;
        }
        DbmObject[] contextObjectPath = contextObject.getObjectPath();
        DbmObject[] thisObjectPath = this.getObjectPath();
        int m = thisObjectPath.length;
        for (common = 0; common < contextObjectPath.length && common < m && contextObjectPath[common] == thisObjectPath[common]; ++common) {
        }
        String[] path = new String[m - common];
        for (int i = 0; i < m - common; ++i) {
            path[i] = thisObjectPath[common + i].getNameOrEmpty();
        }
        if (path == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "getPathInContextOf"));
        }
        return path;
    }

    @NotNull
    public String[] getFullPath() {
        DbmObject[] objectPath = this.getObjectPath();
        int n = objectPath.length;
        String[] path = new String[n];
        for (int i = 0; i < n; ++i) {
            path[i] = objectPath[i].getNameOrEmpty();
        }
        if (path == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "getFullPath"));
        }
        return path;
    }

    @NotNull
    public ImmutableList<Family<? extends DbmObject>> families() {
        ImmutableList<Family<? extends DbmObject>> immutableList = this.myFamilies;
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "families"));
        }
        return immutableList;
    }

    @NotNull
    public Family<?> getFamilyByName(@NotNull String familyName) {
        if (familyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyName", "com/intellij/dbm/common/DbmObject", "getFamilyByName"));
        }
        for (Family family : this.myFamilies) {
            if (!family.getFamilyName().equalsIgnoreCase(familyName)) continue;
            Family family2 = family;
            if (family2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "getFamilyByName"));
            }
            return family2;
        }
        throw new IllegalArgumentException("Object " + this.identity() + '(' + this.getClass().getSimpleName() + ") has no family named \"" + familyName + "\"");
    }

    @NotNull
    public Family<?> getFamilyByChildKind(@NotNull ObjectKind childKind) {
        if (childKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childKind", "com/intellij/dbm/common/DbmObject", "getFamilyByChildKind"));
        }
        Family<?> family = this.findFamilyByChildKind(childKind);
        if (family == null) {
            throw new IllegalArgumentException("Object " + this.identity() + '(' + this.getClass().getSimpleName() + ") has no family of " + childKind.toString());
        }
        Family<?> family2 = family;
        if (family2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "getFamilyByChildKind"));
        }
        return family2;
    }

    @Nullable
    public Family<?> findFamilyByChildKind(@NotNull ObjectKind childKind) {
        if (childKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childKind", "com/intellij/dbm/common/DbmObject", "findFamilyByChildKind"));
        }
        for (Family family : this.myFamilies) {
            if (family.getChildKind() != childKind) continue;
            return family;
        }
        return null;
    }

    @Nullable
    public String getComment() {
        return this.myComment;
    }

    public void setComment(@Nullable String comment) {
        String newComment = DbUtil.intern2((String)StringUtil.nullize((String)comment, (boolean)true));
        if (Strings.eq((String)this.myComment, (String)newComment)) {
            return;
        }
        this.modifying();
        this.myComment = newComment;
    }

    @NotNull
    public @NotNull JBIterable<@NotNull ? extends DbmObject> getDbChildren() {
        ImmutableList<Family<? extends DbmObject>> families = this.families();
        switch (families.size()) {
            case 0: {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "getDbChildren"));
                }
                return jBIterable;
            }
            case 1: {
                JBIterable jBIterable = ((Family)families.get(0)).iterable();
                if (jBIterable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "getDbChildren"));
                }
                return jBIterable;
            }
        }
        JBIterable jBIterable = JBIterable.from(families).flatten(f -> f);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "getDbChildren"));
        }
        return jBIterable;
    }

    @NotNull
    public <C> JBIterable<C> getDbChildren(@NotNull Class<C> clazz, @NotNull ObjectKind kind) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/dbm/common/DbmObject", "getDbChildren"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/dbm/common/DbmObject", "getDbChildren"));
        }
        DasUtil.CHECK_CANCELLED.value(null);
        JBIterable result = JBIterable.empty();
        for (Family family : this.myFamilies) {
            if (kind != ObjectKind.NONE && family.getChildKind() != kind) continue;
            result = result.append((Iterable)family);
        }
        JBIterable jBIterable = result.filter(DasUtil.CHECK_CANCELLED).filter(clazz);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "getDbChildren"));
        }
        return jBIterable;
    }

    public <O> void traverseChildren(@NotNull Class<O> objectClass, @NotNull Consumer<? super O> consumer) {
        if (objectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectClass", "com/intellij/dbm/common/DbmObject", "traverseChildren"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/dbm/common/DbmObject", "traverseChildren"));
        }
        for (Family family : this.families()) {
            if (!family.isNotEmpty()) continue;
            family.traverse(objectClass, consumer);
        }
    }

    public <O> void traversDepthFirst(@NotNull Class<O> objectClass, @NotNull Processor<? super O> processor) {
        if (objectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectClass", "com/intellij/dbm/common/DbmObject", "traversDepthFirst"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/dbm/common/DbmObject", "traversDepthFirst"));
        }
        boolean follow = objectClass.isAssignableFrom(this.getClass()) ? processor.process((Object)this) : false;
        if (follow) {
            for (Family family : this.myFamilies) {
                if (!family.isNotEmpty()) continue;
                for (DbmObject object : family) {
                    object.traversDepthFirst(objectClass, processor);
                }
            }
        }
    }

    public <O> void traversBreadthFirst(@NotNull Class<O> objectClass, @NotNull Processor<? super O> processor) {
        if (objectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectClass", "com/intellij/dbm/common/DbmObject", "traversBreadthFirst"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/dbm/common/DbmObject", "traversBreadthFirst"));
        }
        LinkedList<DbmObject> queue = new LinkedList<DbmObject>();
        queue.offer(this);
        do {
            boolean follow;
            DbmObject node;
            if (!objectClass.isAssignableFrom((node = (DbmObject)queue.poll()).getClass()) || !(follow = processor.process((Object)node))) continue;
            node.traverseChildren(DbmObject.class, object -> queue.offer((DbmObject)object));
        } while (!queue.isEmpty());
    }

    @Nullable
    public <C extends DbmNamedObject> C findChild(@NotNull Class<C> clazz, @NotNull String name) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/dbm/common/DbmObject", "findChild"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/DbmObject", "findChild"));
        }
        for (Family family : this.myFamilies) {
            Object child;
            if (family.isEmpty() || !clazz.isAssignableFrom(family.getChildClass()) || (child = family.get(name)) == null) continue;
            return child;
        }
        return null;
    }

    @Nullable
    protected <C extends DbmObject> C findChild(@NotNull Class<C> clazz, @NotNull String name, String ... args) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/dbm/common/DbmObject", "findChild"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/DbmObject", "findChild"));
        }
        if (args == null) {
            return (C)((DbmObject)this.findChild(clazz, name));
        }
        for (Family f : this.myFamilies) {
            Object c;
            Class childClass = f.getChildClass();
            if (!childClass.isAssignableFrom(clazz) && !clazz.isAssignableFrom(childClass) || (c = args == null ? f.get(name, true) : f.getOverload(name, args, true)) == null || !clazz.isAssignableFrom(c.getClass())) continue;
            return c;
        }
        return null;
    }

    protected void childBorn(@NotNull DbmObject child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/dbm/common/DbmObject", "childBorn"));
        }
    }

    protected void childDied(@NotNull DbmObject child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/dbm/common/DbmObject", "childDied"));
        }
    }

    @Override
    protected void collectState(@NotNull ImmutableMap.Builder<String, Object> stateBuilder, boolean surrogates) {
        if (stateBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateBuilder", "com/intellij/dbm/common/DbmObject", "collectState"));
        }
        if (surrogates || !this.myNameSurrogate) {
            this.putState(stateBuilder, "name", this.myName);
        }
        if (surrogates && this.myNameSurrogate) {
            this.putState(stateBuilder, "name-surrogate", true);
        }
    }

    public boolean hasChildren() {
        for (Family family : this.myFamilies) {
            if (!family.isNotEmpty()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public DasObject getDbParent() {
        return this.parent();
    }

    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = this.kind();
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "getKind"));
        }
        return objectKind;
    }

    @NotNull
    public Family<? extends DbmObject> getParentFamily() {
        assert (this.myParentFamily != null);
        Family<? extends DbmObject> family = this.myParentFamily;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "getParentFamily"));
        }
        return family;
    }

    public boolean isSyncPending() {
        return this.mySyncPending;
    }

    public void markSyncPending() {
        this.mySyncPending = true;
    }

    public void resetSyncPending() {
        this.mySyncPending = false;
    }

    public boolean isDropped() {
        return this.myDropped;
    }

    void attachForwardReference(@NotNull DbmRef.ResolvedRef<? extends DbmObject, ? extends DbmObject> ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/dbm/common/DbmObject", "attachForwardReference"));
        }
        assert (ref.source == this);
        this.model.forwardRefs.putValue((Object)this, ref);
    }

    void attachBackwardReference(@NotNull DbmRef.ResolvedRef<? extends DbmObject, ? extends DbmObject> ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/dbm/common/DbmObject", "attachBackwardReference"));
        }
        assert (ref.target == this);
        this.model.backwardRefs.putValue((Object)this, ref);
    }

    void detachForwardReference(@NotNull DbmRef.ResolvedRef<? extends DbmObject, ? extends DbmObject> ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/dbm/common/DbmObject", "detachForwardReference"));
        }
        this.model.forwardRefs.remove((Object)this, ref);
    }

    void detachBackwardReference(@NotNull DbmRef.ResolvedRef<? extends DbmObject, ? extends DbmObject> ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/dbm/common/DbmObject", "detachBackwardReference"));
        }
        this.model.backwardRefs.remove((Object)this, ref);
    }

    void detachAllReferences() {
        this.myListeners = null;
        List refs = JBIterable.from((Iterable)this.model.backwardRefs.get((Object)this)).append((Iterable)this.model.forwardRefs.get((Object)this)).toList();
        if (refs.isEmpty()) {
            return;
        }
        this.model.backwardRefs.get((Object)this).clear();
        this.model.forwardRefs.get((Object)this).clear();
        for (DbmRef.ResolvedRef r : ContainerUtil.reverse((List)refs)) {
            r.drop();
        }
    }

    public <T extends DbmObject> JBIterable<DbmRef.ResolvedRef<? extends DbmObject, ? extends T>> forwardReferences(@NotNull Class<T> targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/dbm/common/DbmObject", "forwardReferences"));
        }
        return JBIterable.from((Iterable)this.model.forwardRefs.get((Object)this)).transform(DbmUtil.CAST_REF_TARGET(targetClass)).filter(Conditions.notNull());
    }

    public <R extends DbmObject> JBIterable<DbmRef.ResolvedRef<? extends R, ? extends DbmObject>> backwardReferences(@NotNull Class<R> sourceClass) {
        if (sourceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceClass", "com/intellij/dbm/common/DbmObject", "backwardReferences"));
        }
        return JBIterable.from((Iterable)this.model.backwardRefs.get((Object)this)).transform(DbmUtil.CAST_REF_SOURCE(sourceClass)).filter(Conditions.notNull());
    }

    @NotNull
    public @NotNull Collection<DbmRef.ResolvedRef<@NotNull ? extends DbmObject, @NotNull ? extends DbmObject>> referencesOn(@NotNull DbmObject target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/dbm/common/DbmObject", "referencesOn"));
        }
        List refs = ContainerUtil.newSmartList();
        Class<?> targetClass = target.getClass();
        this.forwardReferences(targetClass).filter(Conditions.compose(DbmUtil.REF_TARGET, (Condition)Conditions.equalTo((Object)target))).addAllTo((Collection)refs);
        List list = refs;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "referencesOn"));
        }
        return list;
    }

    void registerListener(@NotNull DbmObjectListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/dbm/common/DbmObject", "registerListener"));
        }
        this.modifying();
        if (this.myListeners == null) {
            this.myListeners = new ArrayList<DbmObjectListener>(2);
        }
        this.myListeners.add(listener);
    }

    void deregisterListener(@NotNull DbmObjectListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/dbm/common/DbmObject", "deregisterListener"));
        }
        this.modifying();
        if (this.myListeners != null) {
            this.myListeners.remove(listener);
            if (this.myListeners.isEmpty()) {
                this.myListeners = null;
            }
        }
    }

    public ObjectsRef<DbmObject, DbmObject> internalDependencies() {
        return this.myInternalDependencies;
    }

    protected Resolver<? extends DbmObject> generalResolver() {
        return this.myGeneralResolver;
    }

    @Override
    @Nullable
    public DbmNode parentNode() {
        return this.myParentFamily;
    }

    @Override
    @NotNull
    public Collection<? extends DbmNode> childNodes() {
        ImmutableList<Family<? extends DbmObject>> immutableList = this.families();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmObject", "childNodes"));
        }
        return immutableList;
    }

    public String toString() {
        String desc;
        String thisClassName;
        String id;
        try {
            id = this.identity(true);
        }
        catch (Exception e) {
            thisClassName = this.getClass().getSimpleName();
            id = "unidentified object of " + thisClassName;
            DbmUtil.LOG.warn("Failed to compute the identity of an instance of class " + thisClassName + ": " + e.getMessage());
        }
        try {
            desc = this.description(true);
        }
        catch (Exception e) {
            thisClassName = this.getClass().getSimpleName();
            desc = "non-described object of " + thisClassName;
            DbmUtil.LOG.warn("Failed to compute the description of an instance of class " + thisClassName + ": " + e.getMessage());
        }
        return id + ": " + desc;
    }

    public class GeneralResolver
    implements Resolver<DbmObject> {
        @Override
        @Nullable
        public DbmObject resolve(@NotNull RelativeReference p) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/dbm/common/DbmObject$GeneralResolver", "resolve"));
            }
            return this.resolve2(p.path, p.args);
        }

        @Override
        @Nullable
        public DbmObject resolve(String ... path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/dbm/common/DbmObject$GeneralResolver", "resolve"));
            }
            return this.resolve2(path, null);
        }

        @Override
        @Nullable
        public DbmObject resolve2(@NotNull String[] path, @Nullable String[] args) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/dbm/common/DbmObject$GeneralResolver", "resolve2"));
            }
            int n = path.length;
            switch (n) {
                case 1: {
                    DbmObject object = null;
                    object = this.findInnerChild(path[0], args);
                    DbmObject parent = DbmObject.this.parent();
                    if (parent != null) {
                        object = parent.findChild(DbmObject.class, path[0], args);
                    }
                    return object;
                }
                case 0: {
                    return null;
                }
            }
            return DbmObject.this.schema().generalResolver().resolve(path);
        }

        private DbmObject findInnerChild(String name, String[] args) {
            if (args == null) {
                return DbmObject.this.findChild(DbmObject.class, name);
            }
            return DbmObject.this.findChild(DbmObject.class, name, args);
        }
    }
}

