/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Comparator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum TableOrganization {
    DEFAULT(null),
    HEAP("E"),
    INDEX("I"),
    ORA_CLUSTERED_BY_INDEX("OCI"),
    ORA_CLUSTERED_BY_HASH("OCH"),
    EXTERNAL("X");

    public final String code;
    @NotNull
    private static final Map<String, TableOrganization> mapByCodes;

    private TableOrganization(String code) {
        this.code = code;
    }

    @NotNull
    public static TableOrganization byCode(String code) {
        TableOrganization organization = mapByCodes.get(code);
        TableOrganization tableOrganization = organization != null ? organization : DEFAULT;
        if (tableOrganization == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/TableOrganization", "byCode"));
        }
        return tableOrganization;
    }

    static {
        mapByCodes = ImmutableSortedMap.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER).put((Object)TableOrganization.HEAP.code, (Object)HEAP).put((Object)TableOrganization.INDEX.code, (Object)INDEX).put((Object)TableOrganization.ORA_CLUSTERED_BY_INDEX.code, (Object)ORA_CLUSTERED_BY_INDEX).put((Object)TableOrganization.ORA_CLUSTERED_BY_HASH.code, (Object)ORA_CLUSTERED_BY_HASH).put((Object)TableOrganization.EXTERNAL.code, (Object)EXTERNAL).build();
    }
}

