/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.mssql;

import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.StateProperty;
import com.intellij.dbm.mssql.MsDatabase;
import com.intellij.dbm.mssql.MsType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsTableType
extends DbmLikeTable
implements MsType {
    @StateProperty
    public int myTypeId;

    public MsTableType(@NotNull DbmSchema schema, @Nullable String name) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/mssql/MsTableType", "<init>"));
        }
        super(schema, name);
        this.assignFamilies(this.myColumns, this.myIndices, this.myKeys, this.myChecks);
    }

    @Override
    @NotNull
    public ObjectKind kind() {
        ObjectKind objectKind = ObjectKind.TABLE_TYPE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mssql/MsTableType", "kind"));
        }
        return objectKind;
    }

    @Override
    public int getTypeId() {
        return this.myTypeId;
    }

    @Override
    public void setTypeId(int typeId) {
        if (this.myTypeId == typeId) {
            return;
        }
        this.modifying();
        int oldTypeId = this.myTypeId;
        this.myTypeId = typeId;
        ((MsDatabase)this.schema().database).justTypeIdChanged(this, oldTypeId, typeId);
    }

    @Override
    protected void dissociateIdentifiers() {
        super.dissociateIdentifiers();
        this.setTypeId(0);
    }
}

