/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.oracle;

import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmArgument;
import com.intellij.dbm.common.DbmOperator;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.RoutineUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OracleOperator
extends DbmOperator {
    final Family<DbmArgument> myArguments;

    public OracleOperator(@NotNull DbmSchema schema, @Nullable String name) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/oracle/OracleOperator", "<init>"));
        }
        super(schema, name);
        this.myArguments = Family.of(this, ObjectKind.ARGUMENT);
        this.assignFamilies(this.myArguments);
    }

    @NotNull
    public Family<DbmArgument> arguments() {
        Family<DbmArgument> family = this.myArguments;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OracleOperator", "arguments"));
        }
        return family;
    }

    @Override
    public String[] getSpecItems() {
        return RoutineUtil.makeSpecItemsByInArguments(this.myArguments);
    }

    @Override
    public void setSpecItems(String[] specItems) {
        RoutineUtil.assignSpecItems(this.myArguments, specItems);
    }

    @Override
    public boolean isApplicableTo(String[] specItems) {
        return RoutineUtil.checkSpecItemsAreEqual(this.myArguments, specItems);
    }
}

