/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.postgres;

import com.google.common.collect.ImmutableList;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DataTypeFactory;
import com.intellij.dbm.common.BaseIntrospector;
import com.intellij.dbm.common.DBIntrospectionError;
import com.intellij.dbm.common.DbmArgument;
import com.intellij.dbm.common.DbmCheck;
import com.intellij.dbm.common.DbmColumn;
import com.intellij.dbm.common.DbmConstraint;
import com.intellij.dbm.common.DbmForeignKey;
import com.intellij.dbm.common.DbmIndex;
import com.intellij.dbm.common.DbmKey;
import com.intellij.dbm.common.DbmLikeColumn;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmSequence;
import com.intellij.dbm.common.DbmTable;
import com.intellij.dbm.common.DbmView;
import com.intellij.dbm.common.DomObjectsRef;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.IntrospectionUtil;
import com.intellij.dbm.common.LongIdName;
import com.intellij.dbm.common.TrigEvent;
import com.intellij.dbm.common.TrigTurn;
import com.intellij.dbm.postgres.PostgresDataType;
import com.intellij.dbm.postgres.PostgresDataTypeAttribute;
import com.intellij.dbm.postgres.PostgresDatabase;
import com.intellij.dbm.postgres.PostgresIntroQueries;
import com.intellij.dbm.postgres.PostgresModel;
import com.intellij.dbm.postgres.PostgresOperator;
import com.intellij.dbm.postgres.PostgresRoutine;
import com.intellij.dbm.postgres.PostgresRuleOrTrigger;
import com.intellij.dbm.postgres.PostgresSchema;
import com.intellij.dbm.postgres.PostgresTable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.Predicate;
import gnu.trove.TLongHashSet;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.sql.SqlQuery;

public class PostgresIntrospector
extends BaseIntrospector<PostgresSchema, PostgresModel> {
    static final short POSITION_OF_XMIN = -3;
    static final short POSITION_OF_OID = -2;
    private static final Logger LOG = Logger.getInstance(PostgresIntrospector.class);
    private final PostgresIntroQueries myQueries;
    private static final char[] NO_CHARS = new char[0];
    private static final Pattern SEQUENCE_PARAMS_PATTERN = Pattern.compile("\\((\\d+),(\\d+),(\\d+),(\\d+),([FfTt])\\)");
    private static final BigInteger SEQUENCE_DEFAULT_MAX = new BigInteger("9223372036854775807");

    public PostgresIntrospector(@NotNull DBFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/dbm/postgres/PostgresIntrospector", "<init>"));
        }
        super(facade);
        this.myQueries = PostgresIntroQueries.QUERIES;
    }

    @Override
    protected boolean modelCanBeAccepted(@Nullable DbmModel model) {
        return model instanceof PostgresModel;
    }

    @Override
    @NotNull
    protected PostgresModel createNewModel() {
        PostgresModel postgresModel = new PostgresModel();
        if (postgresModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresIntrospector", "createNewModel"));
        }
        return postgresModel;
    }

    @Override
    public void introspectNamespaces(@NotNull DBTransaction tran) {
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector", "introspectNamespaces"));
        }
        List dbs = (List)tran.query(this.myQueries.listDatabases).run();
        List scs = (List)tran.query(this.myQueries.listSchemas).run();
        this.applyDatabasesAndSchemas(dbs, scs);
    }

    private void applyDatabasesAndSchemas(final @NotNull List<LongIdName> dbs, final @NotNull List<LongIdName> scs) {
        if (dbs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbs", "com/intellij/dbm/postgres/PostgresIntrospector", "applyDatabasesAndSchemas"));
        }
        if (scs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scs", "com/intellij/dbm/postgres/PostgresIntrospector", "applyDatabasesAndSchemas"));
        }
        this.withModel(new BaseIntrospector.SimpleModelWorker<PostgresModel>(){

            @Override
            public void working(PostgresModel model) {
                PostgresDatabase currentDatabase = null;
                Family databases = model.databases();
                databases.markChildrenAsSyncPending();
                boolean first = true;
                for (LongIdName db : dbs) {
                    PostgresDatabase database = (PostgresDatabase)databases.renew(db.id, db.name);
                    if (!first) continue;
                    first = false;
                    currentDatabase = database;
                    currentDatabase.setVisible(true);
                    model.setCurrentDatabase(currentDatabase);
                }
                databases.removeSyncPendingChildren();
                if (currentDatabase != null) {
                    Family<PostgresSchema> schemas = currentDatabase.schemas();
                    boolean noSchemas = schemas.isEmpty();
                    schemas.markChildrenAsSyncPending();
                    first = true;
                    for (LongIdName sc : scs) {
                        PostgresSchema schema = schemas.renew(sc.id, sc.name);
                        if (!first) continue;
                        first = false;
                        currentDatabase.setCurrentSchema(schema);
                        if (!noSchemas) continue;
                        schema.setVisible(true);
                    }
                    schemas.removeSyncPendingChildren();
                }
            }
        });
    }

    @Override
    protected void introspectAuto(@NotNull DBTransaction tran, DbmNamespace[] namespaces) {
        boolean toList;
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector", "introspectAuto"));
        }
        boolean bl = toList = namespaces == null || namespaces.length == 0 || !JBIterable.of((Object[])namespaces).filter(PostgresDatabase.class).isEmpty();
        if (toList) {
            this.introspectNamespaces(tran);
        }
        PostgresDatabase currentDatabase = (PostgresDatabase)((PostgresModel)this.getModel()).getCurrentDatabase();
        assert (currentDatabase != null) : "The current database should exist";
        List schemasToIntrospect = namespaces != null && namespaces.length > 0 ? JBIterable.of((Object[])namespaces).filter(PostgresSchema.class).toList() : JBIterable.from(currentDatabase.schemas()).filter(DbmNamespace::isVisible).toList();
        for (PostgresSchema schema : schemasToIntrospect) {
            SchemaRetriever retriever = new SchemaRetriever(schema);
            retriever.retrieve(tran);
        }
        this.postIntrospectionProcess(this.getModel());
    }

    @Contract(value="null->false")
    private static boolean isNotEmpty(@Nullable long[] array) {
        return array != null && array.length > 0;
    }

    private static int length(Object[] array) {
        return array != null ? array.length : 0;
    }

    private static int length(long[] array) {
        return array != null ? array.length : 0;
    }

    @Contract(value="!null -> !null; null -> null")
    private static DataType dataTypeOf(@Nullable String spec) {
        if (spec == null) {
            return null;
        }
        String s = PostgresIntrospector.normalizeDataTypeSpec(spec);
        return DataTypeFactory.of(s);
    }

    @Contract(value="!null -> !null; null -> null")
    private static String normalizeDataTypeSpec(@Nullable String spec) {
        if (spec == null) {
            return null;
        }
        return spec.replace("character varying", "varchar").replace("character", "char").replace("char(1)", "char").replace("bit(1)", "bit").replace(" without time zone", "");
    }

    @NotNull
    public static String normalizeDefaultExpression(@NotNull String expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/dbm/postgres/PostgresIntrospector", "normalizeDefaultExpression"));
        }
        String string = expression.replace("::character varying", "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresIntrospector", "normalizeDefaultExpression"));
        }
        return string;
    }

    static void assignRefColumns(@Nullable String columnPositions, @NotNull String what, @NotNull Family<? extends DbmLikeColumn> columns, @NotNull DomObjectsRef<DbmLikeColumn> ref) {
        if (what == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/dbm/postgres/PostgresIntrospector", "assignRefColumns"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/dbm/postgres/PostgresIntrospector", "assignRefColumns"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/dbm/postgres/PostgresIntrospector", "assignRefColumns"));
        }
        short[] positions = PostgresIntrospector.parseArrayOfPositions(columnPositions, what);
        int n = positions.length;
        String[] names = new String[n];
        block4: for (int i = 0; i < n; ++i) {
            short position = positions[i];
            if (position > 0) {
                DbmLikeColumn column = columns.getByNaturalPosition(position);
                if (column == null) continue;
                names[i] = column.getNameOrNull();
                continue;
            }
            if (position >= 0) continue;
            switch (position) {
                case -3: {
                    names[i] = "xmin";
                    continue block4;
                }
                case -2: {
                    names[i] = "oid";
                }
            }
        }
        ref.setNames(names);
    }

    private static short[] parseArrayOfPositions(@Nullable String str, @NotNull String what) {
        if (what == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/dbm/postgres/PostgresIntrospector", "parseArrayOfPositions"));
        }
        Object[] s = PostgresIntrospector.parseArrayOfStrings(str);
        int n = PostgresIntrospector.length(s);
        if (n == 0) {
            return new short[0];
        }
        short[] positions = new short[n];
        try {
            for (int i = 0; i < n; ++i) {
                positions[i] = Short.parseShort((String)s[i]);
            }
        }
        catch (NumberFormatException nfe) {
            throw new PostgresIntrospectionException(String.format("Cannot parse %s: '%s'", what, str), nfe);
        }
        return positions;
    }

    private static char[] stringsToChars(@Nullable String[] strings) {
        int n = PostgresIntrospector.length(strings);
        if (n == 0) {
            return NO_CHARS;
        }
        char[] chars = new char[n];
        for (int i = 0; i < n; ++i) {
            chars[i] = strings[i] != null && strings[i].length() > 0 ? strings[i].charAt(0) : (char)'\u0000';
        }
        return chars;
    }

    @NotNull
    private static String[] parseArrayOfStrings(@Nullable String str) {
        int len;
        int n = len = str == null ? 0 : str.length();
        if (len == 0) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresIntrospector", "parseArrayOfStrings"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] s = len >= 2 && str.charAt(0) == '{' && str.charAt(len - 1) == '}' ? str.substring(1, len - 1).split(",") : str.split(" ");
        if (s == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresIntrospector", "parseArrayOfStrings"));
        }
        return s;
    }

    private static void assignSequenceParams(@NotNull DbmSequence sequence, @NotNull String sequenceParams) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/dbm/postgres/PostgresIntrospector", "assignSequenceParams"));
        }
        if (sequenceParams == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequenceParams", "com/intellij/dbm/postgres/PostgresIntrospector", "assignSequenceParams"));
        }
        Matcher m = SEQUENCE_PARAMS_PATTERN.matcher(sequenceParams);
        if (m.find()) {
            try {
                BigInteger next = PostgresIntrospector.makeBigInteger(m.group(1), BigInteger.ONE);
                BigInteger min = PostgresIntrospector.makeBigInteger(m.group(2), BigInteger.ONE);
                BigInteger max = PostgresIntrospector.makeBigInteger(m.group(3), SEQUENCE_DEFAULT_MAX);
                BigInteger inc = PostgresIntrospector.makeBigInteger(m.group(4), BigInteger.ONE);
                boolean cycled = m.group(5).toLowerCase(Locale.ROOT).contains("t");
                sequence.setMinValue(min);
                sequence.setMaxValue(max);
                sequence.setNextValue(next);
                sequence.setIncrementBy(inc);
                sequence.setCycled(cycled);
            }
            catch (Exception e) {
                sequence.resetParameters();
                LOG.debug("Unexpected exception when assigning Postgres sequence parameters. The parameters string: " + sequenceParams + ". Exception message: " + e.getMessage(), (Throwable)e);
            }
        } else {
            sequence.resetParameters();
            LOG.debug("Unexpected format of the Postgres sequence parameters string: " + sequenceParams);
        }
    }

    @Nullable
    private static BigInteger makeBigInteger(@Nullable String stringValue, @Nullable BigInteger implicitAssumption) {
        if (stringValue == null) {
            return null;
        }
        BigInteger value = new BigInteger(stringValue);
        return value.equals(implicitAssumption) ? null : value;
    }

    public static class PostgresIntrospectionException
    extends DBIntrospectionError {
        public PostgresIntrospectionException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private final class SchemaRetriever {
        private final PostgresSchema mySchema;
        private boolean myWithSources;
        private long myFromStateNumber;
        private long myBeginIntrospectionSchemaStateNumber;
        private Timestamp myBeginIntrospectionTimestamp;
        private boolean myIncremental;
        private Map<Long, DataType> myTypes;
        private boolean wasEnums;
        private boolean wasStructures;
        private boolean wasTables;
        private boolean wasViews;
        private boolean wasMatViews;
        private static final char REL_TABLE = 'r';
        private static final char REL_MAT_VIEW = 'm';
        private static final char REL_VIEW = 'v';
        private static final char REL_ANY = '\u0000';

        SchemaRetriever(PostgresSchema schema) {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "<init>"));
            }
            this.mySchema = schema;
            this.myWithSources = false;
        }

        private void progress(@NotNull String what) {
            if (what == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "progress"));
            }
            String mode = this.myIncremental ? "incrementally" : "completely";
            PostgresIntrospector.this.updateStatus(String.format("Introspecting schema %s (%s)", this.mySchema.getName(), mode), what);
        }

        private void work(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "work"));
            }
            this.mySchema.getModel().startModifications();
            try {
                runnable.run();
            }
            finally {
                this.mySchema.getModel().finishModifications();
            }
        }

        void retrieve(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "retrieve"));
            }
            this.obtainSchemaState(tran);
            if (this.myIncremental) {
                this.work(() -> {
                    if (tran == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "lambda$retrieve$0"));
                    }
                    this.determineAndRemoveDroppedClasses(tran);
                });
                if (this.mySchema.getIntrospectionStateNumber() == this.myBeginIntrospectionSchemaStateNumber) {
                    return;
                }
            } else {
                this.work(() -> {
                    ImmutableList families = this.mySchema.families().asList();
                    for (int i = families.size() - 1; i >= 0; --i) {
                        ((Family)families.get(i)).clear();
                    }
                });
            }
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "lambda$retrieve$2"));
                }
                this.retrieveSequences(tran);
                this.retrieveDataTypes(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "lambda$retrieve$3"));
                }
                this.retrieveTables(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "lambda$retrieve$4"));
                }
                this.obtainUsedTypes(tran);
                this.retrieveRoutines(tran);
                this.retrieveOperators(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "lambda$retrieve$5"));
                }
                this.retrieveStructAttributes(tran);
                this.retrieveEnumLabels(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "lambda$retrieve$6"));
                }
                this.retrieveTableColumns(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "lambda$retrieve$7"));
                }
                this.retrieveIndices(tran);
                this.retrieveConstraints(tran);
                this.retrieveRules(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "lambda$retrieve$8"));
                }
                this.retrieveDescriptions(tran);
            });
            if (this.myWithSources) {
                this.work(() -> {
                    if (tran == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "lambda$retrieve$9"));
                    }
                    this.retrieveViewSources(tran);
                });
            }
            this.work(() -> this.mySchema.setIntrospectionActualPoint(this.myBeginIntrospectionSchemaStateNumber, this.myBeginIntrospectionTimestamp));
        }

        private void obtainSchemaState(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "obtainSchemaState"));
            }
            Timestamp currentTimestamp = (Timestamp)tran.query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.now).run();
            long schemaId = this.mySchema.getObjectId();
            Long currentSchemaTX = (Long)tran.query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.countSchemaStateNumber).withParams(new Object[]{schemaId, schemaId, schemaId, schemaId, schemaId, schemaId}).run();
            long currentSchemaStateNumber = currentSchemaTX != null ? currentSchemaTX : 0L;
            long knownSchemaStateNumber = this.mySchema.getIntrospectionStateNumber();
            this.myIncremental = knownSchemaStateNumber >= 0L && currentSchemaStateNumber >= knownSchemaStateNumber && this.mySchema.hasChildren();
            this.myFromStateNumber = this.myIncremental ? knownSchemaStateNumber : 0L;
            this.myBeginIntrospectionSchemaStateNumber = currentSchemaStateNumber;
            this.myBeginIntrospectionTimestamp = currentTimestamp;
        }

        private void determineAndRemoveDroppedClasses(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "determineAndRemoveDroppedClasses"));
            }
            long schemaId = this.mySchema.getObjectId();
            long[] existentIdsArray = (long[])tran.query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.listExistentClasses).withParams(new Object[]{schemaId, schemaId, schemaId, schemaId, schemaId}).run();
            TLongHashSet existentIds = new TLongHashSet(existentIdsArray);
            IntrospectionUtil.removeDroppedChildren(existentIds, this.mySchema.sequences(), this.mySchema.dataTypes(), this.mySchema.tables(), this.mySchema.matViews(), this.mySchema.views(), this.mySchema.routines(), this.mySchema.operators(), this.mySchema.synonyms());
            ArrayList<Family<DbmConstraint>> minorFamilies = new ArrayList<Family<DbmConstraint>>(this.mySchema.tables().size() * 3);
            for (DbmTable dbmTable : this.mySchema.tables()) {
                minorFamilies.add(dbmTable.keys());
                minorFamilies.add(dbmTable.foreignKeys());
                minorFamilies.add(dbmTable.checks());
            }
            IntrospectionUtil.removeDroppedChildren(existentIds, minorFamilies.toArray(new Family[minorFamilies.size()]));
        }

        private void retrieveSequences(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "retrieveSequences"));
            }
            this.progress("sequences");
            SqlQuery<List<PostgresIntroQueries.OneSequence>> query = PostgresIntrospector.this.myServerVersion.isOrGreater(new int[]{9, 1}) ? ((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveSequences91 : ((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveSequences90;
            List sqs = (List)tran.query(query).withParams(new Object[]{this.mySchema.getObjectId(), this.myFromStateNumber}).run();
            if (sqs.isEmpty()) {
                return;
            }
            for (PostgresIntroQueries.OneSequence sq : sqs) {
                DbmSequence sequence = this.mySchema.sequences().getOrCreate(sq.sequence_name);
                sequence.setObjectIdAndStateNumber(sq.sequence_id, sq.sequence_state_number);
                String sequenceParams = sq.sequence_params;
                if (StringUtil.isEmptyOrSpaces((String)sequenceParams)) continue;
                PostgresIntrospector.assignSequenceParams(sequence, sequenceParams);
            }
            this.mySchema.sequences().reorder();
        }

        private void retrieveDataTypes(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "retrieveDataTypes"));
            }
            this.progress("data types");
            List dts = (List)tran.query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveDataTypes).withParams(new Object[]{this.mySchema.getObjectId(), this.myFromStateNumber}).run();
            if (dts.isEmpty()) {
                return;
            }
            for (PostgresIntroQueries.OneDataType dt : dts) {
                PostgresDataType.SubKind subKind = PostgresDataType.SubKind.of(dt.type_sub_kind);
                PostgresDataType dataType = this.mySchema.dataTypes().renew(dt.type_id, dt.type_name);
                dataType.setStateNumber(dt.type_state_number);
                dataType.setSubKind(subKind);
                dataType.setSubCategory(PostgresDataType.SubCategory.of(dt.type_category));
                dataType.setDefinition(PostgresIntrospector.normalizeDataTypeSpec(dt.type_def));
                dataType.attributes().clear();
                dataType.labels.clearState();
                this.wasEnums |= subKind == PostgresDataType.SubKind.ENUM;
                this.wasStructures |= subKind == PostgresDataType.SubKind.COMPOSITE;
            }
        }

        private void retrieveTables(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "retrieveTables"));
            }
            this.progress("tables and views");
            List ts = (List)tran.query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveTables).withParams(new Object[]{this.mySchema.getObjectId(), this.myFromStateNumber}).run();
            if (ts.isEmpty()) {
                return;
            }
            for (PostgresIntroQueries.OneTable t : ts) {
                DbmLikeTable table = this.renewTableOrView(t.table_kind, t.table_id, t.table_name);
                if (table == null) continue;
                table.setStateNumber(t.table_state_number);
                if (t.table_with_oids && table instanceof PostgresTable) {
                    ((PostgresTable)table).setWithOids(true);
                }
                if (t.tablespace_id > 0L) {
                    // empty if block
                }
                this.wasTables |= t.table_kind == 'r';
                this.wasViews |= t.table_kind == 'v';
                this.wasMatViews |= t.table_kind == 'm';
            }
            if (this.wasTables) {
                this.mySchema.tables().reorder();
            }
            if (this.wasViews) {
                this.mySchema.views().reorder();
            }
            if (this.wasMatViews) {
                this.mySchema.matViews().reorder();
            }
        }

        private void retrieveStructAttributes(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "retrieveStructAttributes"));
            }
            if (!this.wasStructures) {
                return;
            }
            this.progress("struct attributes");
            List ats = (List)tran.query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveStructAttributes).withParams(new Object[]{this.mySchema.getObjectId(), this.myFromStateNumber}).run();
            for (PostgresIntroQueries.OneStructAttribute at : ats) {
                PostgresDataType dataType = this.mySchema.dataTypes().getByObjectId(at.type_id);
                if (dataType == null) {
                    return;
                }
                PostgresDataTypeAttribute attribute = dataType.attributes().create(at.att_name);
                if (at.att_type == null) continue;
                DataType attributeType = DataTypeFactory.of(PostgresIntrospector.normalizeDataTypeSpec(at.att_type));
                attribute.setDataType(attributeType);
            }
        }

        private void retrieveEnumLabels(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "retrieveEnumLabels"));
            }
            if (!this.wasEnums) {
                return;
            }
            this.progress("enums");
            SqlQuery<Map<Long, String[]>> query = PostgresIntrospector.this.myServerVersion.isOrGreater(new int[]{9, 1}) ? ((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveEnumLabels91 : ((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveEnumLabels90;
            Map els = (Map)tran.query(query).withParams(new Object[]{this.mySchema.getObjectId(), this.myFromStateNumber}).run();
            for (Map.Entry entry : els.entrySet()) {
                PostgresDataType dataType;
                long type_id = (Long)entry.getKey();
                String[] labels = (String[])entry.getValue();
                if (type_id == 0L || labels == null || labels.length == 0 || (dataType = this.mySchema.dataTypes().getByObjectId(type_id)) == null) continue;
                dataType.labels.assign(labels);
            }
        }

        private void obtainUsedTypes(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "obtainUsedTypes"));
            }
            Map typeSpecs = (Map)tran.query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveUsedArgumentTypes).withParams(new Object[]{this.mySchema.getObjectId(), this.myFromStateNumber}).run();
            this.myTypes = new HashMap<Long, DataType>(typeSpecs.size());
            for (Map.Entry entry : typeSpecs.entrySet()) {
                Long typeId = (Long)entry.getKey();
                String typeSpec = (String)entry.getValue();
                typeSpec = PostgresIntrospector.normalizeDataTypeSpec(typeSpec);
                DataType type = DataTypeFactory.of(typeSpec);
                this.myTypes.put(typeId, type);
            }
        }

        private void retrieveRoutines(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "retrieveRoutines"));
            }
            assert (this.myTypes != null) : "Types must be obtained before retrieving routines";
            this.progress("routines");
            List rs = (List)tran.query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveRoutines).withParams(new Object[]{this.mySchema.getObjectId(), this.myFromStateNumber}).run();
            if (rs.isEmpty()) {
                return;
            }
            for (PostgresIntroQueries.OneRoutine r : rs) {
                PostgresRoutine routine = this.mySchema.routines().renew(r.r_id, r.r_name);
                routine.setStateNumber(r.r_state_number);
                routine.setRoutineKind(r.ret_type_id == 0L ? DasRoutine.Kind.PROCEDURE : DasRoutine.Kind.FUNCTION);
                routine.setReturnsSet(r.ret_set);
                Object[] argNames = r.arg_names;
                char[] argDirections = PostgresIntrospector.stringsToChars(r.arg_modes);
                long[] argTypeIds = PostgresIntrospector.isNotEmpty(r.all_arg_types) ? r.all_arg_types : r.in_arg_types;
                int argNamesCount = PostgresIntrospector.length(argNames);
                int n = Math.max(Math.max(argNamesCount, argDirections.length), PostgresIntrospector.length(argTypeIds));
                String resultType = null;
                StringBuilder resultArguments = null;
                for (int i = 0; i < n; ++i) {
                    DataType dt;
                    DasArgument.Direction direction;
                    if (i < argDirections.length) {
                        char d = argDirections[i];
                        switch (d) {
                            case 'b': {
                                direction = DasArgument.Direction.INOUT;
                                break;
                            }
                            case 'o': {
                                direction = DasArgument.Direction.OUT;
                                break;
                            }
                            case 't': {
                                direction = DasArgument.Direction.RESULT;
                                break;
                            }
                            default: {
                                direction = DasArgument.Direction.IN;
                                break;
                            }
                        }
                    } else {
                        direction = DasArgument.Direction.IN;
                    }
                    Object argName = i < argNamesCount ? argNames[i] : null;
                    DataType dataType = DataType.UNKNOWN;
                    if (i < argTypeIds.length && (dt = this.myTypes.get(argTypeIds[i])) != null) {
                        dataType = dt;
                    }
                    if (r.ret_set && direction == DasArgument.Direction.RESULT) {
                        if (resultType == null || resultArguments == null) {
                            resultType = "table";
                            resultArguments = new StringBuilder();
                        } else {
                            resultArguments.append(", ");
                        }
                        if (argName != null) {
                            resultArguments.append((String)argName).append(' ');
                        }
                        resultArguments.append(dataType.getSpecification());
                        continue;
                    }
                    short position = (short)(i + 1);
                    DbmArgument argument = routine.arguments().getByNaturalPosition(position);
                    if (argument == null) {
                        argument = routine.arguments().create((String)argName);
                        argument.setPosition(position);
                    } else {
                        argument.setName((String)argName);
                        argument.resetSyncPending();
                    }
                    argument.setDirection(direction);
                    argument.setDataType(dataType);
                }
                if (resultType != null) {
                    DataType resultDataType = DataTypeFactory.of(null, resultType, resultArguments.toString(), null);
                    DbmArgument returns = routine.getOrCreateReturnArgument();
                    returns.setDirection(DasArgument.Direction.RESULT);
                    returns.setDataType(resultDataType);
                } else if (r.ret_type_id != 0L) {
                    DbmArgument returns = routine.getOrCreateReturnArgument();
                    returns.setDirection(DasArgument.Direction.RETURN);
                    DataType retType = this.myTypes.get(r.ret_type_id);
                    if (r.ret_set) {
                        String retTypeSpec = "setof " + retType.getSpecification();
                        retType = DataTypeFactory.of(null, retTypeSpec, null, null);
                    }
                    returns.setDataType(retType);
                }
                if (r.arg_defaults != null) {
                    String[] defaults = r.arg_defaults.split(",\\s+");
                    DbmArgument[] arguments = routine.arguments().toArray(new DbmArgument[0]);
                    int k = defaults.length - 1;
                    for (int i = arguments.length - 1; i >= 0; --i) {
                        DbmArgument a = arguments[i];
                        if (a.getDirection().isIn()) {
                            if (k >= 0) {
                                String theDefaultExpression = PostgresIntrospector.normalizeDefaultExpression(defaults[k]);
                                a.setDefaultExpression(theDefaultExpression);
                                --k;
                                continue;
                            }
                            a.setDefaultExpression(null);
                            continue;
                        }
                        a.setDefaultExpression(null);
                    }
                } else {
                    for (DbmArgument a : routine.arguments()) {
                        a.setDefaultExpression(null);
                    }
                }
                routine.arguments().removeSyncPendingChildren();
            }
            this.mySchema.routines().reorder();
        }

        private void retrieveOperators(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "retrieveOperators"));
            }
            assert (this.myTypes != null) : "Types must be obtained before retrieving operators";
            this.progress("operators");
            List ops = (List)tran.query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveOperators).withParams(new Object[]{this.mySchema.getObjectId(), this.myFromStateNumber}).run();
            if (ops.isEmpty()) {
                return;
            }
            for (PostgresIntroQueries.OneOperator op : ops) {
                PostgresOperator operator = this.mySchema.operators().renew(op.op_id, op.op_name);
                operator.setOperatorKind(PostgresOperator.OperatorKind.of(op.op_kind));
                operator.setLeftType(op.arg_left_type_id > 0L ? this.myTypes.get(op.arg_left_type_id) : null);
                operator.setRightType(op.arg_right_type_id > 0L ? this.myTypes.get(op.arg_right_type_id) : null);
                operator.setResultType(op.arg_result_type_id > 0L ? this.myTypes.get(op.arg_result_type_id) : null);
                if (op.func_main != null) {
                    String[] bindPath = op.func_main.split("\\.");
                    String[] specItems = operator.getSpecItems();
                    operator.bindFunction.set(bindPath, specItems);
                    continue;
                }
                operator.bindFunction.clearState();
            }
            this.mySchema.operators().reorder();
        }

        private void retrieveTableColumns(@NotNull DBTransaction tran) {
            boolean toIntrospect;
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "retrieveTableColumns"));
            }
            boolean bl = toIntrospect = this.wasTables || this.wasMatViews || this.wasViews || this.myIncremental && this.mySchema.tables().isNotEmpty();
            if (!toIntrospect) {
                return;
            }
            this.progress("table columns");
            List cols = (List)tran.query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveColumns).withParams(new Object[]{this.mySchema.getObjectId(), this.myFromStateNumber}).run();
            if (cols.isEmpty()) {
                return;
            }
            HashSet<DbmLikeTable> affectedTables = new HashSet<DbmLikeTable>(this.mySchema.tables().size() + this.mySchema.views().size());
            DbmLikeTable table = null;
            long table_id = Long.MIN_VALUE;
            for (PostgresIntroQueries.OneColumn col : cols) {
                if (col.table_id != table_id) {
                    table = this.getTableOrView('\u0000', col.table_id);
                    if (table == null) continue;
                    table_id = col.table_id;
                    table.columns().markChildrenAsSyncPending();
                    affectedTables.add(table);
                }
                assert (table != null);
                Family<? extends DbmColumn> columns = table.columns();
                DbmColumn column = columns.getByNaturalPosition(col.column_position);
                if (column != null) {
                    column.setName(col.column_name);
                } else {
                    column = columns.getOrCreate(col.column_name);
                    column.setPosition(col.column_position);
                }
                column.resetSyncPending();
                column.setStateNumber(col.column_state_number);
                column.setDataType(PostgresIntrospector.dataTypeOf(col.type_spec));
                column.setMandatory(col.mandatory);
                column.setDefaultExpression(col.column_default_expression);
                if (col.column_name == null || !col.column_name.startsWith("?") || !col.column_name.endsWith("?")) continue;
                column.setNameSurrogate(true);
            }
            for (DbmLikeTable affectedTable : affectedTables) {
                affectedTable.columns().removeSyncPendingChildren();
                affectedTable.columns().reorder();
            }
        }

        private void retrieveIndices(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "retrieveIndices"));
            }
            this.progress("indices");
            List inds = (List)tran.query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveIndices).withParams(new Object[]{this.mySchema.getObjectId(), this.myFromStateNumber}).run();
            if (inds.isEmpty()) {
                return;
            }
            HashSet<DbmLikeTable> affectedTables = new HashSet<DbmLikeTable>(inds.size() / 2);
            for (PostgresIntroQueries.OneIndex ind : inds) {
                DbmLikeTable table = this.getTableOrView(ind.table_kind, ind.table_id);
                if (table == null) continue;
                affectedTables.add(table);
                DbmIndex index = table.indices().renew(ind.index_id, ind.index_name);
                index.setUnique(ind.is_unique);
                index.myColumns.clearState();
                PostgresIntrospector.assignRefColumns(ind.column_positions, "Index " + ind.index_name + " column positions", table.columns(), index.myColumns);
            }
            for (DbmLikeTable table : affectedTables) {
                table.indices().reorder();
            }
        }

        private void retrieveConstraints(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "retrieveConstraints"));
            }
            this.progress("constraints");
            List cons = (List)tran.query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveConstraints).withParams(new Object[]{this.mySchema.getObjectId(), this.myFromStateNumber}).run();
            if (cons.isEmpty()) {
                return;
            }
            HashSet<DbmLikeTable> affectedTables = new HashSet<DbmLikeTable>(cons.size() / 3);
            block5: for (final PostgresIntroQueries.OneConstraint con : cons) {
                DbmLikeTable table = this.getTableOrView(con.table_kind, con.table_id);
                if (table == null) continue;
                affectedTables.add(table);
                switch (con.con_kind) {
                    case 'p': 
                    case 'u': {
                        DbmKey key = table.keys().renew(con.con_id, con.con_name);
                        key.setPrimary(con.con_kind == 'p');
                        PostgresIntrospector.assignRefColumns(con.con_columns, "Key " + con.con_name + " column positions", table.columns(), key.myColumns);
                        DbmIndex index = table.indices().getByObjectId(con.index_id);
                        key.setUnderlyingIndex(index);
                        break;
                    }
                    case 'f': {
                        DbmForeignKey fkey = table.foreignKeys().renew(con.con_id, con.con_name);
                        PostgresIntrospector.assignRefColumns(con.con_columns, "Foreign key " + con.con_name + " domestic column positions", table.columns(), fkey.myColumns);
                        if (con.ref_table_id <= 0L || con.index_id <= 0L) break;
                        DbmTable refTable = this.mySchema.tables().getByObjectId(con.ref_table_id);
                        if (refTable == null) continue block5;
                        DbmKey refKey = refTable.keys().get((Predicate<? extends DbmKey>)new Predicate<DbmKey>(){

                            public boolean apply(@Nullable DbmKey k) {
                                assert (k != null);
                                return k.getUnderlyingIndex() != null && k.getUnderlyingIndex().getObjectId() == con.index_id;
                            }
                        });
                        fkey.refKey.set(refKey);
                        break;
                    }
                    case 'c': {
                        DbmCheck check = table.checks().renew(con.con_id, con.con_name);
                        PostgresIntrospector.assignRefColumns(con.con_columns, "Check " + con.con_name + " column positions", table.columns(), check.myColumns);
                        String predicate = con.con_expression;
                        int len = predicate.length();
                        if (len > 2 && predicate.charAt(0) == '(' && predicate.charAt(len - 1) == ')') {
                            predicate = predicate.substring(1, len - 1).trim();
                        }
                        check.setPredicate(predicate);
                    }
                }
            }
            for (DbmLikeTable table : affectedTables) {
                table.keys().reorder();
                table.foreignKeys().reorder();
                table.checks().reorder();
            }
        }

        private void retrieveRules(@NotNull DBTransaction tran) {
            boolean toIntrospect;
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "retrieveRules"));
            }
            boolean bl = toIntrospect = this.wasTables || this.wasMatViews || this.wasViews || this.myIncremental && (this.mySchema.tables().isNotEmpty() || this.mySchema.matViews().isNotEmpty() || this.mySchema.views().isNotEmpty());
            if (!toIntrospect) {
                return;
            }
            this.progress("rules");
            List rs = (List)tran.query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveRules).withParams(new Object[]{this.mySchema.getObjectId(), this.myFromStateNumber}).run();
            for (PostgresIntroQueries.OneRule r : rs) {
                DbmLikeTable table = this.getTableOrView('\u0000', r.table_id);
                if (table == null) continue;
                PostgresRuleOrTrigger trigger = (PostgresRuleOrTrigger)table.triggers().renew(r.rule_id, r.rule_name);
                trigger.setSubKind(PostgresRuleOrTrigger.SubKind.RULE);
                trigger.setStateNumber(r.rule_state_number);
                trigger.trigEvents.set(TrigEvent.of(r.rule_event_code));
                trigger.setTrigTurn(r.rule_is_instead ? TrigTurn.INSTEAD_OF : TrigTurn.ALSO);
                PostgresRuleOrTrigger.FireMode fireMode = PostgresRuleOrTrigger.FireMode.of(r.rule_fire_mode);
                trigger.setFireMode(fireMode != null ? fireMode : PostgresRuleOrTrigger.FireMode.ORIGIN);
            }
        }

        private void retrieveDescriptions(@NotNull DBTransaction tran) {
            boolean toIntrospect;
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "retrieveDescriptions"));
            }
            boolean bl = toIntrospect = this.wasTables || this.wasMatViews || this.wasViews || this.myIncremental && this.mySchema.tables().isNotEmpty();
            if (!toIntrospect) {
                return;
            }
            this.progress("descriptions");
            List ds = (List)tran.query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveDescriptions).withParams(new Object[]{this.mySchema.getObjectId(), this.myFromStateNumber}).run();
            if (ds.isEmpty()) {
                return;
            }
            DbmLikeTable table = null;
            long table_id = Long.MIN_VALUE;
            for (final PostgresIntroQueries.OneDescription d : ds) {
                Family<? extends DbmColumn> columns;
                DbmColumn column;
                if (d.table_id != table_id) {
                    table = this.getTableOrView('\u0000', d.table_id);
                    if (table == null) continue;
                    table_id = d.table_id;
                }
                assert (table != null);
                if (d.column_position == 0) {
                    table.setComment(d.description);
                    continue;
                }
                if (d.column_position <= 0 || (column = (columns = table.columns()).get((Predicate<? extends DbmColumn>)new Predicate<DbmColumn>(){

                    public boolean apply(DbmColumn column) {
                        return column.getPosition() == d.column_position;
                    }
                })) == null) continue;
                column.setComment(d.description);
            }
        }

        private void retrieveViewSources(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/postgres/PostgresIntrospector$SchemaRetriever", "retrieveViewSources"));
            }
            this.progress("view sources");
            List viewSources = (List)tran.query(((PostgresIntrospector)PostgresIntrospector.this).myQueries.retrieveViewSources).withParams(new Object[]{this.mySchema.getObjectId(), this.myFromStateNumber}).run();
            for (PostgresIntroQueries.OneViewSource vs : viewSources) {
                DbmView view = this.mySchema.views().getOrCreate(vs.view_name);
                view.setSourceText(vs.source_text);
            }
        }

        @Nullable
        private DbmLikeTable renewTableOrView(char relKind, long objectId, String objectName) {
            DbmLikeTable table;
            switch (relKind) {
                case 'r': {
                    table = this.mySchema.tables().renew(objectId, objectName);
                    break;
                }
                case 'm': {
                    table = this.mySchema.matViews().renew(objectId, objectName);
                    break;
                }
                case 'v': {
                    table = this.mySchema.views().renew(objectId, objectName);
                    break;
                }
                default: {
                    table = null;
                }
            }
            return table;
        }

        @Nullable
        private DbmLikeTable getTableOrView(char relKind, long tableId) {
            DbmLikeTable table;
            switch (relKind) {
                case 'r': {
                    table = this.mySchema.tables().getByObjectId(tableId);
                    break;
                }
                case 'm': {
                    table = this.mySchema.matViews().getByObjectId(tableId);
                    break;
                }
                case 'v': {
                    table = this.mySchema.views().getByObjectId(tableId);
                    break;
                }
                case '\u0000': {
                    table = this.mySchema.tables().getByObjectId(tableId);
                    if (table == null) {
                        table = this.mySchema.views().getByObjectId(tableId);
                    }
                    if (table != null) break;
                    table = this.mySchema.matViews().getByObjectId(tableId);
                    break;
                }
                default: {
                    table = null;
                }
            }
            return table;
        }
    }
}

