/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.serialization;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.PropertyHolder;
import com.intellij.dbm.common.StateProperty;
import com.intellij.dbm.serialization.MetaModelException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DbmMetaModel {
    private static final ConcurrentMap<Class<?>, ObjectMetaInfo> ourObjectClasses = new ConcurrentHashMap(60);

    DbmMetaModel() {
    }

    @NotNull
    static ObjectMetaInfo obtainMetaInfo(Class<? extends DbmObject> objectClass) {
        ObjectMetaInfo omi = (ObjectMetaInfo)ourObjectClasses.get(objectClass);
        if (omi == null) {
            ObjectMetaInfo newOMI = DbmMetaModel.makeObjectMetaInfo(objectClass);
            ObjectMetaInfo oldOMI = ourObjectClasses.putIfAbsent(objectClass, newOMI);
            omi = oldOMI != null ? oldOMI : newOMI;
        }
        ObjectMetaInfo objectMetaInfo = omi;
        if (objectMetaInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/serialization/DbmMetaModel", "obtainMetaInfo"));
        }
        return objectMetaInfo;
    }

    @NotNull
    private static ObjectMetaInfo makeObjectMetaInfo(Class<? extends DbmObject> objectClass) {
        Field[] fields;
        ImmutableList.Builder pb = ImmutableList.builder();
        if (objectClass != DbmObject.class) {
            Class<? extends DbmObject> baseClass = objectClass.getSuperclass();
            ObjectMetaInfo baseMetaInfo = DbmMetaModel.obtainMetaInfo(baseClass);
            pb.addAll((Iterable)baseMetaInfo.myProperties);
        }
        for (Field field : fields = objectClass.getDeclaredFields()) {
            PropertyMetaInfo pmi;
            if (!field.isAnnotationPresent(StateProperty.class)) continue;
            field.setAccessible(true);
            String propertyName = DbmMetaModel.getPropertyName(field.getName());
            if (Modifier.isFinal(field.getModifiers())) {
                if (!PropertyHolder.class.isAssignableFrom(field.getType())) {
                    throw new MetaModelException("A final property must implement PropertyHolder");
                }
                pmi = new PropertyMetaInfo(propertyName, objectClass, field, (Type)((Object)String.class), true, null);
            } else {
                Class<?> valueClass = field.getType();
                Method setter = DbmMetaModel.getSetter(objectClass, field, valueClass);
                pmi = new PropertyMetaInfo(propertyName, objectClass, field, valueClass, false, setter);
            }
            pb.add((Object)pmi);
        }
        ObjectMetaInfo objectMetaInfo = new ObjectMetaInfo(objectClass, (ImmutableList<PropertyMetaInfo>)pb.build());
        if (objectMetaInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/serialization/DbmMetaModel", "makeObjectMetaInfo"));
        }
        return objectMetaInfo;
    }

    @Nullable
    private static Method getSetter(Class<? extends DbmObject> objectClass, Field field, Class<?> valueClass) {
        String fieldName = field.getName();
        String setterName = DbmMetaModel.getSetterName(fieldName);
        try {
            return objectClass.getMethod(setterName, valueClass);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    static String getPropertyName(@NotNull String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/dbm/serialization/DbmMetaModel", "getPropertyName"));
        }
        StringBuilder b = new StringBuilder(fieldName);
        if (b.length() > 2 && b.charAt(0) == 'm' && b.charAt(1) == 'y') {
            b.delete(0, 2);
        }
        for (int k = 0; k < b.length(); ++k) {
            char c = b.charAt(k);
            if (!Character.isUpperCase(c)) continue;
            char cl = Character.toLowerCase(c);
            b.setCharAt(k, cl);
            if (k <= 0) continue;
            b.insert(k, '-');
            ++k;
        }
        return b.toString();
    }

    static String getSetterName(@NotNull String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/dbm/serialization/DbmMetaModel", "getSetterName"));
        }
        if (fieldName.length() <= 2 || fieldName.charAt(0) != 'm' || fieldName.charAt(1) != 'y' || !Character.isUpperCase(fieldName.charAt(2))) {
            throw new MetaModelException("The field name should match style myCamelHumpsNamedProperty, but this doesn't: " + fieldName);
        }
        return "set" + fieldName.substring(2);
    }

    static void clearMetaModel() {
        ourObjectClasses.clear();
    }

    static final class PropertyMetaInfo {
        @NotNull
        final String name;
        @NotNull
        final Class<? extends DbmObject> objectClass;
        @NotNull
        final Field propertyField;
        @NotNull
        final Type valueType;
        final boolean isHolder;
        @Nullable
        final Method setter;

        PropertyMetaInfo(@NotNull String name, @NotNull Class<? extends DbmObject> objectClass, @NotNull Field propertyField, @NotNull Type valueType, boolean isHolder, @Nullable Method setter) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/serialization/DbmMetaModel$PropertyMetaInfo", "<init>"));
            }
            if (objectClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectClass", "com/intellij/dbm/serialization/DbmMetaModel$PropertyMetaInfo", "<init>"));
            }
            if (propertyField == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyField", "com/intellij/dbm/serialization/DbmMetaModel$PropertyMetaInfo", "<init>"));
            }
            if (valueType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueType", "com/intellij/dbm/serialization/DbmMetaModel$PropertyMetaInfo", "<init>"));
            }
            this.name = name;
            this.objectClass = objectClass;
            this.propertyField = propertyField;
            this.valueType = valueType;
            this.isHolder = isHolder;
            this.setter = setter;
        }

        public String toString() {
            return this.objectClass.getSimpleName() + '.' + this.name;
        }
    }

    static final class ObjectMetaInfo {
        @NotNull
        private final Class<? extends DbmObject> objectClass;
        @NotNull
        private final ImmutableList<PropertyMetaInfo> myProperties;
        @NotNull
        private final Map<String, PropertyMetaInfo> myPropertiesByName;

        public ObjectMetaInfo(@NotNull Class<? extends DbmObject> objectClass, @NotNull ImmutableList<PropertyMetaInfo> properties) {
            if (objectClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectClass", "com/intellij/dbm/serialization/DbmMetaModel$ObjectMetaInfo", "<init>"));
            }
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/dbm/serialization/DbmMetaModel$ObjectMetaInfo", "<init>"));
            }
            this.objectClass = objectClass;
            this.myProperties = properties;
            ImmutableMap.Builder b = ImmutableMap.builder();
            for (PropertyMetaInfo p : properties) {
                b.put((Object)p.name, (Object)p);
            }
            this.myPropertiesByName = b.build();
        }

        @NotNull
        Class<? extends DbmObject> getObjectClass() {
            Class<? extends DbmObject> clazz = this.objectClass;
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/serialization/DbmMetaModel$ObjectMetaInfo", "getObjectClass"));
            }
            return clazz;
        }

        @NotNull
        PropertyMetaInfo getProperty(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/serialization/DbmMetaModel$ObjectMetaInfo", "getProperty"));
            }
            PropertyMetaInfo propertyMetaInfo = this.myPropertiesByName.get(name);
            if (propertyMetaInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/serialization/DbmMetaModel$ObjectMetaInfo", "getProperty"));
            }
            return propertyMetaInfo;
        }

        @NotNull
        public ImmutableList<PropertyMetaInfo> getProperties() {
            ImmutableList<PropertyMetaInfo> immutableList = this.myProperties;
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/serialization/DbmMetaModel$ObjectMetaInfo", "getProperties"));
            }
            return immutableList;
        }

        @NotNull
        public Map<String, PropertyMetaInfo> getPropertiesByName() {
            Map<String, PropertyMetaInfo> map = this.myPropertiesByName;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/serialization/DbmMetaModel$ObjectMetaInfo", "getPropertiesByName"));
            }
            return map;
        }
    }
}

