/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.TreePatternUtils;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreePatternNode<Naming extends BaseNaming> {
    public static final Group[] NO_GROUPS = new Group[0];
    public final Naming naming;
    @NotNull
    public final Group[] groups;

    public TreePatternNode(@NotNull Naming naming, @NotNull Group[] groups) {
        if (naming == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "naming", "com/intellij/sql/dialects/TreePatternNode", "<init>"));
        }
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/sql/dialects/TreePatternNode", "<init>"));
        }
        this.naming = naming;
        this.groups = groups;
        assert (TreePatternUtils.isValid(this));
    }

    @Nullable
    public static Group getGroup(@NotNull Group[] groups, @NotNull ObjectKind kind) {
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/sql/dialects/TreePatternNode", "getGroup"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/TreePatternNode", "getGroup"));
        }
        for (Group group : groups) {
            if (group.kind != kind) continue;
            return group;
        }
        return null;
    }

    public boolean matchedChildren(@Nullable String name, boolean sensitive, @NotNull ObjectKind kind, @NotNull List<TreePatternNode> matched) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/TreePatternNode", "matchedChildren"));
        }
        if (matched == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matched", "com/intellij/sql/dialects/TreePatternNode", "matchedChildren"));
        }
        Group group = TreePatternNode.getGroup(this.groups, kind);
        return group != null && group.matchedChildren(name, sensitive, matched);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreePatternNode node = (TreePatternNode)o;
        if (!((BaseNaming)this.naming).equals(node.naming)) {
            return false;
        }
        return Arrays.equals(this.groups, node.groups);
    }

    public int hashCode() {
        int result = ((BaseNaming)this.naming).hashCode();
        result = 31 * result + Arrays.hashCode(this.groups);
        return result;
    }

    public static class Group {
        public final ObjectKind kind;
        @Nullable
        public final TreePatternNode<PositiveNaming>[] positiveChildren;
        @Nullable
        public final TreePatternNode<NegativeNaming> negativeChild;
        private Integer myHashCode;

        public Group(@NotNull ObjectKind kind, @Nullable TreePatternNode<PositiveNaming>[] children, @Nullable TreePatternNode<NegativeNaming> antiPattern) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/TreePatternNode$Group", "<init>"));
            }
            this.kind = kind;
            this.positiveChildren = children;
            this.negativeChild = antiPattern;
            assert (TreePatternUtils.isValid(this));
        }

        public boolean matchedChildren(@Nullable String name, boolean sensitive, @Nullable List<TreePatternNode> matched) {
            boolean m = false;
            if (this.positiveChildren != null) {
                for (TreePatternNode<PositiveNaming> child : this.positiveChildren) {
                    if (!((PositiveNaming)child.naming).matches(name, sensitive)) continue;
                    if (matched != null) {
                        matched.add(child);
                    }
                    m = true;
                }
            }
            if (this.negativeChild != null && ((NegativeNaming)this.negativeChild.naming).matches(name, sensitive)) {
                if (matched != null) {
                    matched.add(this.negativeChild);
                }
                m = true;
            }
            return m;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Group group = (Group)o;
            if (group.hashCode() != this.hashCode()) {
                return false;
            }
            if (!this.kind.equals(group.kind)) {
                return false;
            }
            if (this.negativeChild != null ? !this.negativeChild.equals(group.negativeChild) : group.negativeChild != null) {
                return false;
            }
            return Arrays.equals(this.positiveChildren, group.positiveChildren);
        }

        public int hashCode() {
            if (this.myHashCode != null) {
                return this.myHashCode;
            }
            int result = this.kind.hashCode();
            result = 31 * result + Arrays.hashCode(this.positiveChildren);
            result = 31 * result + (this.negativeChild != null ? this.negativeChild.hashCode() : 0);
            this.myHashCode = result;
            return this.myHashCode;
        }
    }

    public static class NegativeNaming
    extends BaseNaming {
        public static final NegativeNaming WILDCARD = new NegativeNaming(ArrayUtil.EMPTY_STRING_ARRAY);

        public NegativeNaming(@NotNull String[] antiNames) {
            if (antiNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "antiNames", "com/intellij/sql/dialects/TreePatternNode$NegativeNaming", "<init>"));
            }
            super(antiNames);
        }

        @Override
        public boolean matches(@Nullable String name, boolean sensitive) {
            if (name == null) {
                return true;
            }
            for (String n : this.names) {
                if (!Comparing.strEqual((String)name, (String)n, (boolean)sensitive)) continue;
                return false;
            }
            return true;
        }

        @NotNull
        public String[] getAntiNames() {
            if (this.names == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternNode$NegativeNaming", "getAntiNames"));
            }
            return this.names;
        }

        public String toString() {
            return this.names.length == 0 ? "*" : "*, -" + StringUtil.join((String[])this.names, (String)", -");
        }
    }

    public static class PositiveNaming
    extends BaseNaming {
        public PositiveNaming(String ... names) {
            if (names == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/dialects/TreePatternNode$PositiveNaming", "<init>"));
            }
            super(names);
            assert (names.length != 0) : "Empty positive naming";
        }

        @Override
        public boolean matches(@Nullable String name, boolean sensitive) {
            if (name == null) {
                return true;
            }
            for (String n : this.names) {
                if (!Comparing.strEqual((String)name, (String)n, (boolean)sensitive)) continue;
                return true;
            }
            return false;
        }

        @NotNull
        public String[] getNames() {
            if (this.names == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternNode$PositiveNaming", "getNames"));
            }
            return this.names;
        }

        public String toString() {
            return StringUtil.join((Object[])this.names, n -> n.length() == 0 ? "\"\"" : n, (String)", ");
        }
    }

    public static abstract class BaseNaming {
        protected final String[] names;

        public BaseNaming(@NotNull String[] names) {
            if (names == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/dialects/TreePatternNode$BaseNaming", "<init>"));
            }
            this.names = names;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseNaming naming = (BaseNaming)o;
            return Arrays.equals(this.names, naming.names);
        }

        public int hashCode() {
            return Arrays.hashCode(this.names);
        }

        public abstract boolean matches(@Nullable String var1, boolean var2);
    }
}

