/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres.psi;

import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiTable;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlLikeTableClause;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlCreateTableStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.sql.psi.stubs.SqlTableStub;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PgCreateTableStatementImpl
extends SqlCreateTableStatementImpl {
    private static final PairFunction<PsiColumn, PsiColumn, Boolean> MERGE_CHECK = SqlImplUtil::hasSameTypes;

    public PgCreateTableStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/dialects/postgres/psi/PgCreateTableStatementImpl", "<init>"));
        }
        super(node);
    }

    public PgCreateTableStatementImpl(SqlTableStub stub) {
        super(stub);
    }

    @Override
    @NotNull
    protected List<PsiColumn> calcColumns() {
        boolean sensitive = this.isColumnsCaseSensitive();
        List<PsiColumn> inherited = this.getAdditionalColumnsImpl(PgTypes.PG_INHERITS_TABLE_CLAUSE);
        List<PsiColumn> res = this.getAdditionalColumnsImpl(PgTypes.PG_LIKE_TABLE_CLAUSE);
        SqlImplUtil.mergeColumnListInto(res, inherited, sensitive, MERGE_CHECK);
        res.addAll(SqlImplUtil.processColumnList(this.getDeclaredColumns(), inherited, sensitive, MERGE_CHECK, true));
        List list = ContainerUtil.concat(this.getQueryColumns(), res);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/psi/PgCreateTableStatementImpl", "calcColumns"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<PsiColumn> getAdditionalColumns() {
        List<PsiColumn> list = SqlImplUtil.mergeColumnListInto(this.getAdditionalColumnsImpl(PgTypes.PG_LIKE_TABLE_CLAUSE), this.getAdditionalColumnsImpl(PgTypes.PG_INHERITS_TABLE_CLAUSE), this.isColumnsCaseSensitive(), MERGE_CHECK);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/psi/PgCreateTableStatementImpl", "getAdditionalColumns"));
        }
        return list;
    }

    @NotNull
    public List<PsiColumn> getAdditionalColumnsImpl(@NotNull IElementType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/sql/dialects/postgres/psi/PgCreateTableStatementImpl", "getAdditionalColumnsImpl"));
        }
        boolean sensitive = this.isColumnsCaseSensitive();
        ArrayList plainColumns = ContainerUtil.newArrayList();
        for (SqlLikeTableClause likeTableClause : (SqlLikeTableClause[])this.findChildrenByClass(SqlLikeTableClause.class)) {
            IElementType clauseType = likeTableClause.getNode().getElementType();
            if (clauseType != type) continue;
            for (SqlReferenceExpression tableReference : likeTableClause.getTableReferences()) {
                PsiElement element = tableReference.resolve();
                if (!(element instanceof PsiTable)) continue;
                SqlTableType tableType = SqlTableTypeBase.createType((PsiTable)element, (PsiElement)this);
                List inherited = ContainerUtil.findAll(((TableBasedSqlTableTypeImpl)tableType).getColumns(), SqlColumnDefinition.class);
                if (clauseType == PgTypes.PG_INHERITS_TABLE_CLAUSE) {
                    SqlImplUtil.mergeColumnListInto(plainColumns, inherited, sensitive, MERGE_CHECK);
                    continue;
                }
                plainColumns.addAll(inherited);
            }
        }
        ArrayList arrayList = plainColumns;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/psi/PgCreateTableStatementImpl", "getAdditionalColumnsImpl"));
        }
        return arrayList;
    }
}

