/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.model.DasColumn;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlInsertValuesInspection
extends SqlInspectionBase {
    @NotNull
    public String getDisplayName() {
        String string = SqlMessages.message("inspection.name.insert.values", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlInsertValuesInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, final boolean onTheFly) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/inspections/SqlInsertValuesInspection", "createAnnotationVisitor"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/sql/inspections/SqlInsertValuesInspection", "createAnnotationVisitor"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/inspections/SqlInsertValuesInspection", "createAnnotationVisitor"));
        }
        final DatabaseFamilyId familyId = dialect.getDatabaseDialect().getFamilyId();
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result){

            public void visitSqlValuesExpression(SqlValuesExpression o) {
                super.visitSqlValuesExpression(o);
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                SqlDmlInstruction insertStatement = (SqlDmlInstruction)PsiTreeUtil.getParentOfType((PsiElement)o, SqlDmlInstruction.class, (boolean)true, (Class[])new Class[]{SqlQueryExpression.class});
                if (insertStatement != null) {
                    SqlTableType targetType = insertStatement.getTargetType();
                    Pair<Integer, Integer> minMax = this.minMaxColumnCount(targetType);
                    if ((Integer)minMax.second <= 0) {
                        return;
                    }
                    int counter = 0;
                    for (SqlExpression expression : o.getExpressions()) {
                        int actual;
                        ++counter;
                        if (this.shouldNotCheckElement((SqlElement)expression)) continue;
                        SqlType type = expression.getSqlType();
                        int n = type instanceof SqlTableType ? ((SqlTableType)type).getColumnCount() : (actual = type == SqlType.UNKNOWN ? 0 : 1);
                        if (actual == 0) continue;
                        this.checkElement(expression, (Integer)minMax.second, (Integer)minMax.first, actual);
                    }
                    if (counter == 0) {
                        this.checkElement((SqlExpression)o, (Integer)minMax.second, (Integer)minMax.first, 0);
                    }
                }
            }

            @NotNull
            private Pair<Integer, Integer> minMaxColumnCount(@NotNull SqlTableType targetType) {
                int max;
                if (targetType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetType", "com/intellij/sql/inspections/SqlInsertValuesInspection$1", "minMaxColumnCount"));
                }
                int min = max = targetType.getColumnCount();
                for (int i = 0; i < max; ++i) {
                    boolean hasDefaultOrNullable;
                    PsiElement element = targetType.getColumnElement(i);
                    if (!(element instanceof DasColumn)) continue;
                    DasColumn column = (DasColumn)element;
                    boolean isPostgres = familyId.isPostgres();
                    boolean supportsAutoInc = familyId.isTransactSql() || isPostgres;
                    boolean isAutoInc = DasUtil.isAutoVal((DasColumn)column);
                    boolean bl = hasDefaultOrNullable = column.getDefault() != null || !column.isNotNull();
                    if ((!supportsAutoInc || !isAutoInc) && (!isPostgres || !hasDefaultOrNullable)) continue;
                    --min;
                }
                Pair pair = Pair.create((Object)min, (Object)max);
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlInsertValuesInspection$1", "minMaxColumnCount"));
                }
                return pair;
            }

            public void visitSqlQueryExpression(SqlQueryExpression o) {
                super.visitSqlQueryExpression(o);
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                SqlDmlInstruction insertStatement = (SqlDmlInstruction)ObjectUtils.tryCast((Object)o.getParent(), SqlDmlInstruction.class);
                SqlInsertStatement insert = (SqlInsertStatement)ObjectUtils.tryCast((Object)(insertStatement == null ? null : insertStatement.getParent()), SqlInsertStatement.class);
                if (insert != null) {
                    assert (insertStatement != null);
                    SqlTableType exprType = (SqlTableType)ObjectUtils.tryCast((Object)o.getSqlType(), SqlTableType.class);
                    if (exprType == null) {
                        return;
                    }
                    SqlTableType targetType = insertStatement.getTargetType();
                    Pair<Integer, Integer> targetMinMax = this.minMaxColumnCount(targetType);
                    if ((Integer)targetMinMax.second <= 0) {
                        return;
                    }
                    this.checkElement((SqlExpression)o, (Integer)targetMinMax.second, (Integer)targetMinMax.first, exprType.getColumnCount());
                }
            }

            private void checkElement(SqlExpression anchor, int max, int min, int actual) {
                if (actual > max || actual < min) {
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)anchor, SqlMessages.message("incorrect.values.number", max == min ? Integer.valueOf(max) : "from " + min + " to " + max, actual), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }
        };
    }
}

