/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlForeignKeyDefinition;
import com.intellij.sql.psi.SqlIndexDefinition;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.stubs.SqlForeignKeyElementType;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlTableKeyElementType;
import com.intellij.sql.psi.stubs.SqlTableStub;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCreateTableStatementImpl
extends SqlStubbedDefinitionImpl<SqlTableStub>
implements SqlCreateTableStatement {
    public SqlCreateTableStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl", "<init>"));
        }
        super(node);
    }

    public SqlCreateTableStatementImpl(SqlTableStub stub) {
        super(stub, SqlCompositeElementTypes.SQL_CREATE_TABLE_STATEMENT);
    }

    @Override
    protected SqlReferenceElementType getExpectedNameReferenceElementType() {
        return SqlCompositeElementTypes.SQL_TABLE_REFERENCE;
    }

    public SqlReferenceExpression getNameElement() {
        return (SqlReferenceExpression)super.getNameElement();
    }

    public SqlExpression getExpression() {
        SqlTableStub stub = (SqlTableStub)this.getStub();
        if (stub != null) {
            return stub.getExpression();
        }
        SqlExpression last = (SqlExpression)SqlImplUtil.childrenIt((PsiElement)this).filter(SqlExpression.class).last();
        return last == this.getNameElement() ? null : last;
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlCreateTableStatement((SqlCreateTableStatement)this);
    }

    public DatabaseSystem getDataSource() {
        return null;
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TABLE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl", "getKind"));
        }
        return objectKind;
    }

    @Override
    @NotNull
    public <C> JBIterable<C> getDbChildren(@NotNull Class<C> clazz, @NotNull ObjectKind kind) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl", "getDbChildren"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl", "getDbChildren"));
        }
        JBIterable result = JBIterable.empty();
        if (kind == ObjectKind.COLUMN || kind == ObjectKind.NONE) {
            result = result.append(this.getColumns());
        }
        if (kind == ObjectKind.KEY || kind == ObjectKind.NONE) {
            result = result.append(this.getDeclaredKeys());
        }
        if (kind == ObjectKind.FOREIGN_KEY || kind == ObjectKind.NONE) {
            result = result.append(this.getDeclaredForeignKeys());
        }
        if (kind == ObjectKind.INDEX || kind == ObjectKind.NONE) {
            result = result.append(this.getDeclaredIndices());
        }
        JBIterable jBIterable = result.filter(clazz);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl", "getDbChildren"));
        }
        return jBIterable;
    }

    @NotNull
    public List<PsiColumn> getColumns() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.calcColumns(), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl", "getColumns"));
        }
        return list;
    }

    @NotNull
    protected List<PsiColumn> calcColumns() {
        List list = ContainerUtil.concat((List[])new List[]{this.getDeclaredColumns(), this.getAdditionalColumns(), this.calcQueryColumns()});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl", "calcColumns"));
        }
        return list;
    }

    @NotNull
    public List<SqlColumnDefinition> getDeclaredColumns() {
        List<PsiElement> list = Arrays.asList(this.getStubOrPsiChildren(SqlCompositeElementTypes.SQL_COLUMN_DEFINITION, SqlColumnDefinition.ARRAY_FACTORY));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl", "getDeclaredColumns"));
        }
        return list;
    }

    @NotNull
    public List<SqlTableKeyDefinition> getDeclaredKeys() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.calcDeclaredKeys(), (Object[])new Object[]{this}));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl", "getDeclaredKeys"));
        }
        return list;
    }

    @NotNull
    public List<SqlForeignKeyDefinition> getDeclaredForeignKeys() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.calcDeclaredForeignKeys(), (Object[])new Object[]{this}));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl", "getDeclaredForeignKeys"));
        }
        return list;
    }

    @NotNull
    private List<SqlForeignKeyDefinition> calcDeclaredForeignKeys() {
        ArrayList result = ContainerUtil.newArrayList();
        for (SqlColumnDefinition column : this.getDeclaredColumns()) {
            ContainerUtil.addIfNotNull((Object)column.getForeignKey(), (Collection)result);
        }
        SqlForeignKeyElementType fkType = SqlCompositeElementTypes.SQL_FOREIGN_KEY_DEFINITION;
        ContainerUtil.addAll((Collection)result, (Object[])this.getStubOrPsiChildren(fkType, SqlForeignKeyDefinition.ARRAY_FACTORY));
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl", "calcDeclaredForeignKeys"));
        }
        return arrayList;
    }

    @NotNull
    private List<SqlTableKeyDefinition> calcDeclaredKeys() {
        ArrayList result = ContainerUtil.newArrayList();
        for (SqlColumnDefinition sqlColumnDefinition : this.getDeclaredColumns()) {
            ContainerUtil.addIfNotNull((Object)sqlColumnDefinition.getPrimaryKey(), (Collection)result);
        }
        SqlTableKeyElementType pkType = SqlCompositeElementTypes.SQL_PRIMARY_KEY_DEFINITION;
        ContainerUtil.addAll((Collection)result, (Object[])this.getStubOrPsiChildren(pkType, SqlTableKeyDefinition.ARRAY_FACTORY));
        for (SqlColumnDefinition column : this.getDeclaredColumns()) {
            ContainerUtil.addIfNotNull((Object)column.getUniqueKey(), (Collection)result);
        }
        SqlTableKeyElementType sqlTableKeyElementType = SqlCompositeElementTypes.SQL_UNIQUE_KEY_DEFINITION;
        Collections.addAll(result, this.getStubOrPsiChildren(sqlTableKeyElementType, SqlTableKeyDefinition.ARRAY_FACTORY));
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl", "calcDeclaredKeys"));
        }
        return arrayList;
    }

    @NotNull
    public List<SqlIndexDefinition> getDeclaredIndices() {
        SqlTableKeyElementType idxType = SqlCompositeElementTypes.SQL_INDEX_DEFINITION;
        List<PsiElement> list = Arrays.asList(this.getStubOrPsiChildren(idxType, SqlIndexDefinition.ARRAY_FACTORY));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl", "getDeclaredIndices"));
        }
        return list;
    }

    @Override
    public Icon getIcon() {
        return DatabaseIcons.Table;
    }

    @NotNull
    protected List<PsiColumn> getAdditionalColumns() {
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl", "getAdditionalColumns"));
        }
        return list;
    }

    @NotNull
    protected List<PsiColumn> getQueryColumns() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.calcQueryColumns(), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl", "getQueryColumns"));
        }
        return list;
    }

    @NotNull
    protected List<PsiColumn> calcQueryColumns() {
        SqlType type;
        SqlExpression expression = this.getExpression();
        SqlType sqlType = type = expression == null ? null : expression.getSqlType();
        if (!(type instanceof SqlTableType)) {
            List<PsiColumn> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl", "calcQueryColumns"));
            }
            return list;
        }
        SqlTableType tableType = (SqlTableType)type;
        List<PsiColumn> list = SqlImplUtil.createColumnInfos((DasTable)this, tableType);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl", "calcQueryColumns"));
        }
        return list;
    }

    public boolean isSystem() {
        return false;
    }

    public boolean isTemporary() {
        return this.findChildByType((IElementType)SqlCommonKeywords.SQL_TEMPORARY) != null;
    }

    @NotNull
    public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn c) {
        if (c == null) {
            Set set = DasUtil.NO_ATTRS;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl", "getColumnAttrs"));
            }
            return set;
        }
        String name = c.getName();
        EnumSet<DasColumn.Attribute> set = EnumSet.noneOf(DasColumn.Attribute.class);
        if (SqlImplUtil.getSqlDialectSafe((PsiElement)this).isAutoIncrementColumn(c)) {
            set.add(DasColumn.Attribute.AUTO_GENERATED);
        }
        for (SqlTableKeyDefinition sqlTableKeyDefinition : this.getDeclaredKeys()) {
            if (!DasUtil.containsName((String)name, (MultiRef)sqlTableKeyDefinition.getColumnsRef())) continue;
            set.add(sqlTableKeyDefinition.isPrimary() ? DasColumn.Attribute.PRIMARY_KEY : DasColumn.Attribute.CANDIDATE_KEY);
        }
        for (DasForeignKey dasForeignKey : this.getDeclaredForeignKeys()) {
            if (!DasUtil.containsName((String)name, (MultiRef)dasForeignKey.getColumnsRef())) continue;
            set.add(DasColumn.Attribute.FOREIGN_KEY);
            break;
        }
        for (DasIndex dasIndex : this.getDeclaredIndices()) {
            if (!DasUtil.containsName((String)name, (MultiRef)dasIndex.getColumnsRef())) continue;
            set.add(DasColumn.Attribute.INDEX);
            break;
        }
        EnumSet<DasColumn.Attribute> enumSet = set;
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl", "getColumnAttrs"));
        }
        return enumSet;
    }

    protected boolean isColumnsCaseSensitive() {
        return DasUtil.isCaseSensitive((Casing)SqlImplUtil.getSqlDialectSafe((PsiElement)this).getCasing(ObjectKind.COLUMN, (DasObject)this));
    }
}

