/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasTable;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlTriggerStub;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class SqlCreateTriggerStatementImpl
extends SqlStubbedDefinitionImpl<SqlTriggerStub>
implements SqlCreateTriggerStatement {
    public SqlCreateTriggerStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl", "<init>"));
        }
        super(node);
    }

    public SqlCreateTriggerStatementImpl(SqlTriggerStub stub) {
        super(stub, SqlCompositeElementTypes.SQL_CREATE_TRIGGER_STATEMENT);
    }

    @Override
    protected SqlReferenceElementType getExpectedNameReferenceElementType() {
        return SqlCompositeElementTypes.SQL_TRIGGER_REFERENCE;
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlCreateTriggerStatement((SqlCreateTriggerStatement)this);
    }

    public SqlReferenceExpression getTargetContextExpression() {
        SqlTriggerStub stub = (SqlTriggerStub)this.getStub();
        if (stub != null) {
            return stub.getTableReference();
        }
        SqlOnTargetClauseImpl target = (SqlOnTargetClauseImpl)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_ON_TARGET_CLAUSE);
        return target == null ? null : (SqlReferenceExpression)ObjectUtils.tryCast((Object)target.getTargetExpression(), SqlReferenceExpression.class);
    }

    @Override
    public boolean processImplicitContextDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlReferenceExpression expression = this.getTargetContextExpression();
        if (lastParent.getParent() == this && expression != null && expression != lastParent && !SqlImplUtil.processQualifier(expression, processor, state, place)) {
            return false;
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    public String getTableName() {
        SqlReferenceExpression ref = this.getTargetContextExpression();
        return ref == null ? null : ref.getName();
    }

    public DasTable getTable() {
        SqlReferenceExpression ref = this.getTargetContextExpression();
        PsiElement resolve = ref == null ? null : ref.resolve();
        return resolve instanceof DasTable ? (DasTable)resolve : null;
    }
}

