/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.psi.ResolveResult;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlForeignKeyDefinition;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKIFKImpl;
import com.intellij.sql.psi.stubs.SqlForeignKeyStub;
import icons.DatabaseIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlForeignKeyDefinitionImpl
extends SqlKIFKImpl<SqlForeignKeyStub>
implements SqlForeignKeyDefinition {
    private MultiRef<? extends DasTypedObject> myRefColumns;

    public SqlForeignKeyDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlForeignKeyDefinitionImpl", "<init>"));
        }
        super(node);
    }

    public SqlForeignKeyDefinitionImpl(SqlForeignKeyStub stub) {
        super(stub, SqlCompositeElementTypes.SQL_FOREIGN_KEY_DEFINITION);
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.FOREIGN_KEY;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlForeignKeyDefinitionImpl", "getKind"));
        }
        return objectKind;
    }

    @Nullable
    private SqlReferenceExpression getRefTableReference() {
        SqlTableColumnsList list = this.getRefTableColumnList();
        return list == null ? null : list.getTableReference();
    }

    public String getRefTableName() {
        SqlReferenceExpression tableRef = this.getRefTableReference();
        return tableRef == null ? null : tableRef.getName();
    }

    public String getRefTableSchema() {
        return SqlImplUtil.getCasedPart(this.getRefTableReference(), ObjectKind.SCHEMA);
    }

    public String getRefTableCatalog() {
        return SqlImplUtil.getCasedPart(this.getRefTableReference(), ObjectKind.DATABASE);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myRefColumns = null;
    }

    @NotNull
    public MultiRef<? extends DasTypedObject> getRefColumns() {
        if (this.myRefColumns == null) {
            DasTableKey pk;
            List<SqlReferenceExpression> refList = this.getRefList();
            this.myRefColumns = refList.isEmpty() ? ((pk = this.getRefPk()) != null ? pk.getColumnsRef() : DasUtil.emptyMultiRef()) : SqlForeignKeyDefinitionImpl.asColumnsRef(refList);
        }
        MultiRef<? extends DasTypedObject> multiRef = this.myRefColumns;
        if (multiRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlForeignKeyDefinitionImpl", "getRefColumns"));
        }
        return multiRef;
    }

    @Nullable
    private DasTableKey getRefPk() {
        DasTable table = this.getRefTable();
        return table != null ? DasUtil.getPrimaryKey((DasTable)table) : null;
    }

    @Nullable
    public DasTable getRefTable() {
        SqlReferenceExpression expression = this.getRefTableReference();
        if (expression != null) {
            for (ResolveResult result : expression.multiResolve(false)) {
                if (!(result.getElement() instanceof DasTable)) continue;
                return (DasTable)result.getElement();
            }
        }
        return null;
    }

    @NotNull
    private List<SqlReferenceExpression> getRefList() {
        List<SqlReferenceExpression> list = SqlImplUtil.getReferenceList(this.getRefTableColumnList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlForeignKeyDefinitionImpl", "getRefList"));
        }
        return list;
    }

    public DasForeignKey.RuleAction getDeleteRule() {
        return null;
    }

    public DasForeignKey.RuleAction getUpdateRule() {
        return null;
    }

    public DasForeignKey.Deferrability getDeferrability() {
        return null;
    }

    private SqlTableColumnsList getRefTableColumnList() {
        SqlForeignKeyStub stub = (SqlForeignKeyStub)this.getStub();
        if (stub != null) {
            return stub.getRefColumnList();
        }
        return (SqlTableColumnsList)this.findChildByClass(SqlTableColumnsList.class);
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return DatabaseIcons.BlueKey;
    }
}

