/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;

public class SqlTriggerStub
extends SqlNamedElementStub<SqlCreateTriggerStatement> {
    protected final StringRef myTableName;
    private SqlReferenceExpression myTargetReference;

    public SqlTriggerStub(StubElement parent, @NotNull IStubElementType elementType, StringRef name, StringRef tableName) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/sql/psi/stubs/SqlTriggerStub", "<init>"));
        }
        super(parent, elementType, name);
        this.myTableName = tableName;
    }

    public String getTableName() {
        return this.myTableName == null ? null : this.myTableName.getString();
    }

    public SqlReferenceExpression getTableReference() {
        if (this.myTargetReference == null) {
            String targetName = this.getTableName();
            if (targetName == null) {
                return null;
            }
            this.myTargetReference = this.createReference(SqlCompositeElementTypes.SQL_TABLE_REFERENCE, targetName);
        }
        return this.myTargetReference;
    }
}

