/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.local;

import com.android.repository.Revision;
import com.android.repository.io.FileOp;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class LocalPlatformPkgInfo
extends LocalPkgInfo {
    public static final String PROP_VERSION_SDK = "ro.build.version.sdk";
    public static final String PROP_VERSION_CODENAME = "ro.build.version.codename";
    public static final String PROP_VERSION_RELEASE = "ro.build.version.release";
    private final IPkgDesc mDesc;
    private static final int LAYOUTLIB_VERSION_NOT_SPECIFIED = 0;
    private Map<String, String> myPlatformProp;

    public LocalPlatformPkgInfo(LocalSdk localSdk, File localDir, Properties sourceProps, AndroidVersion version, Revision revision, Revision minToolsRev) {
        super(localSdk, localDir, sourceProps);
        this.mDesc = PkgDesc.Builder.newPlatform(version, revision, minToolsRev).create();
    }

    @Override
    public IPkgDesc getDesc() {
        return this.mDesc;
    }

    public String getTargetHash() {
        return this.getDesc().getPath();
    }

    public int getLayoutlibApi() {
        Map<String, String> platformProp = this.getPlatformProps();
        int layoutlibApi = 1;
        if (platformProp == null) {
            return layoutlibApi;
        }
        try {
            int llRev;
            String propRev;
            String propApi = platformProp.get("Layoutlib.Api");
            if (propApi == null) {
                propApi = platformProp.get("sdk." + "Layoutlib.Api".toLowerCase());
            }
            if ((propRev = platformProp.get("Layoutlib.Revision")) == null) {
                propRev = platformProp.get("sdk." + "Layoutlib.Revision".toLowerCase());
            }
            int llApi = propApi == null ? 0 : Integer.parseInt(propApi);
            int n = llRev = propRev == null ? 0 : Integer.parseInt(propRev);
            if (llApi > 0 || llRev >= 0) {
                layoutlibApi = llApi;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return layoutlibApi;
    }

    private Map<String, String> getPlatformProps() {
        if (this.myPlatformProp == null) {
            LocalSdk sdk = this.getLocalSdk();
            FileOp fileOp = sdk.getFileOp();
            File platformFolder = this.getLocalDir();
            File buildProp = new File(platformFolder, "build.prop");
            File sourcePropFile = new File(platformFolder, "source.properties");
            if (!fileOp.isFile(buildProp) || !fileOp.isFile(sourcePropFile)) {
                this.appendLoadError("Ignoring platform '%1$s': %2$s is missing.", platformFolder.getName(), "build.prop");
                return null;
            }
            HashMap<String, String> result = new HashMap<String, String>();
            Map<String, String> map = null;
            try {
                map = ProjectProperties.parsePropertyStream(fileOp.newFileInputStream(buildProp), buildProp.getPath(), null);
                if (map != null) {
                    result.putAll(map);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            try {
                map = ProjectProperties.parsePropertyStream(fileOp.newFileInputStream(sourcePropFile), sourcePropFile.getPath(), null);
                if (map != null) {
                    result.putAll(map);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            File sdkPropFile = new File(platformFolder, "sdk.properties");
            if (fileOp.isFile(sdkPropFile)) {
                try {
                    map = ProjectProperties.parsePropertyStream(fileOp.newFileInputStream(sdkPropFile), sdkPropFile.getPath(), null);
                    if (map != null) {
                        result.putAll(map);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            this.myPlatformProp = result;
        }
        return this.myPlatformProp;
    }
}

