/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.javascript.debugger.breakpoints.JavaScriptExceptionBreakpointProperties;
import com.intellij.javascript.debugger.breakpoints.JavaScriptExceptionBreakpointType;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.util.UtilKt;
import com.jetbrains.javascript.debugger.ChromeExceptionBreakpointHandlerKt$sam$Consumer$d17dfac2;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import gnu.trove.THashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.ExceptionCatchMode;
import org.jetbrains.debugger.ExceptionData;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0011\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u001c\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J \u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u001e\u0010\u0018\u001a\u00020\u00172\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0019\u001a\u00020\u0014H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/javascript/debugger/ChromeExceptionBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "Lcom/intellij/javascript/debugger/breakpoints/JavaScriptExceptionBreakpointProperties;", "debugProcess", "Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;)V", "activeBreakpoints", "Lgnu/trove/THashSet;", "exceptionCatchMode", "Lorg/jetbrains/debugger/ExceptionCatchMode;", "findActiveBreakpoint", "exceptionName", "", "findBreakpoint", "Lorg/jetbrains/concurrency/Promise;", "exceptionData", "Lorg/jetbrains/debugger/ExceptionData;", "getResult", "isSuitable", "", "breakpoint", "registerBreakpoint", "", "unregisterBreakpoint", "temporary", "JavaScriptDebugger"})
public final class ChromeExceptionBreakpointHandler
extends XBreakpointHandler<XBreakpoint<JavaScriptExceptionBreakpointProperties>> {
    private final THashSet<XBreakpoint<JavaScriptExceptionBreakpointProperties>> activeBreakpoints;
    private volatile ExceptionCatchMode exceptionCatchMode;
    private final JavaScriptDebugProcess<?> debugProcess;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBreakpoint(@NotNull XBreakpoint<JavaScriptExceptionBreakpointProperties> breakpoint) {
        ExceptionCatchMode exceptionCatchMode;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        THashSet<XBreakpoint<JavaScriptExceptionBreakpointProperties>> tHashSet = this.activeBreakpoints;
        synchronized (tHashSet) {
            this.activeBreakpoints.add(breakpoint);
            exceptionCatchMode = ((JavaScriptExceptionBreakpointProperties)breakpoint.getProperties()).getUncaughtOnly() ? ExceptionCatchMode.UNCAUGHT : ExceptionCatchMode.ALL;
        }
        ExceptionCatchMode newMode = exceptionCatchMode;
        if (Intrinsics.areEqual((Object)newMode, (Object)this.exceptionCatchMode) || Intrinsics.areEqual((Object)this.exceptionCatchMode, (Object)ExceptionCatchMode.ALL)) {
            return;
        }
        this.exceptionCatchMode = newMode;
        Vm vm = this.debugProcess.getActiveOrMainVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        Function1 function1 = UtilKt.rejectedErrorReporter((XDebugSession)this.debugProcess.getSession(), (String)"Cannot set exception catch mode : ");
        vm.setBreakOnException(newMode).rejected((Consumer)(function1 == null ? null : new ChromeExceptionBreakpointHandlerKt$sam$Consumer$d17dfac2(function1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBreakpoint(@NotNull XBreakpoint<JavaScriptExceptionBreakpointProperties> breakpoint, boolean temporary) {
        ExceptionCatchMode exceptionCatchMode;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        THashSet<XBreakpoint<JavaScriptExceptionBreakpointProperties>> tHashSet = this.activeBreakpoints;
        synchronized (tHashSet) {
            ExceptionCatchMode newMode;
            this.activeBreakpoints.remove(breakpoint);
            if (this.activeBreakpoints.isEmpty()) {
                newMode = ExceptionCatchMode.NONE;
            } else {
                newMode = ExceptionCatchMode.UNCAUGHT;
                for (XBreakpoint activeBreakpoint : this.activeBreakpoints) {
                    if (((JavaScriptExceptionBreakpointProperties)activeBreakpoint.getProperties()).getUncaughtOnly()) continue;
                    newMode = ExceptionCatchMode.ALL;
                    break;
                }
            }
            exceptionCatchMode = newMode;
        }
        ExceptionCatchMode newMode = exceptionCatchMode;
        if (Intrinsics.areEqual((Object)newMode, (Object)this.exceptionCatchMode) ^ true) {
            this.exceptionCatchMode = newMode;
            Vm vm = this.debugProcess.getActiveOrMainVm();
            if (vm == null) {
                Intrinsics.throwNpe();
            }
            vm.setBreakOnException(newMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final Promise<XBreakpoint<?>> findBreakpoint(@Nullable ExceptionData exceptionData) {
        if (exceptionData == null) {
            return PromiseKt.rejectedPromise((String)"Internal error");
        }
        Value exceptionValue = exceptionData.getExceptionValue();
        if (!(exceptionValue instanceof ObjectValue)) {
            return PromiseKt.resolvedPromise(this.getResult(exceptionData, null));
        }
        ObjectValue objectValue = (ObjectValue)exceptionValue;
        ObjectValue object = objectValue;
        String className = object.getClassName();
        if (className != null) {
            THashSet<XBreakpoint<JavaScriptExceptionBreakpointProperties>> tHashSet = this.activeBreakpoints;
            synchronized (tHashSet) {
                for (XBreakpoint breakpoint : this.activeBreakpoints) {
                    if (!Intrinsics.areEqual((Object)className, (Object)((JavaScriptExceptionBreakpointProperties)breakpoint.getProperties()).getExceptionName())) continue;
                    XBreakpoint xBreakpoint = breakpoint;
                    Intrinsics.checkExpressionValueIsNotNull((Object)xBreakpoint, (String)"breakpoint");
                    if (!this.isSuitable(exceptionData, (XBreakpoint<JavaScriptExceptionBreakpointProperties>)xBreakpoint)) continue;
                    return PromiseKt.resolvedPromise((Object)breakpoint);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        Promise promise = object.getProperties().then(new Function<List<? extends Variable>, XBreakpoint<?>>(this, exceptionData){
            final /* synthetic */ ChromeExceptionBreakpointHandler this$0;
            final /* synthetic */ ExceptionData $exceptionData;

            @Nullable
            public final XBreakpoint<?> fun(List<? extends Variable> it) {
                Value value;
                Variable variable;
                Variable name = null;
                Variable type = null;
                for (Variable variable2 : it) {
                    if (Intrinsics.areEqual((Object)"name", (Object)variable2.getName())) {
                        name = variable2;
                    } else if (Intrinsics.areEqual((Object)"type", (Object)variable2.getName())) {
                        type = variable2;
                    }
                    if (name == null) continue;
                    break;
                }
                if ((variable = name) == null) {
                    variable = type;
                }
                Variable variable3 = variable;
                String exceptionName = null;
                if (variable3 != null && (value = variable3.getValue()) != null) {
                    exceptionName = value.getValueString();
                }
                return ChromeExceptionBreakpointHandler.access$getResult(this.this$0, this.$exceptionData, exceptionName);
            }
            {
                this.this$0 = chromeExceptionBreakpointHandler;
                this.$exceptionData = exceptionData;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise, (String)"`object`.properties\n    \u2026a, exceptionName)\n      }");
        return promise;
    }

    private final XBreakpoint<?> getResult(ExceptionData exceptionData, String exceptionName) {
        XBreakpoint<JavaScriptExceptionBreakpointProperties> breakpoint = this.findActiveBreakpoint(exceptionName);
        return breakpoint != null && this.isSuitable(exceptionData, breakpoint) ? breakpoint : (XBreakpoint<JavaScriptExceptionBreakpointProperties>)null;
    }

    private final boolean isSuitable(ExceptionData exceptionData, XBreakpoint<JavaScriptExceptionBreakpointProperties> breakpoint) {
        return !((JavaScriptExceptionBreakpointProperties)breakpoint.getProperties()).getUncaughtOnly() || !Intrinsics.areEqual((Object)exceptionData.isUncaught(), (Object)ThreeState.NO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final XBreakpoint<JavaScriptExceptionBreakpointProperties> findActiveBreakpoint(String exceptionName) {
        THashSet<XBreakpoint<JavaScriptExceptionBreakpointProperties>> tHashSet = this.activeBreakpoints;
        synchronized (tHashSet) {
            XBreakpoint breakpoint;
            XBreakpoint defaultBreakpoint = null;
            Iterator iterator = this.activeBreakpoints.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    void var3_3;
                    return var3_3;
                }
                breakpoint = (XBreakpoint)iterator.next();
                String name = ((JavaScriptExceptionBreakpointProperties)breakpoint.getProperties()).getExceptionName();
                if (name == null) {
                    defaultBreakpoint = breakpoint;
                    if (exceptionName != null) continue;
                    return defaultBreakpoint;
                }
                if (Intrinsics.areEqual((Object)name, (Object)exceptionName)) break;
            }
            return breakpoint;
        }
    }

    public ChromeExceptionBreakpointHandler(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        super(JavaScriptExceptionBreakpointType.class);
        this.debugProcess = debugProcess;
        this.activeBreakpoints = new THashSet();
        this.exceptionCatchMode = ExceptionCatchMode.NONE;
    }

    @Nullable
    public static final /* synthetic */ XBreakpoint access$getResult(ChromeExceptionBreakpointHandler $this, @NotNull ExceptionData exceptionData, @Nullable String exceptionName) {
        return $this.getResult(exceptionData, exceptionName);
    }
}

