/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.scripts;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.JavaScriptDebuggerViewSupport;
import com.jetbrains.javascript.debugger.scripts.ConsumerOnEdt;
import com.jetbrains.javascript.debugger.scripts.FileInfo;
import com.jetbrains.javascript.debugger.scripts.FileNode;
import com.jetbrains.javascript.debugger.scripts.SourcesTreeComponent;
import com.jetbrains.javascript.debugger.scripts.actions.ScriptTreeActionBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Vm;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/javascript/debugger/scripts/OpenActualScriptSourceAction;", "Lcom/jetbrains/javascript/debugger/scripts/actions/ScriptTreeActionBase;", "treeComponent", "Lcom/jetbrains/javascript/debugger/scripts/SourcesTreeComponent;", "(Lcom/jetbrains/javascript/debugger/scripts/SourcesTreeComponent;)V", "isApplicable", "", "info", "Lcom/jetbrains/javascript/debugger/scripts/FileInfo;", "perform", "", "node", "Lcom/jetbrains/javascript/debugger/scripts/FileNode;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "JavaScriptDebugger"})
final class OpenActualScriptSourceAction
extends ScriptTreeActionBase {
    @Override
    protected boolean isApplicable(@NotNull FileInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        return info.getScripts$JavaScriptDebugger().size() == 1 && Intrinsics.areEqual((Object)this.getTreeComponent().getDebugProcess().getConnection().getState().getStatus(), (Object)ConnectionStatus.CONNECTED);
    }

    @Override
    protected void perform(@NotNull FileNode node, @NotNull DataContext context) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)node), (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JavaScriptDebugProcess<?> debugProcess = this.getTreeComponent().getDebugProcess();
        JavaScriptDebuggerViewSupport viewSupport = debugProcess.getDebuggerViewSupport();
        Vm vm = debugProcess.getActiveOrMainVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        viewSupport.getFileByUrlOrVmSource(vm, node.getFileInfo().getFirstScript(), false).done((Consumer)new ConsumerOnEdt<VirtualFile>(this.getProject()){

            public void consume(@NotNull Project project, @NotNull VirtualFile file) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                FileEditorManager.getInstance((Project)project).openFile(file, true);
            }
        });
    }

    public OpenActualScriptSourceAction(@NotNull SourcesTreeComponent treeComponent) {
        Intrinsics.checkParameterIsNotNull((Object)treeComponent, (String)"treeComponent");
        super(treeComponent, "Open Actual Source");
    }
}

