/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.scripts.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.components.JBList;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.javascript.debugger.JavaScriptDebuggerViewSupport;
import com.jetbrains.javascript.debugger.scripts.ConsumerOnEdt;
import com.jetbrains.javascript.debugger.scripts.FileInfo;
import com.jetbrains.javascript.debugger.scripts.FileNode;
import com.jetbrains.javascript.debugger.scripts.ScriptsKt;
import com.jetbrains.javascript.debugger.scripts.SourcesTreeComponent;
import com.jetbrains.javascript.debugger.scripts.actions.ScriptTreeActionBase;
import com.jetbrains.javascript.debugger.scripts.actions.VisualizeScriptSourcemap;
import com.jetbrains.javascript.debugger.sourcemap.visualizer.SourceFileFinder;
import com.jetbrains.javascript.debugger.sourcemap.visualizer.SourceMapInspectorKt;
import com.jetbrains.javascript.debugger.sourcemap.visualizer.actions.VisualizeSourceMapActionKt;
import java.util.Collection;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000fH\u0014J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/javascript/debugger/scripts/actions/VisualizeScriptSourcemap;", "Lcom/jetbrains/javascript/debugger/scripts/actions/ScriptTreeActionBase;", "treeComponent", "Lcom/jetbrains/javascript/debugger/scripts/SourcesTreeComponent;", "(Lcom/jetbrains/javascript/debugger/scripts/SourcesTreeComponent;)V", "invisibleIfDisabled", "", "getInvisibleIfDisabled", "()Z", "chooseScript", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/Script;", "items", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isApplicable", "info", "Lcom/jetbrains/javascript/debugger/scripts/FileInfo;", "perform", "", "node", "Lcom/jetbrains/javascript/debugger/scripts/FileNode;", "context", "visualize", "script", "sourceUrl", "Lcom/intellij/util/Url;", "JavaScriptDebugger"})
public final class VisualizeScriptSourcemap
extends ScriptTreeActionBase {
    private final boolean invisibleIfDisabled = false;

    @Override
    protected boolean getInvisibleIfDisabled() {
        return this.invisibleIfDisabled;
    }

    @Override
    protected boolean isApplicable(@NotNull FileInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        for (Script script : info.getScripts$JavaScriptDebugger()) {
            if (script.getSourceMap() == null) continue;
            return true;
        }
        return false;
    }

    private final Promise<Script> chooseScript(Collection<? extends Script> items, DataContext dataContext) {
        if (items.size() == 1) {
            Promise promise = Promise.resolve((Object)ContainerUtil.getFirstItem(items));
            Intrinsics.checkExpressionValueIsNotNull((Object)promise, (String)"Promise.resolve<Script>(\u2026Util.getFirstItem(items))");
            return promise;
        }
        JBList list = new JBList(items);
        list.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<Script>(){

            protected void customizeCellRenderer(@NotNull JList<? extends Script> list, @NotNull Script value, int index, boolean selected, boolean hasFocus) {
                Intrinsics.checkParameterIsNotNull(list, (String)"list");
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                this.setIcon(ScriptsKt.getFileType(value.getUrl()).getIcon());
                this.append(value.getUrl().toDecodedForm());
            }
        });
        AsyncPromise result = new AsyncPromise();
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose Script").setItemChoosenCallback(new Runnable(list, result){
            final /* synthetic */ JBList $list;
            final /* synthetic */ AsyncPromise $result;

            public final void run() {
                Script value = (Script)this.$list.getSelectedValue();
                if (value == null) {
                    this.$result.setError("selected value is null");
                } else {
                    this.$result.setResult((Object)value);
                }
            }
            {
                this.$list = jBList;
                this.$result = asyncPromise;
            }
        }).createPopup().showInBestPositionFor(dataContext);
        return (Promise)result;
    }

    @Override
    protected void perform(@NotNull FileNode node, @NotNull DataContext context) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)node), (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Url sourceUrl = node.getFileInfo().getUrl();
        this.chooseScript((Collection<? extends Script>)node.getFileInfo().getScripts$JavaScriptDebugger(), context).done((Consumer)new Consumer<Script>(this, sourceUrl){
            final /* synthetic */ VisualizeScriptSourcemap this$0;
            final /* synthetic */ Url $sourceUrl;

            public final void consume(Script script) {
                Script script2 = script;
                Intrinsics.checkExpressionValueIsNotNull((Object)script2, (String)"script");
                VisualizeScriptSourcemap.access$visualize(this.this$0, script2, this.$sourceUrl);
            }
            {
                this.this$0 = visualizeScriptSourcemap;
                this.$sourceUrl = url;
            }
        });
    }

    private final void visualize(Script script, Url sourceUrl) {
        SourceMap sourceMap = script.getSourceMap();
        if (sourceMap == null) {
            return;
        }
        SourceMap map = sourceMap;
        JavaScriptDebuggerViewSupport viewSupport = this.getTreeComponent().getDebugProcess().getDebuggerViewSupport();
        Vm vm = viewSupport.getDebugProcess().getActiveOrMainVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        viewSupport.getFileByUrlOrVmSource(vm, script, true).done((Consumer)new ConsumerOnEdt<VirtualFile>(this, map, sourceUrl, script, this.getProject()){
            final /* synthetic */ VisualizeScriptSourcemap this$0;
            final /* synthetic */ SourceMap $map;
            final /* synthetic */ Url $sourceUrl;
            final /* synthetic */ Script $script;

            public void consume(@NotNull Project project, @NotNull VirtualFile file) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                VisualizeSourceMapActionKt.visualizeMap(this.$map, file, this.$sourceUrl, project, new SourceFileFinder(this){
                    final /* synthetic */ visualize.1 this$0;

                    @Nullable
                    public VirtualFile find(@NotNull Url source) {
                        VirtualFile virtualFile;
                        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                        VirtualFile virtualFile2 = SourceMapInspectorKt.createSourceFromProvidedContent(this.this$0.$map, source, (UserDataHolder)this.this$0.$script);
                        if (virtualFile2 == null) {
                            virtualFile2 = virtualFile = SourceMapInspectorKt.getSourceFile(source);
                        }
                        if (virtualFile2 == null) {
                            virtualFile = this.this$0.this$0.getTreeComponent().getDebugProcess().findFileOrAny(source);
                        }
                        return virtualFile;
                    }
                    {
                        this.this$0 = $outer;
                    }
                });
            }
            {
                this.this$0 = $outer;
                this.$map = $captured_local_variable$1;
                this.$sourceUrl = $captured_local_variable$2;
                this.$script = $captured_local_variable$3;
                super($super_call_param$4);
            }
        });
    }

    public VisualizeScriptSourcemap(@NotNull SourcesTreeComponent treeComponent) {
        Intrinsics.checkParameterIsNotNull((Object)treeComponent, (String)"treeComponent");
        super(treeComponent, "Visualize Source Map");
    }

    public static final /* synthetic */ void access$visualize(VisualizeScriptSourcemap $this, @NotNull Script script, @NotNull Url sourceUrl) {
        $this.visualize(script, sourceUrl);
    }
}

