/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.sourcemap.visualizer.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.javascript.debugger.sourcemap.SourceMapFileType;
import com.jetbrains.javascript.debugger.sourcemap.visualizer.actions.VisualizeSourceMapAction;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceMapDecoderKt;
import org.jetbrains.debugger.sourcemap.SourceResolver;
import org.jetbrains.debugger.sourcemap.SourceResolverKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH$J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0006H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/javascript/debugger/sourcemap/visualizer/actions/BaseSourceMapAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "perform", "map", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "update", "e", "Companion", "JavaScriptDebugger"})
public abstract class BaseSourceMapAction
extends AnAction {
    @JvmField
    @NotNull
    public static final Logger LOG;
    public static final Companion Companion;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        VirtualFile file = BaseSourceMapAction.Companion.getSourceMapFile(e);
        boolean enabled = file != null && e.getProject() != null;
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        VirtualFile file = BaseSourceMapAction.Companion.getSourceMapFile(event);
        Project project = event.getProject();
        if (file == null || project == null) {
            return;
        }
        Pair<SourceMap, Exception> map = Companion.compute(file);
        if (map.first != null) {
            this.perform((SourceMap)map.first, file, project);
        }
    }

    protected abstract void perform(@NotNull SourceMap var1, @NotNull VirtualFile var2, @NotNull Project var3);

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(VisualizeSourceMapAction.class);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0015\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/javascript/debugger/sourcemap/visualizer/actions/BaseSourceMapAction$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "compute", "Lcom/intellij/openapi/util/Pair;", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "Ljava/lang/Exception;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getSourceMapFile", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "JavaScriptDebugger"})
    public static final class Companion {
        private final VirtualFile getSourceMapFile(AnActionEvent e) {
            VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            return file == null || file.getFileType() != SourceMapFileType.INSTANCE ? (VirtualFile)null : file;
        }

        @NotNull
        public final Pair<SourceMap, Exception> compute(@NotNull VirtualFile file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            try {
                CharSequence charSequence = VfsUtilCore.loadText((VirtualFile)file);
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"VfsUtilCore.loadText(file)");
                Pair pair = Pair.create((Object)SourceMapDecoderKt.decodeSourceMap((CharSequence)charSequence, (Function2)((Function2)new Function2<List<? extends String>, List<? extends String>, SourceResolver>(file){
                    final /* synthetic */ VirtualFile $file;

                    @NotNull
                    public final SourceResolver invoke(@NotNull List<String> sourceUrls, @Nullable List<String> sourceContents) {
                        Intrinsics.checkParameterIsNotNull(sourceUrls, (String)"sourceUrls");
                        return SourceResolverKt.SourceResolver$default(sourceUrls, (boolean)false, (Url)Urls.newLocalFileUrl((VirtualFile)this.$file), sourceContents, (boolean)false, (int)16, null);
                    }
                    {
                        this.$file = virtualFile;
                        super(2);
                    }
                })), null);
                Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"Pair.create(decodeSource\u2026 sourceContents) }, null)");
                return pair;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                Pair pair = Pair.create(null, (Object)e);
                Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"Pair.create(null, e)");
                return pair;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

