/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.plugins.drools.lang.psi.DroolsFunction;
import com.intellij.plugins.drools.lang.psi.DroolsFunctionStatement;
import com.intellij.plugins.drools.lang.psi.DroolsNameId;
import com.intellij.plugins.drools.lang.psi.DroolsParameters;
import com.intellij.plugins.drools.lang.psi.DroolsPrimitiveType;
import com.intellij.plugins.drools.lang.psi.DroolsType;
import com.intellij.plugins.drools.lang.psi.impl.DroolsFakePsiMethod;
import com.intellij.plugins.drools.lang.psi.util.DroolsElementsFactory;
import com.intellij.plugins.drools.lang.psi.util.DroolsResolveUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.JavaIdentifier;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class DroolsFunctionImpl
extends DroolsFakePsiMethod
implements DroolsFunction,
DroolsFunctionStatement,
PsiTarget {
    private Computable<PsiType> myReturnType;

    public DroolsFunctionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/plugins/drools/lang/psi/impl/DroolsFunctionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public String getFunctionName() {
        return this.getNameId().getText();
    }

    public String getName() {
        return this.getNameId().getText();
    }

    public PsiIdentifier getNameIdentifier() {
        return new JavaIdentifier((PsiManager)this.getManager(), (PsiElement)this.getNameId());
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/plugins/drools/lang/psi/impl/DroolsFunctionImpl", "setName"));
        }
        DroolsNameId oldIdentifier = this.getNameId();
        DroolsNameId patternBindIdentifier = DroolsElementsFactory.createFunctionNameIdentifier(name, this.getProject());
        if (patternBindIdentifier != null) {
            oldIdentifier.replace((PsiElement)patternBindIdentifier);
        }
        return this;
    }

    public PsiType getReturnType() {
        if (this.myReturnType == null) {
            this.myReturnType = new Computable.NotNullCachedComputable<PsiType>(){

                @NotNull
                protected PsiType internalCompute() {
                    PsiType psiType;
                    DroolsType type = DroolsFunctionImpl.this.getType();
                    if (type != null && (psiType = DroolsResolveUtil.resolveType(type)) != null) {
                        PsiType psiType2 = psiType;
                        if (psiType2 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsFunctionImpl$1", "internalCompute"));
                        }
                        return psiType2;
                    }
                    DroolsPrimitiveType primitiveType = DroolsFunctionImpl.this.getPrimitiveType();
                    if (primitiveType != null) {
                        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)primitiveType.getProject());
                        PsiType psiType3 = elementFactory.createTypeFromText(primitiveType.getText(), (PsiElement)primitiveType);
                        if (psiType3 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsFunctionImpl$1", "internalCompute"));
                        }
                        return psiType3;
                    }
                    PsiPrimitiveType psiPrimitiveType = PsiType.NULL;
                    if (psiPrimitiveType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsFunctionImpl$1", "internalCompute"));
                    }
                    return psiPrimitiveType;
                }
            };
        }
        return (PsiType)this.myReturnType.compute();
    }

    @Override
    protected DroolsParameters getDroolsParameters() {
        return this.getParameters();
    }
}

