/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.psi.searchers;

import com.intellij.plugins.drools.lang.psi.DroolsDeclareStatement;
import com.intellij.plugins.drools.lang.psi.DroolsFile;
import com.intellij.plugins.drools.lang.psi.DroolsTypeDeclaration;
import com.intellij.plugins.drools.lang.psi.util.DroolsLightClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DroolsClassFinder
extends PsiElementFinder {
    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        DroolsFile file;
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/plugins/drools/lang/psi/searchers/DroolsClassFinder", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/plugins/drools/lang/psi/searchers/DroolsClassFinder", "findClass"));
        }
        if (scope instanceof DroolsFile.DroolsFileSearchScope && (file = ((DroolsFile.DroolsFileSearchScope)scope).getFile()) != null) {
            for (DroolsDeclareStatement declareStatement : file.getDeclarations()) {
                DroolsTypeDeclaration typeDeclaration = declareStatement.getTypeDeclaration();
                if (typeDeclaration == null || !qualifiedName.equals(typeDeclaration.getQualifiedName())) continue;
                return new DroolsLightClass(typeDeclaration);
            }
        }
        return null;
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass[] psiClassArray;
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/plugins/drools/lang/psi/searchers/DroolsClassFinder", "findClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/plugins/drools/lang/psi/searchers/DroolsClassFinder", "findClasses"));
        }
        PsiClass aClass = this.findClass(qualifiedName, scope);
        if (aClass == null) {
            psiClassArray = PsiClass.EMPTY_ARRAY;
        } else {
            PsiClass[] psiClassArray2 = new PsiClass[1];
            psiClassArray = psiClassArray2;
            psiClassArray2[0] = aClass;
        }
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/searchers/DroolsClassFinder", "findClasses"));
        }
        return psiClassArray;
    }
}

