/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.psi.util.processors;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.plugins.drools.lang.psi.DroolsFile;
import com.intellij.plugins.drools.lang.psi.DroolsLhsPatternBind;
import com.intellij.plugins.drools.lang.psi.DroolsNameId;
import com.intellij.plugins.drools.lang.psi.DroolsParentRule;
import com.intellij.plugins.drools.lang.psi.DroolsPsiCompositeElement;
import com.intellij.plugins.drools.lang.psi.DroolsRuleStatement;
import com.intellij.plugins.drools.lang.psi.DroolsStringId;
import com.intellij.plugins.drools.lang.psi.DroolsUnaryAssignExpr;
import com.intellij.plugins.drools.lang.psi.DroolsVisitor;
import com.intellij.plugins.drools.lang.psi.util.processors.DroolsDeclarationsProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DroolsLhsBindVariablesProcessor
implements DroolsDeclarationsProcessor {
    private static DroolsLhsBindVariablesProcessor myInstance;

    private DroolsLhsBindVariablesProcessor() {
    }

    public static DroolsLhsBindVariablesProcessor getInstance() {
        if (myInstance == null) {
            myInstance = new DroolsLhsBindVariablesProcessor();
        }
        return myInstance;
    }

    @Override
    public boolean processElement(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place, @NotNull DroolsFile droolsFile) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsLhsBindVariablesProcessor", "processElement"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsLhsBindVariablesProcessor", "processElement"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsLhsBindVariablesProcessor", "processElement"));
        }
        if (droolsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "droolsFile", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsLhsBindVariablesProcessor", "processElement"));
        }
        Set<PsiVariable> binds = DroolsLhsBindVariablesProcessor.getPatternBinds(place);
        for (PsiVariable bind : binds) {
            if (processor.execute((PsiElement)bind, state)) continue;
            return false;
        }
        return true;
    }

    public static Set<PsiVariable> getPatternBinds(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsLhsBindVariablesProcessor", "getPatternBinds"));
        }
        PsiFile file = psiElement.getContainingFile();
        return file instanceof DroolsFile ? DroolsLhsBindVariablesProcessor.getPatternBinds(psiElement, (DroolsFile)file, (DroolsRuleStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, DroolsRuleStatement.class)) : Collections.emptySet();
    }

    private static Set<PsiVariable> getPatternBinds(@NotNull PsiElement psiElement, @NotNull DroolsFile droolsFile, @Nullable DroolsRuleStatement droolsRule) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsLhsBindVariablesProcessor", "getPatternBinds"));
        }
        if (droolsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "droolsFile", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsLhsBindVariablesProcessor", "getPatternBinds"));
        }
        return DroolsLhsBindVariablesProcessor.getPatternBinds(psiElement, droolsFile, droolsRule, (Set<DroolsRuleStatement>)new HashSet());
    }

    private static Set<PsiVariable> getPatternBinds(@NotNull PsiElement psiElement, @NotNull DroolsFile droolsFile, @Nullable DroolsRuleStatement droolsRule, Set<DroolsRuleStatement> visited) {
        DroolsRuleStatement parentRule;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsLhsBindVariablesProcessor", "getPatternBinds"));
        }
        if (droolsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "droolsFile", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsLhsBindVariablesProcessor", "getPatternBinds"));
        }
        if (droolsRule == null) {
            return Collections.emptySet();
        }
        visited.add(droolsRule);
        Set<PsiVariable> binds = DroolsLhsBindVariablesProcessor.getVariables(psiElement, droolsRule);
        DroolsParentRule parentRuleRef = droolsRule.getParentRule();
        if (parentRuleRef != null && (parentRule = DroolsLhsBindVariablesProcessor.findRuleById(parentRuleRef.getStringId(), droolsFile)) != null && !visited.contains(parentRule)) {
            binds.addAll(DroolsLhsBindVariablesProcessor.getPatternBinds(psiElement, droolsFile, parentRule, visited));
        }
        return binds;
    }

    private static Set<PsiVariable> getVariables(PsiElement psiElement, DroolsRuleStatement droolsRule) {
        HashSet binds = new HashSet();
        droolsRule.acceptChildren(new DroolsVisitor((Set)binds, psiElement){
            final /* synthetic */ Set val$binds;
            final /* synthetic */ PsiElement val$psiElement;
            {
                this.val$binds = set;
                this.val$psiElement = psiElement;
            }

            @Override
            public void visitLhsPatternBind(@NotNull DroolsLhsPatternBind patternBind) {
                String id;
                if (patternBind == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternBind", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsLhsBindVariablesProcessor$1", "visitLhsPatternBind"));
                }
                DroolsNameId bindIdentifier = patternBind.getNameId();
                if (bindIdentifier != null && (id = bindIdentifier.getText()) != null) {
                    this.val$binds.add(patternBind);
                }
                patternBind.acceptChildren(this);
            }

            @Override
            public void visitUnaryAssignExpr(@NotNull DroolsUnaryAssignExpr unaryAssignExpr) {
                DroolsUnaryAssignExpr parentUnaryAssignExpr;
                if (unaryAssignExpr == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unaryAssignExpr", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsLhsBindVariablesProcessor$1", "visitUnaryAssignExpr"));
                }
                DroolsNameId identifier = unaryAssignExpr.getNameId();
                String id = identifier.getText();
                if (id != null && !unaryAssignExpr.equals(parentUnaryAssignExpr = (DroolsUnaryAssignExpr)PsiTreeUtil.getParentOfType((PsiElement)this.val$psiElement, DroolsUnaryAssignExpr.class))) {
                    this.val$binds.add(unaryAssignExpr);
                }
            }

            @Override
            public void visitPsiCompositeElement(@NotNull DroolsPsiCompositeElement o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsLhsBindVariablesProcessor$1", "visitPsiCompositeElement"));
                }
                o.acceptChildren(this);
            }
        });
        return binds;
    }

    @Nullable
    private static DroolsRuleStatement findRuleById(@Nullable DroolsStringId id, @NotNull DroolsFile droolsFile) {
        String ruleIdText;
        if (droolsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "droolsFile", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsLhsBindVariablesProcessor", "findRuleById"));
        }
        if (id != null && !StringUtil.isEmpty((String)(ruleIdText = id.getText()))) {
            for (DroolsRuleStatement ruleStatement : droolsFile.getRules()) {
                if (!ruleIdText.equals(ruleStatement.getRuleName().getStringId().getText())) continue;
                return ruleStatement;
            }
        }
        return null;
    }
}

