/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.usageView.UsageInfo;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CssDuplocateVisitor
implements DuplocateVisitor {
    private final Map<TIntHashSet, MyDuplicateData> duplicatesMap = new HashMap<TIntHashSet, MyDuplicateData>();
    private final TIntObjectHashMap<List<CssDeclaration>> cache = new TIntObjectHashMap();
    private final FragmentsCollector myCollector;
    private final int myLowerBound;

    public CssDuplocateVisitor(FragmentsCollector collector, int lowerBound) {
        this.myCollector = collector;
        this.myLowerBound = lowerBound;
    }

    private static int cache(TIntObjectHashMap<List<CssDeclaration>> cache, @NotNull CssDeclaration element) {
        ArrayList<CssDeclaration> elements;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dupLocator/CssDuplocateVisitor", "cache"));
        }
        int hash = CssPsiUtil.hashCodeForElement((PsiElement)element);
        if (cache == null) {
            cache = new TIntObjectHashMap();
        }
        if ((elements = (ArrayList<CssDeclaration>)cache.get(hash)) == null) {
            elements = new ArrayList<CssDeclaration>();
            cache.put(hash, elements);
        }
        elements.add(element);
        return hash;
    }

    private static TIntHashSet intersect(TIntHashSet s1, TIntHashSet s2) {
        TIntHashSet result = new TIntHashSet();
        for (int n : s1) {
            if (!s2.contains(n)) continue;
            result.add(n);
        }
        return result;
    }

    private static void addDuplicate(Map<TIntHashSet, MyDuplicateData> duplicatesMap, MyDuplicateData duplicateData) {
        MyDuplicateData concurrent = duplicatesMap.get(duplicateData.myDeclarationHashes);
        if (concurrent == null || concurrent.myBlocks.size() < duplicateData.myBlocks.size()) {
            duplicatesMap.put(duplicateData.myDeclarationHashes, duplicateData);
        }
    }

    private void addNewDuplicates(CssBlock block, TIntHashSet declarationHashes, Map<TIntHashSet, MyDuplicateData> duplicatesMap) {
        boolean addTrivialDuplicate = true;
        ArrayList<MyDuplicateData> newDuplicateDatas = new ArrayList<MyDuplicateData>();
        for (MyDuplicateData duplicateData : duplicatesMap.values()) {
            TIntHashSet candidateDeclHashes = CssDuplocateVisitor.intersect(declarationHashes, duplicateData.myDeclarationHashes);
            int n = candidateDeclHashes.size();
            if (n < this.myLowerBound) continue;
            if (n == declarationHashes.size()) {
                addTrivialDuplicate = false;
            }
            MyDuplicateData newDuplicateData = new MyDuplicateData();
            newDuplicateData.myDeclarationHashes = candidateDeclHashes;
            newDuplicateData.myBlocks = new HashSet<CssBlock>(duplicateData.myBlocks);
            newDuplicateData.myBlocks.add(block);
            newDuplicateDatas.add(newDuplicateData);
        }
        if (addTrivialDuplicate) {
            CssDuplocateVisitor.addDuplicate(duplicatesMap, new MyDuplicateData(block, declarationHashes));
        }
        for (MyDuplicateData newDuplicateData : newDuplicateDatas) {
            CssDuplocateVisitor.addDuplicate(duplicatesMap, newDuplicateData);
        }
    }

    private void addPattern(Collection<List<CssDeclaration>> pattern, int hash) {
        ArrayList<1> fragmentList = new ArrayList<1>();
        for (List<CssDeclaration> block : pattern) {
            Collections.sort(block, (d1, d2) -> {
                int offset2;
                int offset1 = d1.getTextOffset();
                if (offset1 > (offset2 = d2.getTextOffset())) {
                    return 1;
                }
                if (offset1 == offset2) {
                    return 0;
                }
                return -1;
            });
            PsiFragment fragment = new PsiFragment(block){

                public boolean isEqual(PsiElement[] elements, int discardCost) {
                    return true;
                }

                public UsageInfo getUsageInfo() {
                    PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement[])this.getElements());
                    PsiElement ruleset = PsiTreeUtil.getParentOfType((PsiElement)(parent = PsiTreeUtil.getParentOfType((PsiElement)parent, CssBlock.class, (boolean)false)), CssRuleset.class, (boolean)false);
                    if (ruleset != null) {
                        parent = ruleset;
                    }
                    return parent != null ? new UsageInfo(parent) : null;
                }
            };
            fragmentList.add(fragment);
        }
        Collections.sort(fragmentList, (f1, f2) -> {
            int offset2;
            int offset1 = f1.getStartOffset();
            if (offset1 < (offset2 = f2.getStartOffset())) {
                return -1;
            }
            if (offset1 > offset2) {
                return 1;
            }
            return 0;
        });
        PsiFragment[] fragments = fragmentList.toArray(new PsiFragment[fragmentList.size()]);
        PsiFragment first = fragments[0];
        int cost = first.getElements().length;
        for (PsiFragment fragment : fragments) {
            this.myCollector.add(hash, cost, fragment);
        }
    }

    public void visitNode(@NotNull PsiElement node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dupLocator/CssDuplocateVisitor", "visitNode"));
        }
        PsiFile file = node.getContainingFile();
        if (file instanceof CssFile || file instanceof XmlFile) {
            file.accept((PsiElementVisitor)new CssElementVisitor(){

                public void visitCssBlock(CssBlock block) {
                    CssDeclaration[] declarations = block.getDeclarations();
                    if (declarations.length >= CssDuplocateVisitor.this.myLowerBound) {
                        TIntHashSet blockHashes = new TIntHashSet();
                        for (CssDeclaration declaration : declarations) {
                            int declarationHash = CssDuplocateVisitor.cache((TIntObjectHashMap<List<CssDeclaration>>)CssDuplocateVisitor.this.cache, declaration);
                            blockHashes.add(declarationHash);
                        }
                        CssDuplocateVisitor.this.addNewDuplicates(block, blockHashes, CssDuplocateVisitor.this.duplicatesMap);
                    }
                }

                public void visitElement(PsiElement element) {
                    element.acceptChildren((PsiElementVisitor)this);
                }
            });
        }
    }

    public void hashingFinished() {
        ApplicationManager.getApplication().runReadAction(() -> {
            for (MyDuplicateData duplicateData : this.duplicatesMap.values()) {
                if (duplicateData.isTrivial()) continue;
                HashMap<CssBlock, ArrayList<CssDeclaration>> rulesets2declarations = new HashMap<CssBlock, ArrayList<CssDeclaration>>();
                for (int hash : duplicateData.myDeclarationHashes) {
                    for (CssDeclaration declaration : (List)this.cache.get(hash)) {
                        CssBlock ruleset = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)declaration, CssBlock.class);
                        assert (ruleset != null);
                        if (!duplicateData.myBlocks.contains(ruleset)) continue;
                        ArrayList<CssDeclaration> declarations = (ArrayList<CssDeclaration>)rulesets2declarations.get(ruleset);
                        if (declarations == null) {
                            declarations = new ArrayList<CssDeclaration>();
                            rulesets2declarations.put(ruleset, declarations);
                        }
                        declarations.add(declaration);
                    }
                }
                this.addPattern(rulesets2declarations.values(), duplicateData.myDeclarationHashes.hashCode());
            }
        });
    }

    private static class MyDuplicateData {
        Set<CssBlock> myBlocks;
        TIntHashSet myDeclarationHashes;

        MyDuplicateData() {
        }

        boolean isTrivial() {
            return this.myBlocks.size() == 1;
        }

        MyDuplicateData(CssBlock ruleset, TIntHashSet declarationHashes) {
            this.myBlocks = new HashSet<CssBlock>();
            this.myBlocks.add(ruleset);
            this.myDeclarationHashes = declarationHashes;
        }
    }
}

