/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.ruleset;

import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.actions.ruleset.StyleCreatorWithFileChooser;
import com.intellij.psi.css.index.CssSupportedFileTypesProvider;
import com.intellij.psi.css.util.CssFileTypeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewFileStyleCreator
extends StyleCreatorWithFileChooser {
    public NewFileStyleCreator(@NotNull PsiFile contextFile) {
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/intellij/psi/css/actions/ruleset/NewFileStyleCreator", "<init>"));
        }
        super(CssBundle.message((String)"css.inspections.create.style.new.file", (Object[])new Object[0]), contextFile);
    }

    @Override
    @Nullable
    protected CssFile chooseFile() {
        PsiFile psiFile;
        VirtualFile virtualFile;
        Project project = this.myContextFile.getProject();
        CssFileSaverDescriptor fileSaverDescriptor = new CssFileSaverDescriptor();
        fileSaverDescriptor.setRoots(ProjectRootManager.getInstance((Project)project).getContentRoots());
        fileSaverDescriptor.withTreeRootVisible(true);
        VirtualFileWrapper wrapper = FileChooserFactory.getInstance().createSaveFileDialog((FileSaverDescriptor)fileSaverDescriptor, project).save(null, null);
        if (wrapper != null && (virtualFile = wrapper.getVirtualFile(true)) != null && (psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile)) != null && psiFile instanceof CssFile) {
            return (CssFile)psiFile;
        }
        return null;
    }

    private static class CssFileSaverDescriptor
    extends FileSaverDescriptor {
        public CssFileSaverDescriptor() {
            super(CssBundle.message((String)"css.inspections.create.style.new.file.title", (Object[])new Object[0]), CssBundle.message((String)"css.inspections.create.style.new.file.text", (Object[])new Object[0]), CssFileTypeUtil.getAllCssExtensions());
        }

        public boolean isFileVisible(@NotNull VirtualFile file, boolean showHiddenFiles) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/actions/ruleset/NewFileStyleCreator$CssFileSaverDescriptor", "isFileVisible"));
            }
            return super.isFileVisible(file, showHiddenFiles) || CssSupportedFileTypesProvider.isSupportedFileType(file.getFileType());
        }

        public boolean isFileSelectable(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/actions/ruleset/NewFileStyleCreator$CssFileSaverDescriptor", "isFileSelectable"));
            }
            return super.isFileSelectable(file) && CssSupportedFileTypesProvider.isSupportedFileType(file.getFileType());
        }
    }
}

