/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.descriptor;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssPropertyInfo;
import com.intellij.psi.css.CssPropertyValue;
import com.intellij.psi.css.descriptor.CssMediaGroup;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.impl.descriptor.CssCommonDescriptorData;
import com.intellij.psi.css.impl.descriptor.CssValueOwnerDescriptorImpl;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssPropertyDescriptorImplEx
extends CssValueOwnerDescriptorImpl
implements CssPropertyDescriptor {
    @Nullable
    private final String myInitialValue;
    @NotNull
    private final CssMediaGroup[] myMediaGroups;
    @Nullable
    private final String myAppliesToValue;
    @Nullable
    private final String myPercentageValue;
    private final boolean myInherited;

    public CssPropertyDescriptorImplEx(@NotNull CssCommonDescriptorData commonDescriptorData, @NotNull CssValueDescriptor valueDescriptor, @Nullable String initialValue, @Nullable String appliesToValue, @Nullable String percentageValue, boolean inherited, @NotNull CssMediaGroup[] mediaGroups) {
        if (commonDescriptorData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonDescriptorData", "com/intellij/psi/css/impl/descriptor/CssPropertyDescriptorImplEx", "<init>"));
        }
        if (valueDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueDescriptor", "com/intellij/psi/css/impl/descriptor/CssPropertyDescriptorImplEx", "<init>"));
        }
        if (mediaGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mediaGroups", "com/intellij/psi/css/impl/descriptor/CssPropertyDescriptorImplEx", "<init>"));
        }
        super(commonDescriptorData, valueDescriptor);
        this.myInitialValue = initialValue;
        this.myAppliesToValue = appliesToValue;
        this.myPercentageValue = percentageValue;
        this.myInherited = inherited;
        this.myMediaGroups = mediaGroups;
    }

    @NotNull
    public CssMediaGroup[] getMediaGroups() {
        if (this.myMediaGroups == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/CssPropertyDescriptorImplEx", "getMediaGroups"));
        }
        return this.myMediaGroups;
    }

    public boolean isInherited() {
        return this.myInherited;
    }

    @Nullable
    public String getAppliesToValue() {
        return this.myAppliesToValue;
    }

    @Nullable
    public String getInitialValue() {
        return this.myInitialValue;
    }

    @Nullable
    public String getPercentageValue() {
        return this.myPercentageValue;
    }

    @NotNull
    public String getPropertyName() {
        String string = this.getId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/CssPropertyDescriptorImplEx", "getPropertyName"));
        }
        return string;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return AllIcons.Css.Property;
    }

    @Override
    @NotNull
    public String getElementTypeName() {
        String string = CssBundle.message((String)"css.property", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/CssPropertyDescriptorImplEx", "getElementTypeName"));
        }
        return string;
    }

    @Override
    protected void fillWithAttributesDescription(@NotNull StringBuilder builder) {
        String percentageValue;
        String appliesToValue;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/psi/css/impl/descriptor/CssPropertyDescriptorImplEx", "fillWithAttributesDescription"));
        }
        super.fillWithAttributesDescription(builder);
        String initialValue = this.getInitialValue();
        if (!StringUtil.isEmpty((String)initialValue)) {
            builder.append("Initial value: ").append(initialValue).append("<br/>");
        }
        if (!StringUtil.isEmpty((String)(appliesToValue = this.getAppliesToValue()))) {
            builder.append("Applies to: ").append(appliesToValue).append("<br/>");
        }
        if (!StringUtil.isEmpty((String)(percentageValue = this.getPercentageValue()))) {
            builder.append("Percentage: ").append(percentageValue).append("<br/>");
        }
        builder.append("Inherited: ").append(this.isInherited() ? "yes" : "no").append("<br/>");
        builder.append("Media: ").append(StringUtil.join((Object[])this.getMediaGroups(), group -> group.name().toLowerCase(Locale.US), (String)", ")).append("<br/>");
    }

    public boolean isValidValue(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/descriptor/CssPropertyDescriptorImplEx", "isValidValue"));
        }
        return false;
    }

    public boolean isShorthandValue() {
        return false;
    }

    @NotNull
    public String[] expand(@NotNull CssDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/psi/css/impl/descriptor/CssPropertyDescriptorImplEx", "expand"));
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/CssPropertyDescriptorImplEx", "expand"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Nullable
    public PsiElement[] getShorthandPsiValue(@NotNull CssDeclaration decl, @NotNull String propertyName) {
        if (decl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decl", "com/intellij/psi/css/impl/descriptor/CssPropertyDescriptorImplEx", "getShorthandPsiValue"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/descriptor/CssPropertyDescriptorImplEx", "getShorthandPsiValue"));
        }
        return new PsiElement[0];
    }

    public boolean is4ValueProperty() {
        return false;
    }

    public CssPropertyValue getReferencedPropertyValue(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/descriptor/CssPropertyDescriptorImplEx", "getReferencedPropertyValue"));
        }
        return null;
    }

    @NotNull
    public CssPropertyInfo[] getInfos() {
        CssPropertyInfo[] cssPropertyInfoArray = new CssPropertyInfo[]{};
        if (cssPropertyInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/CssPropertyDescriptorImplEx", "getInfos"));
        }
        return cssPropertyInfoArray;
    }

    public Object[] getAllVariants() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Nullable
    public String[] getRefNames() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public Object[] getVariants(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/psi/css/impl/descriptor/CssPropertyDescriptorImplEx", "getVariants"));
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/CssPropertyDescriptorImplEx", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean getInherited() {
        return false;
    }

    @NotNull
    public String toCanonicalName(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/descriptor/CssPropertyDescriptorImplEx", "toCanonicalName"));
        }
        String string = propertyName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/CssPropertyDescriptorImplEx", "toCanonicalName"));
        }
        return string;
    }

    public CssPropertyValue getValue() {
        return null;
    }

    @NotNull
    public PsiElement[] getDeclarations(PsiElement context) {
        PsiElement[] psiElementArray = new PsiElement[]{};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/CssPropertyDescriptorImplEx", "getDeclarations"));
        }
        return psiElementArray;
    }

    public boolean allowsIntegerWithoutSuffix() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CssPropertyDescriptorImplEx)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CssPropertyDescriptorImplEx ex = (CssPropertyDescriptorImplEx)o;
        if (this.myInherited != ex.myInherited) {
            return false;
        }
        if (this.myInitialValue != null ? !this.myInitialValue.equals(ex.myInitialValue) : ex.myInitialValue != null) {
            return false;
        }
        if (!Arrays.equals(this.myMediaGroups, ex.myMediaGroups)) {
            return false;
        }
        return !(this.myPercentageValue != null ? !this.myPercentageValue.equals(ex.myPercentageValue) : ex.myPercentageValue != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myInitialValue != null ? this.myInitialValue.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.myMediaGroups);
        result = 31 * result + (this.myPercentageValue != null ? this.myPercentageValue.hashCode() : 0);
        result = 31 * result + (this.myInherited ? 1 : 0);
        return result;
    }
}

