/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.DocumentationProviderEx;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssDescriptorOwner;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssMediaFeatureDescriptor;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssPseudoSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.descriptor.CssCompositeElementDescriptor;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoClassDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoElementDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTreeElementFactory;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CharTable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.ColorSampleLookupValue;
import com.intellij.xml.util.documentation.HtmlDocumentationProvider;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssDocumentationProvider
extends DocumentationProviderEx {
    @NotNull
    private final DocumentationProvider myHtmlProvider;

    public CssDocumentationProvider() {
        DocumentationProvider htmlProvider = LanguageDocumentation.INSTANCE.forLanguage((Language)HTMLLanguage.INSTANCE);
        if (htmlProvider instanceof HtmlDocumentationProvider) {
            htmlProvider = new HtmlDocumentationProvider(false);
        } else if (htmlProvider instanceof CompositeDocumentationProvider) {
            ArrayList providers = ContainerUtil.newArrayList();
            for (DocumentationProvider provider : ((CompositeDocumentationProvider)htmlProvider).getProviders()) {
                if (provider instanceof HtmlDocumentationProvider) {
                    providers.add(new HtmlDocumentationProvider(false));
                    continue;
                }
                providers.add(provider);
            }
            htmlProvider = CompositeDocumentationProvider.wrapProviders((Collection)providers);
        }
        this.myHtmlProvider = htmlProvider;
    }

    @NotNull
    public static String[] getUrlsFor(@NotNull String descriptorText, PsiElement context) {
        if (descriptorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorText", "com/intellij/psi/css/impl/util/CssDocumentationProvider", "getUrlsFor"));
        }
        Collection descriptors = CssDescriptorsUtil.sortDescriptors((Collection)CssDescriptorsUtil.getPropertyDescriptors((String)descriptorText, (PsiElement)context));
        if (!descriptors.isEmpty()) {
            LinkedHashSet urls = ContainerUtil.newLinkedHashSet();
            for (CssElementDescriptor descriptor : descriptors) {
                ContainerUtil.addIfNotNull((Collection)urls, (Object)descriptor.getSpecificationUrl());
            }
            String[] stringArray = ArrayUtil.toStringArray((Collection)urls);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssDocumentationProvider", "getUrlsFor"));
            }
            return stringArray;
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssDocumentationProvider", "getUrlsFor"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        ItemPresentation presentation;
        CssSelectorSuffixType suffixType;
        if (element instanceof CssSelectorSuffix && (suffixType = ((CssSelectorSuffix)element).getType()) != CssSelectorSuffixType.UNKNOWN && (presentation = ((NavigationItem)element).getPresentation()) != null) {
            String fileName = null;
            if (element.getContainingFile() != null) {
                fileName = element.getContainingFile().getName();
            }
            if (suffixType == CssSelectorSuffixType.CLASS) {
                return CssBundle.message((String)(fileName == null ? "css.class.term" : "css.class.term.with.file"), (Object[])new Object[]{presentation.getPresentableText(), fileName});
            }
            return CssBundle.message((String)(fileName == null ? "css.id.term" : "css.id.term.with.file"), (Object[])new Object[]{presentation.getPresentableText(), fileName});
        }
        return null;
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        String urlForHtml;
        PsiElement docElement = CssDocumentationProvider.findDocumentationElement(element);
        if (docElement instanceof CssDescriptorOwner) {
            ArrayList result = Lists.newArrayList();
            PsiElement context = originalElement != null ? originalElement : docElement;
            for (CssElementDescriptor cssElementDescriptor : CssDocumentationProvider.getFilteredAndSortedDescriptors((CssDescriptorOwner)docElement, context)) {
                String specificationUrl = cssElementDescriptor.getSpecificationUrl();
                if (specificationUrl == null) continue;
                result.add(specificationUrl);
            }
            return result;
        }
        PsiElement tagElement = CssDocumentationProvider.findTagElement(element);
        if (tagElement != null && (urlForHtml = HtmlDocumentationProvider.getUrlForHtml((PsiElement)tagElement, null)) != null) {
            return Collections.singletonList(urlForHtml);
        }
        return null;
    }

    @Nullable
    private static PsiElement findDocumentationElement(PsiElement element) {
        PsiElement docElement = element;
        if (!CssUtil.isCssDeclaration(element) || CssPsiUtil.isInFunction((PsiElement)element)) {
            docElement = CssDocumentationProvider.getDocumentationElement(element);
        }
        return docElement;
    }

    @Nullable
    public static PsiElement getDocumentationElement(@Nullable PsiElement element) {
        PsiElement context;
        if (element == null) {
            return null;
        }
        CssDescriptorOwner descriptorOwner = CssDocumentationProvider.findDescriptorOwner(element);
        if (descriptorOwner != null) {
            return descriptorOwner;
        }
        PsiElement prevContext = element;
        if (context instanceof PsiFile) {
            while (prevContext.getPrevSibling() != null) {
                prevContext = prevContext.getPrevSibling();
            }
            return CssUtil.isIdent(prevContext) ? prevContext : null;
        }
        if (!(context instanceof CssElement) && !(element instanceof XmlToken)) {
            return null;
        }
        for (context = element.getContext(); context != null; context = context.getContext()) {
            PsiElement prevSibling = prevContext.getPrevSibling();
            if (context instanceof XmlAttributeValue && prevSibling instanceof CssBlock) {
                return prevSibling.findElementAt(prevSibling.getTextLength() - 2);
            }
            if (context instanceof CssSimpleSelector) {
                return ((CssSimpleSelector)context).getNameIdentifier();
            }
            if (context instanceof CssStylesheet || context instanceof CssDeclaration) {
                return CssDocumentationProvider.getIdent(context);
            }
            prevContext = context;
        }
        return null;
    }

    @Nullable
    private static PsiElement getIdent(@NotNull PsiElement declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/psi/css/impl/util/CssDocumentationProvider", "getIdent"));
        }
        PsiElement firstChild = declaration.getFirstChild();
        return CssUtil.isIdent(firstChild) ? firstChild : null;
    }

    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        String doc;
        PsiElement docElement = CssDocumentationProvider.findDocumentationElement(element);
        if (docElement != null && (doc = CssDocumentationProvider.generateDoc(docElement.getText(), docElement, originalElement)) != null) {
            return doc;
        }
        PsiElement tagElement = CssDocumentationProvider.findTagElement(element);
        if (tagElement != null) {
            return this.myHtmlProvider.generateDoc(tagElement, null);
        }
        return null;
    }

    @Nullable
    private static PsiElement findTagElement(PsiElement element) {
        CssSimpleSelector simpleSelector = (CssSimpleSelector)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{CssSimpleSelector.class});
        if (simpleSelector != null && (simpleSelector == element || simpleSelector.getFirstChild() == element)) {
            return simpleSelector.getNameIdentifier();
        }
        return null;
    }

    @Nullable
    public static String generateDoc(@Nullable String descriptorText, @NotNull PsiElement documentationElement, @Nullable PsiElement context) {
        CssElementDescriptorProvider descriptorProvider;
        if (documentationElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentationElement", "com/intellij/psi/css/impl/util/CssDocumentationProvider", "generateDoc"));
        }
        if (descriptorText == null) {
            return null;
        }
        if (documentationElement instanceof CssDescriptorOwner) {
            String documentation;
            PsiElement child;
            Color color;
            PsiElement descriptorProviderContext = context != null ? context : documentationElement;
            Collection<? extends CssElementDescriptor> descriptors = CssDocumentationProvider.getFilteredAndSortedDescriptors((CssDescriptorOwner)documentationElement, descriptorProviderContext);
            if (descriptors.isEmpty()) {
                return null;
            }
            StringBuilder colorText = new StringBuilder();
            if (context != null && (color = CssPsiColorUtil.getColor((child = context.getLastChild()) != null ? child : context)) != null) {
                ColorSampleLookupValue.addColorPreviewAndCodeToLookup((Color)color, (StringBuilder)colorText);
            }
            if (!(documentation = StringUtil.join((Collection)CssDescriptorsUtil.extractDocumentations(descriptors, (PsiElement)context), (String)"<hr/>")).isEmpty()) {
                return colorText.length() > 0 ? colorText + "<br/><hr/>" + documentation : documentation;
            }
        }
        if ((descriptorProvider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)context)) != null) {
            return descriptorProvider.generateDocForSelector(descriptorText, context);
        }
        return null;
    }

    @Nullable
    private static CssDescriptorOwner createNavigationElementForDescriptorOwner(@NotNull CssElementDescriptor descriptor, @Nullable PsiElement context, @NotNull Project project) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/impl/util/CssDocumentationProvider", "createNavigationElementForDescriptorOwner"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/impl/util/CssDocumentationProvider", "createNavigationElementForDescriptorOwner"));
        }
        Language language = CssPsiUtil.getStylesheetLanguage((PsiElement)context);
        String id = descriptor.getId();
        if (descriptor instanceof CssPseudoSelectorDescriptor) {
            return CssElementFactory.getInstance((Project)project).createPseudoSelector(descriptor.getPresentableName(), language);
        }
        if (descriptor instanceof CssFunctionDescriptor) {
            return CssElementFactory.getInstance((Project)project).createFunction(id, language);
        }
        if (descriptor instanceof CssPropertyDescriptor) {
            return CssElementFactory.getInstance((Project)project).createProperty(id, "value", language);
        }
        if (descriptor instanceof CssMediaFeatureDescriptor) {
            return CssElementFactory.getInstance((Project)project).createMediaFeature(id, "value", language);
        }
        if (descriptor instanceof CssCompositeElementDescriptor) {
            return CssDocumentationProvider.createNavigationElementForDescriptorOwner(((CssCompositeElementDescriptor)descriptor).getDescriptorFromLatestSpec(), context, project);
        }
        return null;
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, @Nullable Object object, PsiElement element) {
        if (object == null || object instanceof LiveTemplateLookupElement) {
            return null;
        }
        return CssDocumentationProvider.createNavigationElement(psiManager, object, element);
    }

    @Nullable
    private static PsiElement createNavigationElement(PsiManager psiManager, @NotNull Object lookupObject, @Nullable PsiElement _context) {
        boolean isTag;
        PsiElement docElement;
        CssElementDescriptorProvider provider;
        CssDescriptorOwner descriptorOwner;
        if (lookupObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupObject", "com/intellij/psi/css/impl/util/CssDocumentationProvider", "createNavigationElement"));
        }
        if (lookupObject instanceof CssElementDescriptor && (descriptorOwner = CssDocumentationProvider.createNavigationElementForDescriptorOwner((CssElementDescriptor)lookupObject, _context, psiManager.getProject())) != null) {
            return descriptorOwner;
        }
        String _text = lookupObject.toString();
        Object text = _text;
        Collection propertyDescriptors = CssDescriptorsUtil.getPropertyDescriptors((String)text, (PsiElement)_context);
        PsiElement context = CssDocumentationProvider.findDocumentationElement(_context);
        if (context == null) {
            context = _context;
        }
        if ((provider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)context)) == null) {
            return null;
        }
        if (propertyDescriptors.isEmpty()) {
            String textFromContext = context != null ? StringUtil.notNullize((String)context.getText()).trim() : "";
            propertyDescriptors = provider.findPropertyDescriptors(textFromContext, context);
            text = textFromContext;
        }
        if (!propertyDescriptors.isEmpty()) {
            for (CssPropertyDescriptor propertyDescriptor : propertyDescriptors) {
                PsiElement[] navElements = propertyDescriptor.getDeclarations(_context);
                if (navElements.length != 1) continue;
                return navElements[0];
            }
        }
        if ((docElement = provider.getDocumentationElementForSelector(_text, context)) != null) {
            return docElement;
        }
        if (!propertyDescriptors.isEmpty() || context != null && !provider.providesClassicCss() && provider.isPossibleSelector((String)text, context)) {
            return CssDocumentationProvider.createDummyElement((String)text, context);
        }
        if (context != null && (isTag = CssDescriptorsUtil.isPossibleSelector((String)_text, (PsiElement)context)) && ((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)CSSLanguage.INSTANCE)).isIdentifier(_text, psiManager.getProject())) {
            Language language = CssPsiUtil.getStylesheetLanguage((PsiElement)context);
            return CssElementFactory.getInstance((Project)psiManager.getProject()).createSimpleSelector(_text, language);
        }
        return null;
    }

    @Nullable
    static PsiElement createDummyElement(@NotNull String text, @Nullable PsiElement context) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/css/impl/util/CssDocumentationProvider", "createDummyElement"));
        }
        if (context == null) {
            return null;
        }
        PsiFile file = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)context, PsiFile.class);
        if (file == null) {
            return null;
        }
        FileElement fileElement = DummyHolderFactory.createHolder((PsiManager)context.getManager(), null).getTreeElement();
        CharTable charTable = fileElement.getCharTable();
        LeafPsiElement cssToken = CssTreeElementFactory.createCssToken(CssElementTypes.CSS_IDENT, charTable.intern((CharSequence)text));
        fileElement.rawAddChildren((TreeElement)cssToken);
        cssToken.putUserData(DocumentationManager.ORIGINAL_ELEMENT_KEY, (Object)SmartPointerManager.getInstance((Project)context.getProject()).createSmartPsiElementPointer(context));
        return (PsiElement)cssToken;
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, @NotNull String link, PsiElement context) {
        if (link == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "link", "com/intellij/psi/css/impl/util/CssDocumentationProvider", "getDocumentationElementForLink"));
        }
        Collection descriptors = Collections.emptyList();
        if (link.startsWith("PC:")) {
            descriptors = ContainerUtil.filter((Collection)CssDescriptorsUtil.getPseudoSelectorDescriptors((String)StringUtil.trimStart((String)link, (String)"PC:"), (PsiElement)context), (Condition)new Condition<CssPseudoSelectorDescriptor>(){

                public boolean value(CssPseudoSelectorDescriptor descriptor) {
                    return descriptor instanceof CssPseudoClassDescriptor;
                }
            });
        } else if (link.startsWith("PE:")) {
            descriptors = ContainerUtil.filter((Collection)CssDescriptorsUtil.getPseudoSelectorDescriptors((String)StringUtil.trimStart((String)link, (String)"PE:"), (PsiElement)context), (Condition)new Condition<CssPseudoSelectorDescriptor>(){

                public boolean value(CssPseudoSelectorDescriptor descriptor) {
                    return descriptor instanceof CssPseudoElementDescriptor;
                }
            });
        } else if (link.startsWith("MF:")) {
            descriptors = CssDescriptorsUtil.getMediaFeatureDescriptors((String)StringUtil.trimStart((String)link, (String)"MF:"), (PsiElement)context);
        } else if (link.startsWith("P:")) {
            descriptors = CssDescriptorsUtil.getPropertyDescriptors((String)StringUtil.trimStart((String)link, (String)"P:"), (PsiElement)context);
        } else if (link.startsWith("F:")) {
            descriptors = CssDescriptorsUtil.getFunctionDescriptors((String)StringUtil.trimStart((String)link, (String)"F:"), (PsiElement)context);
        }
        CssElementDescriptor firstDescriptor = (CssElementDescriptor)ContainerUtil.getFirstItem((Collection)CssDescriptorsUtil.sortDescriptors((Collection)descriptors));
        if (firstDescriptor != null) {
            return CssDocumentationProvider.createNavigationElement(psiManager, firstDescriptor, context);
        }
        return CssDocumentationProvider.createNavigationElement(psiManager, link, context);
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/css/impl/util/CssDocumentationProvider", "getCustomDocumentationElement"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/impl/util/CssDocumentationProvider", "getCustomDocumentationElement"));
        }
        CssDescriptorOwner descriptorOwner = CssDocumentationProvider.findDescriptorOwner(contextElement);
        if (descriptorOwner != null) {
            return descriptorOwner;
        }
        CssSimpleSelector simpleSelector = (CssSimpleSelector)PsiTreeUtil.getParentOfType((PsiElement)contextElement, CssSimpleSelector.class, (boolean)false);
        if (simpleSelector != null) {
            return simpleSelector.getNameIdentifier();
        }
        return super.getCustomDocumentationElement(editor, file, contextElement);
    }

    @Nullable
    private static CssDescriptorOwner findDescriptorOwner(PsiElement context) {
        CssDescriptorOwner descriptorOwner = (CssDescriptorOwner)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssDescriptorOwner.class});
        return descriptorOwner != null && descriptorOwner.getParent() instanceof CssPseudoSelector ? (CssDescriptorOwner)descriptorOwner.getParent() : descriptorOwner;
    }

    @NotNull
    private static Collection<? extends CssElementDescriptor> getFilteredAndSortedDescriptors(@NotNull CssDescriptorOwner descriptorOwner, @NotNull PsiElement descriptorProviderContext) {
        if (descriptorOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorOwner", "com/intellij/psi/css/impl/util/CssDocumentationProvider", "getFilteredAndSortedDescriptors"));
        }
        if (descriptorProviderContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorProviderContext", "com/intellij/psi/css/impl/util/CssDocumentationProvider", "getFilteredAndSortedDescriptors"));
        }
        Collection descriptors = descriptorOwner.getDescriptors(descriptorProviderContext);
        Collection filteredByContext = CssDescriptorsUtil.filterDescriptorsByContext((Collection)descriptors, (PsiElement)descriptorProviderContext);
        if (!filteredByContext.isEmpty()) {
            descriptors = filteredByContext;
        }
        Collection collection = descriptors = CssDescriptorsUtil.sortDescriptors((Collection)descriptors);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssDocumentationProvider", "getFilteredAndSortedDescriptors"));
        }
        return collection;
    }
}

