/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.fixes;

import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.impl.util.CssUtil;
import org.jetbrains.annotations.NotNull;

public class CssInsertMissingSemicolonQuickFix
extends LocalQuickFixBase {
    public CssInsertMissingSemicolonQuickFix() {
        super(CssBundle.message((String)"css.inspections.missing.semicolon.fix.message", (Object[])new Object[0]));
    }

    public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/inspections/fixes/CssInsertMissingSemicolonQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/inspections/fixes/CssInsertMissingSemicolonQuickFix", "applyFix"));
        }
        final PsiElement value = descriptor.getPsiElement();
        if (value == null) {
            return;
        }
        PsiFile psiFile = value.getContainingFile();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        new WriteCommandAction(project, new PsiFile[]{psiFile}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/inspections/fixes/CssInsertMissingSemicolonQuickFix$1", "run"));
                }
                CssUtil.appendStatementWithSemicolonIfNeeded(project, value);
            }
        }.execute();
    }
}

