/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.extractors.DataRow;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public abstract class DataStream<T extends DataRow>
implements Iterable<T> {
    private final AtomicBoolean myWasUsed = new AtomicBoolean(false);

    @Override
    public final Iterator<T> iterator() {
        if (!this.myWasUsed.compareAndSet(false, true)) {
            throw new AssertionError((Object)"DataStream can only be iterated once");
        }
        return this.read();
    }

    @NotNull
    protected abstract Iterator<T> read();
}

