/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration;

import com.intellij.ide.presentation.Presentation;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.model.PersistenceListener;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.helpers.PersistenceUnitModelHelper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.PackageListConverter;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.persistence.integration.SpringPersistencePackage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ReadOnlyGenericValue;
import com.intellij.util.xml.impl.ConvertContextFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(icon="SpringApiIcons.SpringConfig")
public abstract class SpringXmlPersistencePackage
extends SpringPersistencePackage<DomSpringBeanPointer>
implements PersistencePackage,
PersistenceUnitModelHelper {
    @NonNls
    public static final String DATASOURCE = "dataSource";
    @NonNls
    public static final String PACKAGES_TO_SCAN = "packagesToScan";
    @NonNls
    public static final String PERSISTENCE_UNIT_NAME = "persistenceUnitName";
    private final CachedValue<Properties> myProperties = CachedValuesManager.getManager((Project)this.getPsiManager().getProject()).createCachedValue(() -> this.getPersistenceUnitPropertiesInner(), false);

    public SpringXmlPersistencePackage(DomSpringBeanPointer bean, Module module) {
        super(bean, module);
    }

    @Override
    @NotNull
    public Properties getPersistenceUnitProperties() {
        Properties properties = (Properties)this.myProperties.getValue();
        if (properties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/persistence/integration/SpringXmlPersistencePackage", "getPersistenceUnitProperties"));
        }
        return properties;
    }

    @NotNull
    protected abstract CachedValueProvider.Result<Properties> getPersistenceUnitPropertiesInner();

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/spring/persistence/integration/SpringXmlPersistencePackage", "getUserData"));
        }
        return (T)this.getBean().getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/spring/persistence/integration/SpringXmlPersistencePackage", "putUserData"));
        }
        this.getBean().putUserData(key, value);
    }

    @Override
    public GenericValue<String> getName() {
        SpringPropertyDefinition name = SpringPropertyUtils.findPropertyByName((CommonSpringBean)this.getBean(), (String)PERSISTENCE_UNIT_NAME);
        GenericDomValue valueElement = name == null ? null : name.getValueElement();
        return valueElement != null && DomUtil.hasXml((DomElement)valueElement) ? valueElement : this.getBean().getId();
    }

    @Override
    @Nullable
    public XmlTag getXmlTag() {
        return this.getBean().getXmlTag();
    }

    protected DomSpringBean getBean() {
        return (DomSpringBean)((DomSpringBeanPointer)this.getBeanPointer()).getSpringBean();
    }

    protected <V extends PersistenceMappings> void addMappings(Collection<V> result, Class<V> mappingsClass, SpringPropertyDefinition property, boolean directory) {
        if (!(property instanceof SpringProperty)) {
            return;
        }
        if (directory) {
            for (PsiDirectory psiDirectory : SpringResourcesUtil.getInstance().getResourceItems((SpringProperty)property, FileReferenceSet.DIRECTORY_FILTER)) {
                this.addMappingsFromDirectory(result, mappingsClass, psiDirectory);
            }
        } else {
            for (PsiFile psiFile : SpringResourcesUtil.getInstance().getResourceItems((SpringProperty)property, FileReferenceSet.FILE_FILTER)) {
                ContainerUtil.addIfNotNull((Object)JamCommonUtil.getRootElement((PsiFile)psiFile, mappingsClass, (Module)this.getModule()), result);
            }
        }
    }

    @Override
    @NotNull
    public List<? extends PersistenceListener> getPersistentListeners() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/persistence/integration/SpringXmlPersistencePackage", "getPersistentListeners"));
        }
        return list;
    }

    @Override
    @Nullable
    public GenericValue<String> getDataSourceName() {
        SpringBeanPointer springBean;
        SpringPropertyDefinition property = SpringPropertyUtils.findPropertyByName((CommonSpringBean)this.getBean(), (String)DATASOURCE);
        if (property != null && (springBean = SpringPropertyUtils.findReferencedBean((SpringPropertyDefinition)property)) != null) {
            String name = springBean.getName();
            return StringUtil.isNotEmpty((String)name) ? ReadOnlyGenericValue.getInstance((Object)name) : null;
        }
        return null;
    }

    protected List<GenericValue<PsiPackage>> getPackagesToScan() {
        ArrayList<GenericValue<PsiPackage>> result = new ArrayList<GenericValue<PsiPackage>>();
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.getModule());
        SpringPropertyDefinition packagesToScan = SpringPropertyUtils.findPropertyByName((CommonSpringBean)this.getBean(), (String)PACKAGES_TO_SCAN);
        if (packagesToScan instanceof SpringProperty) {
            SpringPropertyUtils.processSpringValues((SpringProperty)((SpringProperty)packagesToScan), (genericDomValue, s) -> {
                Object value = genericDomValue.getValue();
                Collection collection = value instanceof Collection ? (Collection)value : new PackageListConverter().fromString(s, ConvertContextFactory.createConvertContext((DomElement)genericDomValue));
                for (Object pkg : collection) {
                    if (!(pkg instanceof PsiPackage)) continue;
                    SpringXmlPersistencePackage.processAllSubPackages((PsiPackage)pkg, scope, this.getPackagesCollectProcessor(result));
                }
                return true;
            });
        }
        return result;
    }
}

