/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el;

import com.intellij.codeInsight.hint.api.impls.MethodParameterInfoHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.jsp.el.ELExpression;
import com.intellij.psi.jsp.el.ELTokenType;
import com.intellij.psi.jsp.el.ELVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.el.psi.SpringELExpression;
import com.intellij.spring.el.psi.SpringELMethodCallExpression;
import com.intellij.spring.el.psi.SpringELNewExpression;
import com.intellij.spring.el.psi.SpringELParameterList;
import com.intellij.spring.el.psi.SpringELQualifiedType;
import com.intellij.spring.el.psi.SpringELVariable;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringELParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<SpringELParameterList, PsiMethod, ELExpression> {
    private static final Set<Class> ALLOWED_PARENT_CLASSES = ContainerUtil.immutableSet((Object[])new Class[]{SpringELMethodCallExpression.class, SpringELNewExpression.class});

    public boolean couldShowInLookup() {
        return true;
    }

    @Nullable
    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        PsiElement element = item.getPsiElement();
        if (element instanceof PsiMethod) {
            return new Object[]{element};
        }
        return null;
    }

    @Nullable
    public Object[] getParametersForDocumentation(PsiMethod p, ParameterInfoContext context) {
        return p.getParameterList().getParameters();
    }

    @Nullable
    public SpringELParameterList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/el/SpringELParameterInfoHandler", "findElementForParameterInfo"));
        }
        PsiElement elementAt = SpringELParameterInfoHandler.findElement((ParameterInfoContext)context);
        SpringELExpression contextElement = (SpringELExpression)PsiTreeUtil.getContextOfType((PsiElement)elementAt, (Class[])new Class[]{SpringELNewExpression.class, SpringELMethodCallExpression.class});
        if (contextElement instanceof SpringELNewExpression) {
            SpringELNewExpression newExpression = (SpringELNewExpression)contextElement;
            SpringELQualifiedType qualifiedType = newExpression.getELQualifiedType();
            if (qualifiedType == null) {
                return null;
            }
            PsiClass fqn = PsiTypesUtil.getPsiClass((PsiType)qualifiedType.getType());
            if (fqn != null) {
                context.setItemsToShow((Object[])fqn.getConstructors());
            }
            return newExpression.getELParameterList();
        }
        if (contextElement instanceof SpringELMethodCallExpression) {
            SpringELMethodCallExpression methodCallExpression = (SpringELMethodCallExpression)contextElement;
            ELVariable method = methodCallExpression.getMethod();
            if (method instanceof SpringELVariable) {
                context.setItemsToShow((Object[])SpringELParameterInfoHandler.getMethodsByName((SpringELVariable)method));
            }
            return methodCallExpression.getELParameterList();
        }
        return null;
    }

    private static PsiElement findElement(@NotNull ParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/el/SpringELParameterInfoHandler", "findElement"));
        }
        return context.getFile().findElementAt(context.getOffset());
    }

    private static PsiMethod[] getMethodsByName(SpringELVariable variable) {
        SmartList candidates = new SmartList();
        for (PsiReference reference : variable.getReferences()) {
            if (reference instanceof PsiPolyVariantReference) {
                ResolveResult[] results;
                for (ResolveResult result : results = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                    PsiElement element = result.getElement();
                    if (!(element instanceof PsiMethod)) continue;
                    candidates.add((PsiMethod)element);
                }
                continue;
            }
            PsiElement resolve = reference.resolve();
            if (!(resolve instanceof PsiMethod)) continue;
            candidates.add((PsiMethod)resolve);
        }
        return candidates.toArray(new PsiMethod[candidates.size()]);
    }

    public void showParameterInfo(@NotNull SpringELParameterList element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/el/SpringELParameterInfoHandler", "showParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/el/SpringELParameterInfoHandler", "showParameterInfo"));
        }
        context.showHint((PsiElement)element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    @Nullable
    public SpringELParameterList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/el/SpringELParameterInfoHandler", "findElementForUpdatingParameterInfo"));
        }
        return (SpringELParameterList)PsiTreeUtil.getParentOfType((PsiElement)SpringELParameterInfoHandler.findElement((ParameterInfoContext)context), SpringELParameterList.class);
    }

    public void updateParameterInfo(@NotNull SpringELParameterList list, @NotNull UpdateParameterInfoContext context) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/spring/el/SpringELParameterInfoHandler", "updateParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/el/SpringELParameterInfoHandler", "updateParameterInfo"));
        }
        if (context.getParameterOwner() != list) {
            context.removeHint();
            return;
        }
        int currentParameterIndex = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)list.getNode(), (int)context.getOffset(), (IElementType)this.getActualParameterDelimiterType());
        context.setCurrentParameter(currentParameterIndex);
    }

    @Nullable
    public String getParameterCloseChars() {
        return ",){}";
    }

    public boolean tracksParameterIndex() {
        return true;
    }

    public void updateUI(PsiMethod p, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/el/SpringELParameterInfoHandler", "updateUI"));
        }
        MethodParameterInfoHandler.updateMethodPresentation((PsiMethod)p, (PsiSubstitutor)PsiSubstitutor.EMPTY, (ParameterInfoUIContext)context);
    }

    @NotNull
    public ELExpression[] getActualParameters(@NotNull SpringELParameterList o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/spring/el/SpringELParameterInfoHandler", "getActualParameters"));
        }
        ELExpression[] eLExpressionArray = o.getParameters();
        if (eLExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/SpringELParameterInfoHandler", "getActualParameters"));
        }
        return eLExpressionArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = ELTokenType.JSP_EL_COMMA;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/SpringELParameterInfoHandler", "getActualParameterDelimiterType"));
        }
        return iElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = ELTokenType.JSP_EL_RPARENTH;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/SpringELParameterInfoHandler", "getActualParametersRBraceType"));
        }
        return iElementType;
    }

    @NotNull
    public Set<Class> getArgumentListAllowedParentClasses() {
        Set<Class> set = ALLOWED_PARENT_CLASSES;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/SpringELParameterInfoHandler", "getArgumentListAllowedParentClasses"));
        }
        return set;
    }

    @NotNull
    public Set<? extends Class> getArgListStopSearchClasses() {
        Set set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/SpringELParameterInfoHandler", "getArgListStopSearchClasses"));
        }
        return set;
    }

    @NotNull
    public Class<SpringELParameterList> getArgumentListClass() {
        if (SpringELParameterList.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/SpringELParameterInfoHandler", "getArgumentListClass"));
        }
        return SpringELParameterList.class;
    }
}

