/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.highlight.analysis.aspect;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.highlight.analysis.ElementAnnotator;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.quickFix.MakeAspectStaticFix;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;

public class NestedAspectStaticAnnotator
extends ElementAnnotator<PsiAspect> {
    @Override
    public boolean annotate(AnnotationHolder holder, PsiAspect aspect) {
        PsiElement parent = aspect.getParent();
        if (!(parent instanceof PsiAspect)) {
            return false;
        }
        PsiModifierList modList = aspect.getModifierList();
        if (modList != null && modList.hasModifierProperty("static")) {
            return false;
        }
        TextRange range = HighlightNamesUtil.getClassDeclarationTextRange((PsiClass)aspect);
        Annotation anno = holder.createErrorAnnotation(range, AspectJBundle.message("highlighting.nested.static", new Object[0]));
        anno.registerFix((IntentionAction)new MakeAspectStaticFix(aspect));
        return true;
    }
}

