/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.GridChangeUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.actions.AbstractGuiEditorAction;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlattenAction
extends AbstractGuiEditorAction {
    public FlattenAction() {
        super(true);
    }

    @Override
    protected void actionPerformed(GuiEditor editor, List<RadComponent> selection, AnActionEvent e) {
        for (RadComponent c : selection) {
            RadContainer container = (RadContainer)c;
            RadContainer parent = container.getParent();
            if (container.getLayoutManager().isGrid()) {
                FlattenAction.flattenGrid(container);
            } else {
                FlattenAction.flattenSimple(container);
            }
            parent.revalidate();
        }
    }

    private static void flattenGrid(RadContainer container) {
        int i;
        RadContainer parent = container.getParent();
        GridConstraints containerConstraints = (GridConstraints)container.getConstraints().clone();
        for (i = containerConstraints.getRowSpan(); i < container.getGridRowCount(); ++i) {
            GridChangeUtil.splitRow(parent, containerConstraints.getRow());
        }
        for (i = containerConstraints.getColSpan(); i < container.getGridColumnCount(); ++i) {
            GridChangeUtil.splitColumn(parent, containerConstraints.getColumn());
        }
        ArrayList<RadComponent> contents = new ArrayList<RadComponent>();
        for (int i2 = container.getComponentCount() - 1; i2 >= 0; --i2) {
            contents.add(0, container.getComponent(i2));
            container.removeComponent(container.getComponent(i2));
        }
        if (contents.size() == 1) {
            ((RadComponent)contents.get(0)).setCustomLayoutConstraints(container.getCustomLayoutConstraints());
        }
        FormEditingUtil.deleteComponents(Collections.singletonList(container), false);
        for (RadComponent child : contents) {
            GridConstraints childConstraints = child.getConstraints();
            childConstraints.setRow(childConstraints.getRow() + containerConstraints.getRow());
            childConstraints.setColumn(childConstraints.getColumn() + containerConstraints.getColumn());
            parent.addComponent(child);
            child.revalidate();
        }
    }

    private static void flattenSimple(RadContainer container) {
        RadContainer parent = container.getParent();
        RadComponent child = null;
        Object childLayoutConstraints = null;
        if (container.getComponentCount() == 1) {
            child = container.getComponent(0);
            childLayoutConstraints = container.getCustomLayoutConstraints();
            child.getConstraints().restore(container.getConstraints());
            container.removeComponent(child);
        }
        int childIndex = parent.indexOfComponent(container);
        FormEditingUtil.deleteComponents(Collections.singletonList(container), false);
        if (child != null) {
            if (childLayoutConstraints != null) {
                child.setCustomLayoutConstraints(childLayoutConstraints);
            }
            parent.addComponent(child, childIndex);
            child.revalidate();
        }
    }

    @Override
    protected void update(@NotNull GuiEditor editor, ArrayList<RadComponent> selection, AnActionEvent e) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/uiDesigner/actions/FlattenAction", "update"));
        }
        for (RadComponent c : selection) {
            if (FlattenAction.canFlatten(c)) continue;
            e.getPresentation().setVisible(false);
            return;
        }
    }

    private static boolean canFlatten(RadComponent c) {
        if (!(c instanceof RadContainer)) {
            return false;
        }
        if (c.getParent() instanceof RadRootContainer) {
            return false;
        }
        RadContainer container = (RadContainer)c;
        if (container.getLayoutManager().isGrid() && container.getParent().getLayoutManager().isGrid()) {
            return true;
        }
        return container.getComponentCount() <= 1;
    }

    @Override
    @Nullable
    protected String getCommandName() {
        return UIDesignerBundle.message("command.flatten", new Object[0]);
    }
}

