/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.build.JvmSourceRoot;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.jps.build.JpsUtils;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinSourceFileCollector;
import org.jetbrains.kotlin.modules.KotlinModuleXmlBuilder;
import org.jetbrains.kotlin.modules.ModulesUtilKt;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.FunctionsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002J4\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n0\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\"\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilderModuleScriptGenerator;", "", "()V", "getRelatedProductionModule", "Lkotlin/Function1;", "Lorg/jetbrains/jps/model/module/JpsModule;", "getGetRelatedProductionModule$jps_plugin", "()Lkotlin/jvm/functions/Function1;", "findClassPathRoots", "", "Ljava/io/File;", "target", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "findSourceRoots", "", "Lorg/jetbrains/kotlin/build/JvmSourceRoot;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "generateModuleDescription", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "sourceFiles", "Lcom/intellij/util/containers/MultiMap;", "hasRemovedFiles", "", "getAdditionalOutputDirsWhereInternalsAreVisible", "getOutputDirSafe", "jps-plugin"})
public final class KotlinBuilderModuleScriptGenerator {
    @NotNull
    private static final Function1<JpsModule, JpsModule> getRelatedProductionModule;
    public static final KotlinBuilderModuleScriptGenerator INSTANCE;

    @NotNull
    public final Function1<JpsModule, JpsModule> getGetRelatedProductionModule$jps_plugin() {
        return getRelatedProductionModule;
    }

    @Nullable
    public final File generateModuleDescription(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull MultiMap<ModuleBuildTarget, File> sourceFiles, boolean hasRemovedFiles) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
        Intrinsics.checkParameterIsNotNull(sourceFiles, (String)"sourceFiles");
        KotlinModuleXmlBuilder builder = new KotlinModuleXmlBuilder();
        boolean noSources = true;
        HashSet<File> outputDirs = new HashSet<File>();
        Iterator iterator2 = chunk.getTargets().iterator();
        while (iterator2.hasNext()) {
            ModuleBuildTarget target;
            ModuleBuildTarget moduleBuildTarget = target = (ModuleBuildTarget)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"target");
            outputDirs.add(this.getOutputDirSafe(moduleBuildTarget));
        }
        ProjectBuilderLogger logger = context.getLoggingManager().getProjectBuilderLogger();
        Iterator iterator3 = chunk.getTargets().iterator();
        while (iterator3.hasNext()) {
            ModuleBuildTarget target;
            ModuleBuildTarget moduleBuildTarget = target = (ModuleBuildTarget)iterator3.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"target");
            File outputDir2 = this.getOutputDirSafe(moduleBuildTarget);
            ModuleBuildTarget moduleBuildTarget2 = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget2, (String)"target");
            List<File> friendDirs = this.getAdditionalOutputDirsWhereInternalsAreVisible(moduleBuildTarget2);
            ArrayList moduleSources = new ArrayList(IncrementalCompilation.isEnabled() ? sourceFiles.get((Object)target) : (Collection)KotlinSourceFileCollector.getAllKotlinSourceFiles(target));
            if (moduleSources.size() > 0 || hasRemovedFiles) {
                noSources = false;
                if (logger.isEnabled()) {
                    logger.logCompiledFiles((Collection)moduleSources, KotlinBuilder.KOTLIN_BUILDER_NAME, "Compiling files:");
                }
            }
            BuildTargetType targetType = target.getTargetType();
            boolean bl = targetType instanceof JavaModuleBuildTargetType;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            ModuleBuildTarget moduleBuildTarget3 = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget3, (String)"target");
            TargetId targetId = ModulesUtilKt.TargetId(moduleBuildTarget3);
            String string = targetId.getName();
            String string2 = outputDir2.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"outputDir.absolutePath");
            Iterable iterable = moduleSources;
            ModuleBuildTarget moduleBuildTarget4 = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget4, (String)"target");
            Iterable iterable2 = this.findSourceRoots(context, moduleBuildTarget4);
            ModuleBuildTarget moduleBuildTarget5 = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget5, (String)"target");
            BuildTargetType buildTargetType = targetType;
            if (buildTargetType == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.jps.builders.java.JavaModuleBuildTargetType");
            }
            builder.addModule(string, string2, iterable, iterable2, (Iterable<? extends File>)this.findClassPathRoots(moduleBuildTarget5), targetId.getType(), ((JavaModuleBuildTargetType)buildTargetType).isTests(), (Set<? extends File>)outputDirs, (Iterable<? extends File>)friendDirs);
        }
        if (noSources) {
            return null;
        }
        File scriptFile = File.createTempFile("kjps", StringUtil.sanitizeJavaIdentifier((String)chunk.getName()) + ".script.xml");
        FileUtil.writeToFile((File)scriptFile, (String)((Object)builder.asText()).toString());
        return scriptFile;
    }

    @NotNull
    public final File getOutputDirSafe(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        File file = target.getOutputDir();
        if (file == null) {
            throw (Throwable)new ProjectBuildException("No output directory found for " + target);
        }
        return file;
    }

    private final List<File> getAdditionalOutputDirsWhereInternalsAreVisible(ModuleBuildTarget target) {
        SmartList result;
        block1: {
            if (!target.isTests()) {
                return kotlin.collections.CollectionsKt.emptyList();
            }
            result = new SmartList();
            CollectionsKt.addIfNotNull((Collection)result, JpsJavaExtensionService.getInstance().getOutputDirectory(target.getModule(), false));
            JpsModule jpsModule = target.getModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"target.module");
            JpsModule jpsModule2 = (JpsModule)getRelatedProductionModule.invoke((Object)jpsModule);
            if (jpsModule2 == null) break block1;
            JpsModule jpsModule3 = jpsModule2;
            JpsModule it = jpsModule3;
            CollectionsKt.addIfNotNull((Collection)result, JpsJavaExtensionService.getInstance().getOutputDirectory(it, false));
        }
        return (List)result;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<File> findClassPathRoots(ModuleBuildTarget target) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = JpsUtils.getAllDependencies(target).classes().getRoots();
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String extension;
            File file = (File)element$iv$iv;
            if (!(file.exists() || Intrinsics.areEqual((Object)(extension = FilesKt.getExtension((File)file)), (Object)"class") || Intrinsics.areEqual((Object)extension, (Object)"jar"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<JvmSourceRoot> findSourceRoots(CompileContext context, ModuleBuildTarget target) {
        List roots = context.getProjectDescriptor().getBuildRootIndex().getTargetRoots((BuildTarget)target, context);
        ArrayList result = ContainerUtil.newArrayList();
        for (JavaSourceRootDescriptor root : roots) {
            File file;
            JvmSourceRoot jvmSourceRoot;
            File file2 = root.getRootFile();
            String prefix = root.getPackagePrefix();
            if (!file2.exists()) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
            CharSequence charSequence = prefix;
            JvmSourceRoot jvmSourceRoot2 = jvmSourceRoot;
            JvmSourceRoot jvmSourceRoot3 = jvmSourceRoot;
            ArrayList arrayList = result;
            boolean bl = charSequence.length() == 0;
            jvmSourceRoot2(file, bl ? (String)null : prefix);
            arrayList.add(jvmSourceRoot3);
        }
        List list = result;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"result");
        return list;
    }

    private KotlinBuilderModuleScriptGenerator() {
        Function1 function1;
        block4: {
            Method getProductionModuleMethod;
            Method getTestModulePropertiesMethod;
            Class<?> clazz;
            INSTANCE = this;
            KotlinBuilderModuleScriptGenerator kotlinBuilderModuleScriptGenerator = this;
            KotlinBuilderModuleScriptGenerator $receiver = kotlinBuilderModuleScriptGenerator;
            try {
                clazz = Class.forName("org.jetbrains.jps.model.module.JpsTestModuleProperties");
            }
            catch (ClassNotFoundException e) {
                function1 = FunctionsKt.alwaysNull();
                break block4;
            }
            Class<?> klass = clazz;
            try {
                Method method = JpsJavaExtensionService.class.getDeclaredMethod("getTestModuleProperties", JpsModule.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"JpsJavaExtensionService:\u2026\", JpsModule::class.java)");
                getTestModulePropertiesMethod = method;
                Method method2 = klass.getDeclaredMethod("getProductionModule", new Class[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"klass.getDeclaredMethod(\"getProductionModule\")");
                getProductionModuleMethod = method2;
            }
            catch (NoSuchMethodException e) {
                function1 = FunctionsKt.alwaysNull();
                break block4;
            }
            function1 = (Function1)new Function1<JpsModule, JpsModule>(getTestModulePropertiesMethod, getProductionModuleMethod){
                final /* synthetic */ Method $getTestModulePropertiesMethod;
                final /* synthetic */ Method $getProductionModuleMethod;

                @Nullable
                public final JpsModule invoke(@NotNull JpsModule module) {
                    JpsModule jpsModule;
                    Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
                    Object object = this.$getTestModulePropertiesMethod.invoke((Object)JpsJavaExtensionService.getInstance(), module);
                    if (object != null) {
                        Object object2 = object;
                        Object it = object2;
                        jpsModule = (JpsModule)this.$getProductionModuleMethod.invoke(it, new Object[0]);
                    } else {
                        jpsModule = null;
                    }
                    return jpsModule;
                }
                {
                    this.$getTestModulePropertiesMethod = method;
                    this.$getProductionModuleMethod = method2;
                    super(1);
                }
            };
        }
        getRelatedProductionModule = function1;
    }

    static {
        new KotlinBuilderModuleScriptGenerator();
    }
}

