/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;

class AndroidDbErrorReporter {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.database.AndroidDbErrorReporter");
    private volatile boolean myHasError;

    AndroidDbErrorReporter() {
    }

    public synchronized void reportError(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/android/database/AndroidDbErrorReporter", "reportError"));
        }
        this.myHasError = true;
    }

    public synchronized boolean hasError() {
        return this.myHasError;
    }

    public void reportError(@NotNull Exception exception) {
        if (exception == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exception", "org/jetbrains/android/database/AndroidDbErrorReporter", "reportError"));
        }
        String exceptionMessage = exception.getMessage();
        String suffix = exceptionMessage != null && exceptionMessage.length() > 0 ? ": " + exceptionMessage : "";
        this.reportError(exception.getClass().getSimpleName() + suffix);
        LOG.info((Throwable)exception);
    }
}

