/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jpdl.providers;

import com.intellij.jboss.jpdl.model.xml.ProcessDefinition;
import com.intellij.jboss.jpdl.utils.JpdlCommonUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiTarget;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProcessNamesReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jboss/jpdl/providers/ProcessNamesReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jboss/jpdl/providers/ProcessNamesReferenceProvider", "getReferencesByElement"));
        }
        if (element instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
            if (module != null && literalExpression.getValue() instanceof String) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new JpdlProcessPsiReference(literalExpression, module)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jpdl/providers/ProcessNamesReferenceProvider", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jpdl/providers/ProcessNamesReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static class JpdlProcessPsiReference
    extends PsiReferenceBase<PsiLiteralExpression> {
        private Module myModule;

        public JpdlProcessPsiReference(PsiLiteralExpression literalExpression, Module module) {
            super((PsiElement)literalExpression, false);
            this.myModule = module;
        }

        public boolean isSoft() {
            return false;
        }

        public PsiElement resolve() {
            String value = this.getValue();
            for (ProcessDefinition definition : JpdlCommonUtils.getProcessDefinitions(this.myModule)) {
                if (!value.equals(definition.getName().getStringValue())) continue;
                return PomService.convertToPsi((PsiTarget)DomTarget.getTarget((DomElement)definition));
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            List<String> names = JpdlCommonUtils.getProcessNames(this.myModule);
            Object[] objectArray = names.toArray(new Object[names.size()]);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jpdl/providers/ProcessNamesReferenceProvider$JpdlProcessPsiReference", "getVariants"));
            }
            return objectArray;
        }
    }
}

