/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs;

import com.intellij.util.containers.ContainerUtil;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.CheckinWorkItemAction;
import com.microsoft.tfs.core.clients.workitem.query.WorkItemLinkInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItem;
import org.jetbrains.tfsIntegration.ui.WorkItemsQueryResult;

public class WorkItemsCheckinParameters {
    @NotNull
    private List<WorkItem> myWorkItems;
    @NotNull
    private Map<WorkItem, CheckinWorkItemAction> myActions;
    @Nullable
    private List<WorkItemLinkInfo> myLinks;

    private WorkItemsCheckinParameters(@NotNull List<WorkItem> workItems, @NotNull Map<WorkItem, CheckinWorkItemAction> actions, @Nullable List<WorkItemLinkInfo> links) {
        if (workItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workItems", "org/jetbrains/tfsIntegration/core/tfs/WorkItemsCheckinParameters", "<init>"));
        }
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "org/jetbrains/tfsIntegration/core/tfs/WorkItemsCheckinParameters", "<init>"));
        }
        this.myWorkItems = workItems;
        this.myActions = actions;
        this.myLinks = links;
    }

    public WorkItemsCheckinParameters() {
        this(Collections.emptyList(), ContainerUtil.newHashMap(), null);
    }

    @Nullable
    public CheckinWorkItemAction getAction(@NotNull WorkItem workItem) {
        if (workItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workItem", "org/jetbrains/tfsIntegration/core/tfs/WorkItemsCheckinParameters", "getAction"));
        }
        return this.myActions.get(workItem);
    }

    public void setAction(@NotNull WorkItem workItem, @NotNull CheckinWorkItemAction action) {
        if (workItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workItem", "org/jetbrains/tfsIntegration/core/tfs/WorkItemsCheckinParameters", "setAction"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/tfsIntegration/core/tfs/WorkItemsCheckinParameters", "setAction"));
        }
        this.myActions.put(workItem, action);
    }

    public void removeAction(@NotNull WorkItem workItem) {
        if (workItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workItem", "org/jetbrains/tfsIntegration/core/tfs/WorkItemsCheckinParameters", "removeAction"));
        }
        this.myActions.remove(workItem);
    }

    @NotNull
    public List<WorkItem> getWorkItems() {
        List<WorkItem> list = Collections.unmodifiableList(this.myWorkItems);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/WorkItemsCheckinParameters", "getWorkItems"));
        }
        return list;
    }

    @Nullable
    public List<WorkItemLinkInfo> getLinks() {
        return this.myLinks != null ? Collections.unmodifiableList(this.myLinks) : null;
    }

    @NotNull
    public WorkItemsCheckinParameters createCopy() {
        WorkItemsCheckinParameters workItemsCheckinParameters = new WorkItemsCheckinParameters(ContainerUtil.newArrayList(this.myWorkItems), ContainerUtil.newHashMap(this.myActions), this.getLinks());
        if (workItemsCheckinParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/WorkItemsCheckinParameters", "createCopy"));
        }
        return workItemsCheckinParameters;
    }

    public void update(@NotNull WorkItemsQueryResult queryResult) {
        if (queryResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryResult", "org/jetbrains/tfsIntegration/core/tfs/WorkItemsCheckinParameters", "update"));
        }
        this.myWorkItems = queryResult.getWorkItems();
        this.myLinks = queryResult.getLinks();
        this.myActions.clear();
    }

    public void update(@NotNull WorkItemsCheckinParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/tfsIntegration/core/tfs/WorkItemsCheckinParameters", "update"));
        }
        this.myWorkItems = parameters.myWorkItems;
        this.myLinks = parameters.myLinks;
        this.myActions = parameters.myActions;
    }

    @NotNull
    public Map<WorkItem, CheckinWorkItemAction> getWorkItemsActions() {
        Map<WorkItem, CheckinWorkItemAction> map = Collections.unmodifiableMap(this.myActions);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/WorkItemsCheckinParameters", "getWorkItemsActions"));
        }
        return map;
    }
}

