/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.util.SystemProperties;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.config.TfsServerConnectionHelper;
import org.jetbrains.tfsIntegration.core.configuration.TFSConfigurationManager;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkingFolderInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkstationCacheReader;
import org.jetbrains.tfsIntegration.exceptions.DuplicateMappingException;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.exceptions.WorkspaceHasNoMappingException;
import org.jetbrains.tfsIntegration.xmlutil.XmlUtil;

public class Workstation {
    public static boolean PRESERVE_CONFIG_FILE = false;
    @NonNls
    private static final String CACHE_FILE_LINUX_MAC = "tfs-servers.xml";
    private static final Logger LOG = Logger.getInstance((String)Workstation.class.getName());
    private final List<ServerInfo> myServerInfos = Workstation.loadCache();
    @Nullable
    private Ref<FilePath> myDuplicateMappedPath;
    private static String ourComputerName;

    private static File getCacheFileWindows(String version) {
        String path = "Local Settings\\Application Data\\Microsoft\\Team Foundation\\" + version + "\\Cache\\VersionControl.config";
        return new File(SystemProperties.getUserHome(), path);
    }

    private Workstation() {
    }

    public static Workstation getInstance() {
        return WorkstationHolder.ourInstance;
    }

    public List<ServerInfo> getServers() {
        return Collections.unmodifiableList(this.myServerInfos);
    }

    @Nullable
    public ServerInfo getServer(URI uri) {
        for (ServerInfo server : this.getServers()) {
            if (!server.getUri().equals(uri)) continue;
            return server;
        }
        return null;
    }

    @Nullable
    public ServerInfo getServerByInstanceId(String instanceId) {
        for (ServerInfo server : this.getServers()) {
            if (!server.getGuid().equals(instanceId)) continue;
            return server;
        }
        return null;
    }

    private List<WorkspaceInfo> getAllWorkspacesForCurrentOwnerAndComputer(boolean showLoginIfNoCredentials) {
        ArrayList<WorkspaceInfo> result = new ArrayList<WorkspaceInfo>();
        for (ServerInfo server : this.getServers()) {
            if (showLoginIfNoCredentials && server.getQualifiedUsername() == null) {
                try {
                    TfsServerConnectionHelper.ensureAuthenticated(null, server.getUri(), false);
                }
                catch (TfsException e) {
                    continue;
                }
            }
            result.addAll(server.getWorkspacesForCurrentOwnerAndComputer());
        }
        return result;
    }

    private static List<ServerInfo> loadCache() {
        File cacheFile = Workstation.getCacheFile(true);
        if (cacheFile != null) {
            try {
                WorkstationCacheReader reader = new WorkstationCacheReader();
                XmlUtil.parseFile(cacheFile, reader);
                return reader.getServers();
            }
            catch (Exception e) {
                LOG.info("Cannot read workspace cache", (Throwable)e);
            }
        }
        return new ArrayList<ServerInfo>();
    }

    @Nullable
    private static File getCacheFile(boolean existingOnly) {
        File cacheFile;
        if (PRESERVE_CONFIG_FILE) {
            return null;
        }
        String[] versions = new String[]{"4.0", "3.0", "2.0", "1.0"};
        if (SystemInfo.isWindows) {
            int i = 0;
            while (!(cacheFile = Workstation.getCacheFileWindows(versions[i++])).exists() && i < versions.length) {
            }
        } else {
            cacheFile = new File(PathManager.getOptionsPath(), CACHE_FILE_LINUX_MAC);
        }
        return cacheFile.exists() || !existingOnly ? cacheFile : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update() {
        this.invalidateDuplicateMappedPath();
        File cacheFile = Workstation.getCacheFile(false);
        if (cacheFile != null) {
            if (!cacheFile.getParentFile().exists()) {
                cacheFile.getParentFile().mkdirs();
            }
            try {
                Document d = new Document();
                Element rootElement = new Element("VersionControlServer");
                d.setRootElement(rootElement);
                Element serversElement = new Element("Servers");
                rootElement.addContent(serversElement);
                for (ServerInfo serverInfo : this.getServers()) {
                    Element serverInfoElement = new Element("ServerInfo");
                    serversElement.addContent(serverInfoElement);
                    serverInfoElement.setAttribute("uri", serverInfo.getUri().toString());
                    serverInfoElement.setAttribute("repositoryGuid", serverInfo.getGuid());
                    for (WorkspaceInfo workspaceInfo : serverInfo.getWorkspaces()) {
                        Element workspaceInfoElement = new Element("WorkspaceInfo");
                        serverInfoElement.addContent(workspaceInfoElement);
                        workspaceInfoElement.setAttribute("computer", workspaceInfo.getComputer());
                        workspaceInfoElement.setAttribute("ownerName", workspaceInfo.getOwnerName());
                        workspaceInfoElement.setAttribute("LastSavedCheckinTimeStamp", ConverterUtil.convertToString((Calendar)workspaceInfo.getTimestamp()));
                        workspaceInfoElement.setAttribute("name", workspaceInfo.getName());
                        if (workspaceInfo.getComment() != null) {
                            workspaceInfoElement.setAttribute("comment", workspaceInfo.getComment());
                        }
                        Element mappedPathsElement = new Element("MappedPaths");
                        workspaceInfoElement.addContent(mappedPathsElement);
                        for (WorkingFolderInfo folderInfo : workspaceInfo.getWorkingFoldersCached()) {
                            Element e = new Element("MappedPath");
                            e.setAttribute("path", folderInfo.getLocalPath().getPath());
                            mappedPathsElement.addContent(e);
                        }
                    }
                }
                try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(cacheFile));){
                    XMLOutputter o = JDOMUtil.createOutputter((String)"\n");
                    o.setFormat(o.getFormat().setOmitDeclaration(true));
                    o.output(d, (OutputStream)stream);
                }
            }
            catch (IOException e) {
                LOG.info("Cannot update workspace cache", (Throwable)e);
            }
        }
    }

    public void addServer(ServerInfo serverInfo) {
        this.myServerInfos.add(serverInfo);
        this.update();
    }

    public void removeServer(ServerInfo serverInfo) {
        this.myServerInfos.remove(serverInfo);
        TFSConfigurationManager.getInstance().remove(serverInfo.getUri());
        this.update();
    }

    public static synchronized String getComputerName() {
        if (ourComputerName == null) {
            try {
                InetAddress address = InetAddress.getLocalHost();
                String hostName = address.getHostName();
                int i = hostName.indexOf(46);
                if (i != -1) {
                    hostName = hostName.substring(0, i);
                }
                ourComputerName = hostName;
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Cannot retrieve host name.");
            }
        }
        return ourComputerName;
    }

    public Collection<WorkspaceInfo> findWorkspacesCached(@NotNull FilePath localPath, boolean considerChildMappings) {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "findWorkspacesCached"));
        }
        ArrayList<WorkspaceInfo> result = new ArrayList<WorkspaceInfo>();
        for (WorkspaceInfo workspace : this.getAllWorkspacesForCurrentOwnerAndComputer(false)) {
            if (!workspace.hasMappingCached(localPath, considerChildMappings)) continue;
            result.add(workspace);
            if (considerChildMappings) continue;
            break;
        }
        return result;
    }

    public Collection<WorkspaceInfo> findWorkspaces(@NotNull FilePath localPath, boolean considerChildMappings, Object projectOrComponent) throws TfsException {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "findWorkspaces"));
        }
        this.checkDuplicateMappings();
        Collection<WorkspaceInfo> resultCached = this.findWorkspacesCached(localPath, considerChildMappings);
        if (!resultCached.isEmpty()) {
            for (WorkspaceInfo workspace : resultCached) {
                if (workspace.hasMapping(localPath, considerChildMappings, projectOrComponent)) continue;
                throw new WorkspaceHasNoMappingException(workspace);
            }
            return resultCached;
        }
        ArrayList<WorkspaceInfo> result = new ArrayList<WorkspaceInfo>();
        ArrayList<ServerInfo> serversToSkip = new ArrayList<ServerInfo>();
        for (WorkspaceInfo workspace : this.getAllWorkspacesForCurrentOwnerAndComputer(true)) {
            if (serversToSkip.contains(workspace.getServer())) continue;
            try {
                if (!workspace.hasMapping(localPath, considerChildMappings, projectOrComponent)) continue;
                result.add(workspace);
                if (considerChildMappings) continue;
                return result;
            }
            catch (TfsException e) {
                serversToSkip.add(workspace.getServer());
            }
        }
        return result;
    }

    public void checkDuplicateMappings() throws DuplicateMappingException {
        if (this.myDuplicateMappedPath == null) {
            this.myDuplicateMappedPath = Ref.create((Object)this.findDuplicateMappedPath());
        }
        if (!this.myDuplicateMappedPath.isNull()) {
            throw new DuplicateMappingException((FilePath)this.myDuplicateMappedPath.get());
        }
    }

    private void invalidateDuplicateMappedPath() {
        this.myDuplicateMappedPath = null;
    }

    @Nullable
    private FilePath findDuplicateMappedPath() {
        ArrayList otherServersPaths = new ArrayList();
        for (ServerInfo server : this.getServers()) {
            ArrayList<FilePath> currentServerPaths = new ArrayList<FilePath>();
            for (WorkspaceInfo workspace : server.getWorkspacesForCurrentOwnerAndComputer()) {
                for (WorkingFolderInfo workingFolder : workspace.getWorkingFoldersCached()) {
                    FilePath currentServerPath = workingFolder.getLocalPath();
                    for (FilePath otherServerPath : otherServersPaths) {
                        if (currentServerPath.isUnder(otherServerPath, false)) {
                            return currentServerPath;
                        }
                        if (!otherServerPath.isUnder(currentServerPath, false)) continue;
                        return otherServerPath;
                    }
                    currentServerPaths.add(currentServerPath);
                }
            }
            otherServersPaths.addAll(currentServerPaths);
        }
        return null;
    }

    private static class WorkstationHolder {
        private static final Workstation ourInstance = new Workstation();

        private WorkstationHolder() {
        }
    }
}

