/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui.servertree;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.EventListener;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.ui.servertree.TfsTreeBuilder;
import org.jetbrains.tfsIntegration.ui.servertree.TfsTreeNode;

public class TfsTreeForm
implements Disposable,
DataProvider {
    private boolean myCanCreateVirtualFolders;
    public static final DataKey<TfsTreeForm> KEY = DataKey.create((String)"TfsTreeForm");
    public static final String POPUP_ACTION_GROUP = "TfsTreePopupMenu";
    public static final Icon EMPTY_ICON = new EmptyIcon(0, UIUtil.getBalloonWarningIcon().getIconHeight());
    private JComponent myContentPane;
    private Tree myTree;
    private JTextField myPathField;
    private JLabel myMessageLabel;
    private JPanel myMessagePanel;
    private TfsTreeBuilder myTreeBuider;
    private EventDispatcher<SelectionListener> myEventDispatcher;
    private SelectedItem mySelectedItem;

    public TfsTreeForm() {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(SelectionListener.class);
        DataManager.registerDataProvider((JComponent)this.myTree, (DataProvider)this);
        new TreeSpeedSearch((JTree)this.myTree);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TfsTreeForm.this.mySelectedItem = TfsTreeForm.this.doGetSelectedItem();
                TfsTreeForm.this.myPathField.setText(TfsTreeForm.this.mySelectedItem != null ? ((TfsTreeForm)TfsTreeForm.this).mySelectedItem.path : null);
                ((SelectionListener)TfsTreeForm.this.myEventDispatcher.getMulticaster()).selectionChanged();
            }
        });
        PopupHandler.installPopupHandler((JComponent)this.myTree, (String)POPUP_ACTION_GROUP, (String)"RemoteHostDialogPopup");
        this.setMessage(null, false);
    }

    @Nullable
    public SelectedItem getSelectedItem() {
        return this.mySelectedItem;
    }

    @Nullable
    public String getSelectedPath() {
        return this.mySelectedItem != null ? this.mySelectedItem.path : null;
    }

    @Nullable
    private SelectedItem doGetSelectedItem() {
        Set selection = this.myTreeBuider.getSelectedElements();
        if (selection.isEmpty()) {
            return null;
        }
        Object o = selection.iterator().next();
        return o instanceof TfsTreeNode ? new SelectedItem((TfsTreeNode)((Object)o)) : null;
    }

    public void initialize(@NotNull ServerInfo server, @Nullable String initialSelection, boolean foldersOnly, boolean canCreateVirtualFolders, @Nullable Condition<String> pathFilter) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "org/jetbrains/tfsIntegration/ui/servertree/TfsTreeForm", "initialize"));
        }
        this.myCanCreateVirtualFolders = canCreateVirtualFolders;
        TfsTreeNode root = new TfsTreeNode(this.myTree, server, foldersOnly, pathFilter);
        this.myTreeBuider = TfsTreeBuilder.createInstance(root, (JTree)this.myTree);
        Disposer.register((Disposable)this, (Disposable)this.myTreeBuider);
        TfsTreeNode selection = root.createForSelection(initialSelection);
        if (selection != null) {
            this.myTreeBuider.select((Object)selection);
        }
    }

    public void addListener(SelectionListener selectionListener) {
        this.myEventDispatcher.addListener((EventListener)selectionListener, (Disposable)this);
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    public void dispose() {
    }

    public Object getData(@NonNls String dataId) {
        if (KEY.is(dataId)) {
            return this;
        }
        return null;
    }

    public void createVirtualFolder(String folderName) {
        Set selection = this.myTreeBuider.getSelectedElements();
        if (selection.isEmpty()) {
            return;
        }
        Object o = selection.iterator().next();
        if (!(o instanceof TfsTreeNode)) {
            return;
        }
        TfsTreeNode treeNode = (TfsTreeNode)((Object)o);
        final TfsTreeNode child = treeNode.createVirtualSubfolder(folderName);
        this.myTreeBuider.queueUpdateFrom((Object)treeNode, true).doWhenDone(new Runnable(){

            @Override
            public void run() {
                TfsTreeForm.this.myTreeBuider.select((Object)child);
            }
        });
    }

    public boolean canCreateVirtualFolders() {
        return this.myCanCreateVirtualFolders;
    }

    public void setMessage(String text, boolean error) {
        if (text != null) {
            this.myMessagePanel.setVisible(true);
            this.myMessageLabel.setText(text);
            this.myMessageLabel.setIcon(error ? UIUtil.getBalloonWarningIcon() : EMPTY_ICON);
        } else {
            this.myMessagePanel.setVisible(false);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        JTextField jTextField;
        Tree tree;
        JPanel jPanel2 = new JPanel();
        this.myContentPane = jPanel2;
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myTree = tree = new Tree();
        jBScrollPane.setViewportView((Component)tree);
        this.myPathField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jPanel2.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myMessagePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 2, null, new Dimension(11, 10), null));
        this.myMessageLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    public static class SelectedItem {
        public final String path;
        public final boolean isDirectory;

        public SelectedItem(String path, boolean idDirectory) {
            this.path = path;
            this.isDirectory = idDirectory;
        }

        public SelectedItem(TfsTreeNode treeNode) {
            this(treeNode.getPath(), treeNode.isDirectory());
        }
    }

    public static interface SelectionListener
    extends EventListener {
        public void selectionChanged();
    }
}

