/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.dataSource;

import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class WebLogicDataSourceDetector
extends DataSourceDetector {
    private static final String WEBLOGIC_RESOURCE_TYPE = "weblogic.resource";
    private static final String JDBC_DATA_SOURCE_TAG = "jdbc-data-source";
    private static final String JDBC_DRIVER_PARAMS_TAG = "jdbc-driver-params";
    private static final String PROPERTIES_TAG = "properties";
    private static final String DRIVER_NAME_TAG = "driver-name";
    private static final String NAME_TAG = "name";
    private static final String PROPERTY_TAG = "property";
    private static final String VALUE_TAG = "value";
    private static final String URL_TAG = "url";
    private static final String USER_TAG = "user";
    private static final String PASSWORD_TAG = "password";

    public void collectDataSources(@NotNull Project project, final @NotNull DataSourceDetector.Builder builder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/weblogic/dataSource/WebLogicDataSourceDetector", "collectDataSources"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/javaee/weblogic/dataSource/WebLogicDataSourceDetector", "collectDataSources"));
        }
        if (DumbService.isDumb((Project)project)) {
            return;
        }
        PsiSearchHelper.SERVICE.getInstance((Project)project).processElementsWithWord(new TextOccurenceProcessor(){

            public boolean execute(@NotNull PsiElement element, int offsetInElement) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javaee/weblogic/dataSource/WebLogicDataSourceDetector$1", "execute"));
                }
                XmlTag sourceTag = (XmlTag)ObjectUtils.tryCast((Object)element, XmlTag.class);
                if (sourceTag == null || !WebLogicDataSourceDetector.JDBC_DATA_SOURCE_TAG.equals(sourceTag.getLocalName())) {
                    return true;
                }
                XmlTag driverParamsTag = sourceTag.findFirstSubTag(WebLogicDataSourceDetector.JDBC_DRIVER_PARAMS_TAG);
                if (driverParamsTag == null) {
                    return true;
                }
                XmlTag propertiesTag = driverParamsTag.findFirstSubTag(WebLogicDataSourceDetector.PROPERTIES_TAG);
                if (propertiesTag == null) {
                    return true;
                }
                String username = "";
                String password = "";
                for (XmlTag property : propertiesTag.findSubTags(WebLogicDataSourceDetector.PROPERTY_TAG)) {
                    String propertyName = property.getSubTagText(WebLogicDataSourceDetector.NAME_TAG);
                    if (WebLogicDataSourceDetector.USER_TAG.equals(propertyName)) {
                        username = property.getSubTagText(WebLogicDataSourceDetector.VALUE_TAG);
                        continue;
                    }
                    if (!WebLogicDataSourceDetector.PASSWORD_TAG.equals(propertyName)) continue;
                    password = property.getSubTagText(WebLogicDataSourceDetector.VALUE_TAG);
                }
                builder.withName(sourceTag.getSubTagText(WebLogicDataSourceDetector.NAME_TAG)).withDriverClass(driverParamsTag.getSubTagText(WebLogicDataSourceDetector.DRIVER_NAME_TAG)).withUrl(driverParamsTag.getSubTagText(WebLogicDataSourceDetector.URL_TAG)).withUser(username).withPassword(password).commit(WebLogicDataSourceDetector.WEBLOGIC_RESOURCE_TYPE, (Object)sourceTag);
                return true;
            }
        }, (SearchScope)GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)GlobalSearchScope.allScope((Project)project), (FileType[])new FileType[]{StdFileTypes.XML}), JDBC_DATA_SOURCE_TAG, (short)8, true);
    }
}

