/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.artifacts;

import com.intellij.dmserver.artifacts.DMArtifactTypeBase;
import com.intellij.dmserver.artifacts.DMConfigPackagingElement;
import com.intellij.dmserver.artifacts.DMConfigPackagingElementType;
import com.intellij.dmserver.facet.DMConfigFacet;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.impl.elements.ArtifactRootElementImpl;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DMConfigArtifactType
extends DMArtifactTypeBase<DMConfigPackagingElement, DMConfigPackagingElementType, DMConfigFacet> {
    @NonNls
    private static final String ARTIFACT_ID_DM_CONFIG = "dm.config";
    @NonNls
    public static final String PROPERTIES_EXTENSION = "properties";
    public static final String DOT_PROPERTIES_EXTENSION = ".properties";
    private static final VirtualFileFilter PROPERTIES_FILE_FILTER = new DMArtifactTypeBase.ByExtensionFilter("properties");

    public static DMConfigArtifactType getInstance() {
        return (DMConfigArtifactType)((Object)ContainerUtil.findInstance((Object[])DMConfigArtifactType.getAllTypes(), DMConfigArtifactType.class));
    }

    public DMConfigArtifactType() {
        super(ARTIFACT_ID_DM_CONFIG, DmServerBundle.message("DMConfigArtifactType.presentable.name", new Object[0]));
    }

    @Override
    public DMConfigPackagingElementType getModulePackagingElementType() {
        return DMConfigPackagingElementType.getInstance();
    }

    @NotNull
    public CompositePackagingElement<?> createRootElement(@NotNull String artifactName) {
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "com/intellij/dmserver/artifacts/DMConfigArtifactType", "createRootElement"));
        }
        ArtifactRootElementImpl artifactRootElementImpl = new ArtifactRootElementImpl();
        if (artifactRootElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/artifacts/DMConfigArtifactType", "createRootElement"));
        }
        return artifactRootElementImpl;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.FileTypes.Text;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/artifacts/DMConfigArtifactType", "getIcon"));
        }
        return icon;
    }

    @Override
    public Artifact createArtifactFor(@NotNull Module module, @NotNull DMConfigFacet facet) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/DMConfigArtifactType", "createArtifactFor"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/dmserver/artifacts/DMConfigArtifactType", "createArtifactFor"));
        }
        Project project = module.getProject();
        ArtifactManager manager = ArtifactManager.getInstance((Project)project);
        Artifact artifact = manager.addArtifact(DmServerBundle.message("DMConfigArtifactType.artifact.name", module.getName()), (ArtifactType)DMConfigArtifactType.getInstance(), null);
        this.addOrFindModuleReference(artifact.getRootElement(), module);
        return artifact;
    }

    @Override
    public void synchronizeArtifact(@NotNull Artifact artifact, @NotNull Module module, @NotNull DMConfigFacet facet) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/dmserver/artifacts/DMConfigArtifactType", "synchronizeArtifact"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/DMConfigArtifactType", "synchronizeArtifact"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/dmserver/artifacts/DMConfigArtifactType", "synchronizeArtifact"));
        }
    }

    @Override
    @NotNull
    protected VirtualFileFilter getMainFileToDeployFilter(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/dmserver/artifacts/DMConfigArtifactType", "getMainFileToDeployFilter"));
        }
        VirtualFileFilter virtualFileFilter = PROPERTIES_FILE_FILTER;
        if (virtualFileFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/artifacts/DMConfigArtifactType", "getMainFileToDeployFilter"));
        }
        return virtualFileFilter;
    }
}

