/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.artifacts;

import com.intellij.dmserver.artifacts.DMArtifactTypeBase;
import com.intellij.dmserver.artifacts.DMCompositeArtifactTypeBase;
import com.intellij.dmserver.artifacts.DMCompositePackagingElement;
import com.intellij.dmserver.artifacts.plan.DMArtifactElementType;
import com.intellij.dmserver.artifacts.plan.PlanArtifactElement;
import com.intellij.dmserver.artifacts.plan.PlanFileManager;
import com.intellij.dmserver.artifacts.plan.PlanRootElement;
import com.intellij.dmserver.facet.DMCompositeFacet;
import com.intellij.dmserver.facet.DMCompositeFacetConfiguration;
import com.intellij.dmserver.facet.DMUnitDescriptor;
import com.intellij.dmserver.facet.DMUnitDescriptorProvider;
import com.intellij.dmserver.facet.DMUnitType;
import com.intellij.dmserver.facet.NestedUnitIdentity;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.impl.elements.ArtifactRootElementImpl;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.containers.ContainerUtil;
import icons.DmServerSupportIcons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.VersionRange;

public class DMPlanArtifactType
extends DMCompositeArtifactTypeBase {
    private static final Logger LOG = Logger.getInstance((String)("#" + DMPlanArtifactType.class.getName()));
    @NonNls
    private static final String ARTIFACT_ID_DM_PLAN = "dm.plan";
    @NonNls
    private static final String PLAN_EXTENSION = "plan";
    @NonNls
    public static final String PLAN_EXTENSION_WITH_DOT = ".plan";
    private static final VirtualFileFilter NESTED_FILE_FILTER = new DMArtifactTypeBase.ByExtensionFilter("jar", "war", "par", "plan", "properties");
    private static final Map<DMUnitType, DMArtifactElementType> ourUnit2ArtifactElementType = new HashMap<DMUnitType, DMArtifactElementType>();

    public static DMArtifactElementType getElementType4UnitType(DMUnitType unitType) {
        return ourUnit2ArtifactElementType.get((Object)unitType);
    }

    public static DMPlanArtifactType getInstance() {
        return (DMPlanArtifactType)((Object)ContainerUtil.findInstance((Object[])DMPlanArtifactType.getAllTypes(), DMPlanArtifactType.class));
    }

    public DMPlanArtifactType() {
        super(ARTIFACT_ID_DM_PLAN, DmServerBundle.message("DMPlanArtifactType.presentable.name", new Object[0]), true);
    }

    @Override
    @NotNull
    protected VirtualFileFilter getMainFileToDeployFilter(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/dmserver/artifacts/DMPlanArtifactType", "getMainFileToDeployFilter"));
        }
        DMCompositePackagingElement moduleReference = this.findModuleReference(artifact);
        Module module = moduleReference.findModule();
        DMCompositeFacet facet = DMCompositeFacet.getInstance(module);
        final String planFileName = DMPlanArtifactType.getPlanFileName(facet);
        VirtualFileFilter virtualFileFilter = new VirtualFileFilter(){

            public boolean accept(VirtualFile file) {
                return planFileName.equals(file.getName());
            }
        };
        if (virtualFileFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/artifacts/DMPlanArtifactType", "getMainFileToDeployFilter"));
        }
        return virtualFileFilter;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = DmServerSupportIcons.DM;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/artifacts/DMPlanArtifactType", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public CompositePackagingElement<?> createRootElement(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/dmserver/artifacts/DMPlanArtifactType", "createRootElement"));
        }
        ArtifactRootElementImpl artifactRootElementImpl = new ArtifactRootElementImpl();
        if (artifactRootElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/artifacts/DMPlanArtifactType", "createRootElement"));
        }
        return artifactRootElementImpl;
    }

    @Override
    public Artifact createArtifactFor(@NotNull Module module, @NotNull DMCompositeFacet facet) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/DMPlanArtifactType", "createArtifactFor"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/dmserver/artifacts/DMPlanArtifactType", "createArtifactFor"));
        }
        Project project = module.getProject();
        ArtifactManager manager = ArtifactManager.getInstance((Project)project);
        Artifact artifact = manager.addArtifact("dm Plan for '" + module.getName() + "'", (ArtifactType)this, null);
        this.addOrFindModuleReference(artifact.getRootElement(), module);
        this.addNestedBundlesReferences(module, artifact.getRootElement(), facet);
        return artifact;
    }

    @Override
    public void synchronizeArtifact(@NotNull Artifact artifact, @NotNull Module module, @NotNull DMCompositeFacet facet) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/dmserver/artifacts/DMPlanArtifactType", "synchronizeArtifact"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/DMPlanArtifactType", "synchronizeArtifact"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/dmserver/artifacts/DMPlanArtifactType", "synchronizeArtifact"));
        }
        if (!this.isCompatibleArtifact(artifact)) {
            throw new IllegalArgumentException("I am not compatible with artifact: " + artifact);
        }
        this.synchronizeNestedBundlesReferences(module, artifact.getRootElement(), facet);
    }

    protected DMCompositePackagingElement findModuleReference(Artifact artifact) {
        for (PackagingElement element : artifact.getRootElement().getChildren()) {
            if (!(element instanceof DMCompositePackagingElement)) continue;
            return (DMCompositePackagingElement)element;
        }
        return null;
    }

    public final List<VirtualFile> findSecondaryFilesToDeploy(Artifact artifact) {
        VirtualFileFilter mainFileToDeployFilter = this.getMainFileToDeployFilter(artifact);
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        VirtualFile output = LocalFileSystem.getInstance().findFileByPath(artifact.getOutputPath());
        for (VirtualFile nextToDeploy : output.getChildren()) {
            if (!NESTED_FILE_FILTER.accept(nextToDeploy) || mainFileToDeployFilter.accept(nextToDeploy)) continue;
            result.add(nextToDeploy);
        }
        return result;
    }

    @Override
    public void updateModuleSupport(final @NotNull Module module, final @NotNull DMCompositeFacet facet, final @NotNull ModuleRootModel rootModel, final @NotNull DMCompositeFacetConfiguration facetConfiguration) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/DMPlanArtifactType", "updateModuleSupport"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/dmserver/artifacts/DMPlanArtifactType", "updateModuleSupport"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/dmserver/artifacts/DMPlanArtifactType", "updateModuleSupport"));
        }
        if (facetConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetConfiguration", "com/intellij/dmserver/artifacts/DMPlanArtifactType", "updateModuleSupport"));
        }
        Runnable saveRunnable = () -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/DMPlanArtifactType", "lambda$updateModuleSupport$0"));
            }
            if (facet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/dmserver/artifacts/DMPlanArtifactType", "lambda$updateModuleSupport$0"));
            }
            if (rootModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/dmserver/artifacts/DMPlanArtifactType", "lambda$updateModuleSupport$0"));
            }
            if (facetConfiguration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetConfiguration", "com/intellij/dmserver/artifacts/DMPlanArtifactType", "lambda$updateModuleSupport$0"));
            }
            new WriteAction(){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/dmserver/artifacts/DMPlanArtifactType$2", "run"));
                    }
                    DMPlanArtifactType.this.doUpdateModuleSupport(module, facet, rootModel, facetConfiguration);
                }
            }.execute();
        };
        StartupManager.getInstance((Project)module.getProject()).runWhenProjectIsInitialized(saveRunnable);
    }

    private void doUpdateModuleSupport(@NotNull Module module, @NotNull DMCompositeFacet facet, @NotNull ModuleRootModel rootModel, @NotNull DMCompositeFacetConfiguration facetConfiguration) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/DMPlanArtifactType", "doUpdateModuleSupport"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/dmserver/artifacts/DMPlanArtifactType", "doUpdateModuleSupport"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/dmserver/artifacts/DMPlanArtifactType", "doUpdateModuleSupport"));
        }
        if (facetConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetConfiguration", "com/intellij/dmserver/artifacts/DMPlanArtifactType", "doUpdateModuleSupport"));
        }
        PlanFileManager planManager = facet.getPlanFileManager();
        PlanFileManager.PlanFileCreator planCreator = planManager.createPlan(rootModel);
        PlanRootElement rootElement = planCreator.getRootElement();
        if (!LOG.assertTrue(rootElement != null)) {
            return;
        }
        rootElement.getName().setValue((Object)facetConfiguration.getName(module));
        rootElement.getVersion().setValue((Object)facetConfiguration.getVersion());
        rootElement.getScoped().setValue((Object)facetConfiguration.getScoped());
        rootElement.getAtomic().setValue((Object)facetConfiguration.getAtomic());
        ArrayList<NestedUnitIdentity> newUnitIdentities = new ArrayList<NestedUnitIdentity>();
        ArrayList<DMUnitDescriptor> newUnitDescriptors = new ArrayList<DMUnitDescriptor>();
        for (NestedUnitIdentity unitIdentity : facetConfiguration.getNestedBundles()) {
            DMUnitDescriptor unitDescriptor;
            Module artifactModule = unitIdentity.getModule();
            if (artifactModule == null || (unitDescriptor = (DMUnitDescriptor)DMUnitDescriptorProvider.getInstance().processModule(artifactModule)) == null) continue;
            newUnitIdentities.add(unitIdentity);
            newUnitDescriptors.add(unitDescriptor);
        }
        Iterator itNewUnitDescriptor = newUnitDescriptors.iterator();
        DMUnitDescriptor nextNewUnitDescriptor = itNewUnitDescriptor.hasNext() ? (DMUnitDescriptor)itNewUnitDescriptor.next() : null;
        HashMap<String, Object> name2newElements = new HashMap<String, Object>();
        ArrayList<PlanArtifactElement> elements2undefine = new ArrayList<PlanArtifactElement>();
        List<PlanArtifactElement> oldArtifactElements = rootElement.getArtifacts();
        for (PlanArtifactElement oldArtifactElement : oldArtifactElements.toArray(new PlanArtifactElement[oldArtifactElements.size()])) {
            if (nextNewUnitDescriptor != null) {
                String oldArtifactElementName = (String)oldArtifactElement.getName().getValue();
                name2newElements.put(oldArtifactElementName, oldArtifactElement);
                if (nextNewUnitDescriptor.getSymbolicName().equals(oldArtifactElementName)) {
                    nextNewUnitDescriptor = itNewUnitDescriptor.hasNext() ? (DMUnitDescriptor)itNewUnitDescriptor.next() : null;
                    continue;
                }
                elements2undefine.add(oldArtifactElement);
                continue;
            }
            elements2undefine.add(oldArtifactElement);
        }
        while (nextNewUnitDescriptor != null) {
            PlanArtifactElement newArtifactElement = rootElement.addArtifact();
            String newElementName = nextNewUnitDescriptor.getSymbolicName();
            PlanArtifactElement movedArtifactElement = (PlanArtifactElement)name2newElements.get(newElementName);
            if (movedArtifactElement != null) {
                XmlElement newXmlElement = newArtifactElement.getXmlElement();
                XmlElement movedXmlElement = movedArtifactElement.getXmlElement();
                if (LOG.assertTrue(newXmlElement != null) && LOG.assertTrue(movedXmlElement != null)) {
                    newXmlElement.replace(movedXmlElement.copy());
                }
            }
            name2newElements.put(newElementName, newArtifactElement);
            nextNewUnitDescriptor = itNewUnitDescriptor.hasNext() ? (DMUnitDescriptor)itNewUnitDescriptor.next() : null;
        }
        for (PlanArtifactElement element2undefine : elements2undefine) {
            element2undefine.undefine();
        }
        itNewUnitDescriptor = newUnitDescriptors.iterator();
        Iterator itNewUnitIdentity = newUnitIdentities.iterator();
        for (PlanArtifactElement newArtifactElement : rootElement.getArtifacts()) {
            DMUnitDescriptor newUnitDescriptor = (DMUnitDescriptor)itNewUnitDescriptor.next();
            NestedUnitIdentity newNestedUnitIdentity = (NestedUnitIdentity)itNewUnitIdentity.next();
            newArtifactElement.getType().setValue((Object)DMPlanArtifactType.getElementType4UnitType(newUnitDescriptor.getType()));
            newArtifactElement.getName().setValue((Object)newUnitDescriptor.getSymbolicName());
            newArtifactElement.getVersion().setValue((Object)new VersionRange(newNestedUnitIdentity.getVersionRange()));
        }
        planCreator.save();
    }

    private static String getPlanFileName(DMCompositeFacet facet) {
        String planName = facet.getConfigurationImpl().getName(facet.getModule());
        return planName.endsWith(PLAN_EXTENSION_WITH_DOT) ? planName : planName + PLAN_EXTENSION_WITH_DOT;
    }

    static {
        ourUnit2ArtifactElementType.put(DMUnitType.BUNDLE, DMArtifactElementType.TYPE_BUNDLE);
        ourUnit2ArtifactElementType.put(DMUnitType.PAR, DMArtifactElementType.TYPE_PAR);
        ourUnit2ArtifactElementType.put(DMUnitType.PLAN, DMArtifactElementType.TYPE_PLAN);
        ourUnit2ArtifactElementType.put(DMUnitType.CONFIG, DMArtifactElementType.TYPE_CONFIG);
    }
}

