/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.maven;

import com.intellij.appengine.facet.AppEngineFacet;
import com.intellij.appengine.facet.AppEngineFacetConfiguration;
import com.intellij.appengine.facet.AppEngineFacetType;
import com.intellij.appengine.facet.AppEngineWebIntegration;
import com.intellij.appengine.sdk.impl.AppEngineSdkUtil;
import com.intellij.facet.FacetType;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.FacetImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.ResolveContext;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;

public class AppEngineFacetImporter
extends FacetImporter<AppEngineFacet, AppEngineFacetConfiguration, AppEngineFacetType> {
    public AppEngineFacetImporter() {
        super("com.google.appengine", "appengine-maven-plugin", FacetType.findInstance(AppEngineFacetType.class));
    }

    public void resolve(Project project, MavenProject mavenProject, NativeMavenProjectHolder nativeMavenProject, MavenEmbedderWrapper embedder, ResolveContext context) throws MavenProcessCanceledException {
        String version = this.getVersion(mavenProject);
        if (version != null) {
            List repos = mavenProject.getRemoteRepositories();
            MavenArtifactInfo artifactInfo = new MavenArtifactInfo("com.google.appengine", "appengine-java-sdk", version, "zip", null);
            MavenArtifact artifact = embedder.resolve(artifactInfo, repos);
            File file = artifact.getFile();
            File unpackedSdkPath = new File(file.getParentFile(), "appengine-java-sdk");
            if (file.exists() && !AppEngineSdkUtil.checkPath(FileUtil.toSystemIndependentName((String)unpackedSdkPath.getAbsolutePath())).isOk()) {
                try {
                    ZipUtil.extract((File)file, (File)unpackedSdkPath, null, (boolean)false);
                }
                catch (IOException e) {
                    MavenLog.LOG.warn("cannot unpack AppEngine SDK", (Throwable)e);
                }
            }
        }
    }

    @Nullable
    private String getVersion(MavenProject project) {
        for (MavenArtifact artifact : project.findDependencies("com.google.appengine", "appengine-api-1.0-sdk")) {
            String artifactVersion = artifact.getVersion();
            if (artifactVersion == null) continue;
            return artifactVersion;
        }
        MavenPlugin plugin = project.findPlugin(this.myPluginGroupID, this.myPluginArtifactID);
        return plugin != null ? plugin.getVersion() : null;
    }

    protected void setupFacet(AppEngineFacet f, MavenProject mavenProject) {
    }

    protected void reimportFacet(IdeModifiableModelsProvider modelsProvider, Module module, MavenRootModelAdapter rootModel, AppEngineFacet facet, MavenProjectsTree mavenTree, MavenProject mavenProject, MavenProjectChanges changes, Map<MavenProject, String> mavenProjectToModuleName, List<MavenProjectsProcessorTask> postTasks) {
        String version = this.getVersion(mavenProject);
        if (version != null) {
            String relativePath = "/com/google/appengine/appengine-java-sdk/" + version + "/appengine-java-sdk/appengine-java-sdk-" + version;
            ((AppEngineFacetConfiguration)facet.getConfiguration()).setSdkHomePath(FileUtil.toSystemIndependentName((String)mavenProject.getLocalRepository().getPath()) + relativePath);
            AppEngineWebIntegration.getInstance().setupDevServer(facet.getSdk());
            String artifactName = module.getName() + ":war exploded";
            Artifact webArtifact = modelsProvider.getModifiableArtifactModel().findArtifact(artifactName);
            AppEngineWebIntegration.getInstance().setupRunConfiguration(facet.getSdk(), webArtifact, module.getProject());
        }
    }
}

