/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.sdk.impl;

import com.intellij.appengine.sdk.AppEngineSdk;
import com.intellij.appengine.sdk.impl.AppEngineSdkUtil;
import com.intellij.appengine.util.AppEngineUtil;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineSdkImpl
implements AppEngineSdk {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.appengine.sdk.impl.AppEngineSdkImpl");
    private Map<String, Set<String>> myClassesWhiteList;
    private Map<String, Set<String>> myMethodsBlackList;
    private final String myHomePath;

    public AppEngineSdkImpl(String homePath) {
        this.myHomePath = homePath;
    }

    @Override
    @NotNull
    public File getAppCfgFile() {
        String extension = SystemInfo.isWindows ? "cmd" : "sh";
        File file = new File(this.myHomePath, "bin/appcfg." + extension);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/sdk/impl/AppEngineSdkImpl", "getAppCfgFile"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getWebSchemeFile() {
        File file = new File(this.myHomePath, "docs/appengine-web.xsd");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/sdk/impl/AppEngineSdkImpl", "getWebSchemeFile"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getApplicationSchemeFile() {
        File file = new File(this.myHomePath, "docs/appengine-application.xsd");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/sdk/impl/AppEngineSdkImpl", "getApplicationSchemeFile"));
        }
        return file;
    }

    @Override
    @NotNull
    public File getToolsApiJarFile() {
        File file = new File(this.myHomePath, "/lib/appengine-tools-api.jar");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/sdk/impl/AppEngineSdkImpl", "getToolsApiJarFile"));
        }
        return file;
    }

    @Override
    @NotNull
    public File[] getLibraries() {
        File[] fileArray = AppEngineSdkImpl.getJarsFromDirectory(new File(this.myHomePath, "lib/shared"));
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/sdk/impl/AppEngineSdkImpl", "getLibraries"));
        }
        return fileArray;
    }

    @Override
    @NotNull
    public File[] getJspLibraries() {
        File[] fileArray = AppEngineSdkImpl.getJarsFromDirectory(new File(this.myHomePath, "lib/shared/jsp"));
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/sdk/impl/AppEngineSdkImpl", "getJspLibraries"));
        }
        return fileArray;
    }

    @Override
    public void patchJavaParametersForDevServer(@NotNull ParametersList vmParameters) {
        String patchPath;
        if (vmParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmParameters", "com/intellij/appengine/sdk/impl/AppEngineSdkImpl", "patchJavaParametersForDevServer"));
        }
        String agentPath = this.myHomePath + "/lib/agent/appengine-agent.jar";
        if (new File(FileUtil.toSystemDependentName((String)agentPath)).exists()) {
            vmParameters.add("-javaagent:" + agentPath);
        }
        if (new File(FileUtil.toSystemDependentName((String)(patchPath = this.myHomePath + "/lib/override/appengine-dev-jdk-overrides.jar"))).exists()) {
            vmParameters.add("-Xbootclasspath/p:" + patchPath);
        }
    }

    private static File[] getJarsFromDirectory(File libFolder) {
        ArrayList<File> jars = new ArrayList<File>();
        File[] files = libFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
                jars.add(file);
            }
        }
        return jars.toArray(new File[jars.size()]);
    }

    @Override
    @NotNull
    public String getSdkHomePath() {
        String string = this.myHomePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/sdk/impl/AppEngineSdkImpl", "getSdkHomePath"));
        }
        return string;
    }

    @Override
    public boolean isClassInWhiteList(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/appengine/sdk/impl/AppEngineSdkImpl", "isClassInWhiteList"));
        }
        if (!this.isValid()) {
            return true;
        }
        if (this.myClassesWhiteList == null) {
            File cachedWhiteList = this.getCachedWhiteListFile();
            if (cachedWhiteList.exists()) {
                try {
                    this.myClassesWhiteList = AppEngineSdkUtil.loadWhiteList(cachedWhiteList);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    this.myClassesWhiteList = Collections.emptyMap();
                }
            } else {
                this.myClassesWhiteList = AppEngineSdkUtil.computeWhiteList(this.getToolsApiJarFile());
                if (!this.myClassesWhiteList.isEmpty()) {
                    AppEngineSdkUtil.saveWhiteList(cachedWhiteList, this.myClassesWhiteList);
                }
            }
        }
        if (this.myClassesWhiteList.isEmpty()) {
            return true;
        }
        String packageName = StringUtil.getPackageName((String)className);
        String name = StringUtil.getShortName((String)className);
        Set<String> classes = this.myClassesWhiteList.get(packageName);
        return classes != null && classes.contains(name);
    }

    @Override
    @Nullable
    public String getVersion() {
        return JarUtil.getJarAttribute((File)this.getToolsApiJarFile(), (String)"com/google/appengine/tools/info/", (Attributes.Name)Attributes.Name.SPECIFICATION_VERSION);
    }

    private File getCachedWhiteListFile() {
        String fileName = StringUtil.getShortName((String)this.myHomePath, (char)'/') + Integer.toHexString(this.myHomePath.hashCode()) + "_" + Long.toHexString(this.getToolsApiJarFile().lastModified());
        return new File(AppEngineUtil.getAppEngineSystemDir(), fileName);
    }

    @Override
    public boolean isMethodInBlacklist(@NotNull String className, @NotNull String methodName) {
        Set<String> methods;
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/appengine/sdk/impl/AppEngineSdkImpl", "isMethodInBlacklist"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/appengine/sdk/impl/AppEngineSdkImpl", "isMethodInBlacklist"));
        }
        if (this.myMethodsBlackList == null) {
            try {
                this.myMethodsBlackList = this.loadBlackList();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                this.myMethodsBlackList = new THashMap();
            }
        }
        return (methods = this.myMethodsBlackList.get(className)) != null && methods.contains(methodName);
    }

    @Override
    public boolean isValid() {
        return this.getToolsApiJarFile().exists() && this.getAppCfgFile().exists();
    }

    @Override
    @NotNull
    public String getOrmLibDirectoryPath() {
        String string = this.getLibUserDirectoryPath() + "/orm";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/sdk/impl/AppEngineSdkImpl", "getOrmLibDirectoryPath"));
        }
        return string;
    }

    @Override
    @NotNull
    public List<String> getUserLibraryPaths() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getLibUserDirectoryPath());
        File opt = new File(this.myHomePath, "lib/opt/user");
        ContainerUtil.addIfNotNull(result, (Object)AppEngineSdkImpl.findLatestVersion(new File(opt, "appengine-endpoints")));
        ContainerUtil.addIfNotNull(result, (Object)AppEngineSdkImpl.findLatestVersion(new File(opt, "jsr107")));
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/sdk/impl/AppEngineSdkImpl", "getUserLibraryPaths"));
        }
        return arrayList;
    }

    private static String findLatestVersion(File dir) {
        String[] names = dir.list();
        if (names != null && names.length > 0) {
            String max = Collections.max(Arrays.asList(names));
            return FileUtil.toSystemIndependentName((String)new File(dir, max).getAbsolutePath());
        }
        return null;
    }

    @Override
    @NotNull
    public VirtualFile[] getOrmLibSources() {
        File libsDir = new File(this.myHomePath, "src/orm");
        File[] files = libsDir.listFiles();
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        if (files != null) {
            for (File file : files) {
                String url = VfsUtil.getUrlForLibraryRoot((File)file);
                VirtualFile zipRoot = VirtualFileManager.getInstance().findFileByUrl(url);
                if (zipRoot == null || !zipRoot.isDirectory()) continue;
                String fileName = file.getName();
                String srcDirName = StringUtil.trimEnd((String)fileName, (String)"-src.zip");
                VirtualFile sourcesDir = zipRoot.findFileByRelativePath(srcDirName + "/src/java");
                if (sourcesDir != null) {
                    roots.add(sourcesDir);
                    continue;
                }
                roots.add(zipRoot);
            }
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(roots);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/sdk/impl/AppEngineSdkImpl", "getOrmLibSources"));
        }
        return virtualFileArray;
    }

    public String getLibUserDirectoryPath() {
        return this.myHomePath + "/lib/user";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<String>> loadBlackList() throws IOException {
        InputStream stream = this.getClass().getResourceAsStream("/data/methodsBlacklist.txt");
        LOG.assertTrue(stream != null, (Object)"/data/methodsBlacklist.txt not found");
        THashMap map = new THashMap();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            String line;
            while ((line = reader.readLine()) != null) {
                int i = line.indexOf(58);
                String className = line.substring(0, i);
                String methods = line.substring(i + 1);
                map.put((Object)className, (Object)new THashSet((Collection)StringUtil.split((String)methods, (String)",")));
            }
        }
        return map;
    }
}

