/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.j2ee.web.resin;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.transport.TransportHost;
import com.intellij.javaee.transport.TransportHostTarget;
import com.intellij.javaee.transport.TransportManager;
import com.intellij.javaee.transport.TransportTarget;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.intellij.j2ee.web.resin.ResinModelBase;
import org.intellij.j2ee.web.resin.ResinModelDataBase;
import org.intellij.j2ee.web.resin.ui.RemoteRunConfigurationEditor;
import org.jetbrains.annotations.Nullable;

public class ResinRemoteModel
extends ResinModelBase<ResinRemoteModelData> {
    public SettingsEditor<CommonModel> getEditor() {
        return new RemoteRunConfigurationEditor(this.getProject());
    }

    public List<Pair<String, Integer>> getAddressesToCheck() {
        return Collections.emptyList();
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        if (!this.hasJmxStrategy() && this.getCommonModel().getDeploymentModels().size() > 0) {
            throw new RuntimeConfigurationError("Remote deployment is not supported for Resin 2.x");
        }
        super.checkConfiguration();
    }

    public String getTransportHostId() {
        return ((ResinRemoteModelData)this.getData()).getTransportHostId();
    }

    public void setTransportHostId(String transportHostId) {
        ((ResinRemoteModelData)this.getData()).setTransportHostId(transportHostId);
    }

    public TransportTarget getTransportTargetWebApps() {
        return ((ResinRemoteModelData)this.getData()).getTransportTargetWebApps();
    }

    public void setTransportTargetWebApps(TransportTarget transportTargetWebApps) {
        ((ResinRemoteModelData)this.getData()).setTransportTargetWebApps(transportTargetWebApps);
    }

    @Override
    protected ResinRemoteModelData createResinModelData() {
        return new ResinRemoteModelData();
    }

    @Nullable
    private TransportHost getHost() {
        return TransportManager.getInstance().findHost(this.getTransportHostId(), this.getProject());
    }

    @Nullable
    private TransportHostTarget getTransportHostTarget() {
        TransportHost host = this.getHost();
        return host == null ? null : host.findOrCreateHostTarget(this.getTransportTargetWebApps());
    }

    @Override
    public boolean transferFile(File webAppFile) {
        TransportHostTarget target = this.getTransportHostTarget();
        return target != null && target.transfer(this.getProject(), Collections.singletonList(LocalFileSystem.getInstance().refreshAndFindFileByIoFile(webAppFile)));
    }

    @Override
    public boolean deleteFile(File webAppFile) {
        TransportHostTarget target = this.getTransportHostTarget();
        VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(webAppFile);
        if (vFile == null) {
            return true;
        }
        return target != null && target.delete(this.getProject(), Collections.singletonList(vFile));
    }

    @Override
    @Nullable
    public SettingsEditor<DeploymentModel> createAdditionalDeploymentSettingsEditor(CommonModel commonModel, DeploymentSource source) {
        return null;
    }

    public static class ResinRemoteModelData
    extends ResinModelDataBase {
        @Tag(value="host-id")
        private String myTransportHostId;
        @Tag(value="transport-target-webapps")
        private TransportTarget myTransportTargetWebApps;

        public String getTransportHostId() {
            return this.myTransportHostId;
        }

        public void setTransportHostId(String transportHostId) {
            this.myTransportHostId = transportHostId;
        }

        public TransportTarget getTransportTargetWebApps() {
            return this.myTransportTargetWebApps;
        }

        public void setTransportTargetWebApps(TransportTarget transportTargetWebApps) {
            this.myTransportTargetWebApps = transportTargetWebApps;
        }
    }
}

