/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.j2ee.web.resin.ui;

import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.Factory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.intellij.j2ee.web.resin.ResinModuleDeploymentModel;
import org.jetbrains.annotations.NotNull;

public class DeploymentSettingsEditor
extends SettingsEditor<DeploymentModel> {
    private JPanel myMainPanel;
    private JTextField myHostField;
    private JTextField myApplicationContextField;
    private JCheckBox myDefaultContextCheckBox;

    public DeploymentSettingsEditor(final CommonModel commonModel, final DeploymentSource deploymentSource) {
        super((Factory)new Factory<DeploymentModel>(){

            public ResinModuleDeploymentModel create() {
                return new ResinModuleDeploymentModel(commonModel, deploymentSource);
            }
        });
        this.$$$setupUI$$$();
        this.myDefaultContextCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeploymentSettingsEditor.this.updateContextEnabled();
            }
        });
        this.myDefaultContextCheckBox.setSelected(true);
        this.updateContextEnabled();
    }

    private void updateContextEnabled() {
        this.myApplicationContextField.setEnabled(!this.myDefaultContextCheckBox.isSelected());
    }

    public void resetEditorFrom(DeploymentModel settings) {
        ResinModuleDeploymentModel resinDeploymentModel = (ResinModuleDeploymentModel)settings;
        this.myDefaultContextCheckBox.setSelected(resinDeploymentModel.isDefaultContextPath());
        this.updateContextEnabled();
        this.myApplicationContextField.setText(resinDeploymentModel.getContextPath());
        this.myHostField.setText(resinDeploymentModel.getHost());
    }

    public void applyEditorTo(DeploymentModel settings) throws ConfigurationException {
        ResinModuleDeploymentModel resinDeploymentModel = (ResinModuleDeploymentModel)settings;
        resinDeploymentModel.setDefaultContextPath(this.myDefaultContextCheckBox.isSelected());
        resinDeploymentModel.setContextPath(this.myApplicationContextField.getText());
        resinDeploymentModel.setHost(this.myHostField.getText());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/j2ee/web/resin/ui/DeploymentSettingsEditor", "createEditor"));
        }
        return jPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/intellij/j2ee/web/resin/ResinBundle").getString("deployment.dlg.app.context"));
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myApplicationContextField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/intellij/j2ee/web/resin/ResinBundle").getString("deployment.dlg.host.name.text"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHostField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myDefaultContextCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("org/intellij/j2ee/web/resin/ResinBundle").getString("deployment.dlg.default.context.checkbox"));
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

