/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.fileStructure;

import com.google.common.collect.Lists;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.impl.structure.CssStructureViewElement;
import com.intellij.psi.css.impl.structure.CssStructureViewElementsProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.LESSLanguage;
import org.jetbrains.plugins.less.fileStructure.LessVariableStructureViewElement;
import org.jetbrains.plugins.less.fileStructure.LessVariablesFilter;
import org.jetbrains.plugins.less.psi.LESSVariableDeclaration;
import org.jetbrains.plugins.less.psi.LessParameter;
import org.jetbrains.plugins.less.psi.impl.LESSPrimitiveMixin;
import org.jetbrains.plugins.less.psi.impl.LESSRegularMixin;

public class LessStructureViewElementsProvider
extends CssStructureViewElementsProvider {
    private static final Filter[] LESS_FILTERS = new Filter[]{new LessVariablesFilter()};
    private static final Class[] LESS_SUITABLE_CLASSES = new Class[]{LESSVariableDeclaration.class, LESSRegularMixin.class, LESSPrimitiveMixin.class};

    @NotNull
    public Collection<? extends CssStructureViewElement> createStructureViewElements(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/less/fileStructure/LessStructureViewElementsProvider", "createStructureViewElements"));
        }
        if (element.getLanguage() != LESSLanguage.INSTANCE || this.shouldSkipElement(element)) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/fileStructure/LessStructureViewElementsProvider", "createStructureViewElements"));
            }
            return list;
        }
        if (element instanceof LESSVariableDeclaration) {
            ArrayList arrayList = Lists.newArrayList((Object[])new LessVariableStructureViewElement[]{new LessVariableStructureViewElement((LESSVariableDeclaration)element)});
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/fileStructure/LessStructureViewElementsProvider", "createStructureViewElements"));
            }
            return arrayList;
        }
        if (element instanceof LESSRegularMixin) {
            ArrayList arrayList = Lists.newArrayList((Object[])new CssStructureViewElement[]{CssStructureViewElement.create((PsiElement)element)});
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/fileStructure/LessStructureViewElementsProvider", "createStructureViewElements"));
            }
            return arrayList;
        }
        if (element instanceof LESSPrimitiveMixin) {
            CssRuleset[] rulesets;
            ArrayList result = Lists.newArrayList();
            for (CssRuleset ruleset : rulesets = ((LESSPrimitiveMixin)element).getRulesets()) {
                String presentableText = ruleset.getPresentableText();
                if (presentableText.isEmpty()) continue;
                result.add(CssStructureViewElement.create((PsiElement)ruleset, (PsiElement)element, (Icon)AllIcons.Xml.Css_class, (String)presentableText));
            }
            ArrayList arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/fileStructure/LessStructureViewElementsProvider", "createStructureViewElements"));
            }
            return arrayList;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/fileStructure/LessStructureViewElementsProvider", "createStructureViewElements"));
        }
        return list;
    }

    public boolean isMyContext(PsiElement element) {
        return LESSLanguage.INSTANCE.is(CssPsiUtil.getStylesheetLanguage((PsiElement)element));
    }

    @NotNull
    public Filter[] getFilters() {
        if (LESS_FILTERS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/fileStructure/LessStructureViewElementsProvider", "getFilters"));
        }
        return LESS_FILTERS;
    }

    @NotNull
    public Class[] getSuitableClasses() {
        if (LESS_SUITABLE_CLASSES == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/fileStructure/LessStructureViewElementsProvider", "getSuitableClasses"));
        }
        return LESS_SUITABLE_CLASSES;
    }

    public boolean hasInnerStructure(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/less/fileStructure/LessStructureViewElementsProvider", "hasInnerStructure"));
        }
        return false;
    }

    public boolean shouldSkipElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/less/fileStructure/LessStructureViewElementsProvider", "shouldSkipElement"));
        }
        return element instanceof LESSVariableDeclaration && element.getParent() instanceof LessParameter;
    }
}

