/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat.server;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.oss.transport.SimpleRemoteServerModel;
import com.intellij.javaee.oss.transport.SimpleRemoteServerModelData;
import com.intellij.javaee.oss.transport.SimpleRemoteServerModelDelegate;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.transport.TransportTarget;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Tag;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.tomcat.TomcatBundle;
import org.jetbrains.idea.tomcat.TomcatRemoteRunConfigurationEditor;
import org.jetbrains.idea.tomcat.admin.TomEEAgentAdminServerImpl;
import org.jetbrains.idea.tomcat.admin.TomcatAdminRemoteServerImpl;
import org.jetbrains.idea.tomcat.admin.TomcatAdminServerBase;
import org.jetbrains.idea.tomcat.server.TomcatServerModel;

public class TomcatRemoteModel
extends TomcatServerModel
implements SimpleRemoteServerModel {
    @NonNls
    private static final String DATA_ELEMENT = "data";
    private int myJndiPort = 1099;
    private SimpleRemoteServerModelDelegate myTransportDelegate = new SimpleRemoteServerModelDelegate().init((SimpleRemoteServerModel)this);

    @Override
    protected TomcatAdminServerBase<?> createTomcatServerAdmin(JavaeeServerInstance processHandler, TomEEAgentAdminServerImpl tomEEAdmin) {
        return new TomcatAdminRemoteServerImpl(this, tomEEAdmin);
    }

    @Override
    public int getJndiPort() {
        return this.myJndiPort;
    }

    public void setJndiPort(int jndiPort) {
        this.myJndiPort = jndiPort;
    }

    public String getTransportHostId() {
        return this.myTransportDelegate.getTransportHostId();
    }

    public void setTransportHostId(String transportHostId) {
        this.myTransportDelegate.setTransportHostId(transportHostId);
    }

    public TransportTarget getTransportStagingTarget() {
        return this.myTransportDelegate.getTransportStagingTarget();
    }

    public void setTransportStagingTarget(TransportTarget transportStagingTarget) {
        this.myTransportDelegate.setTransportStagingTarget(transportStagingTarget);
    }

    public String getStagingRemotePath() {
        return this.myTransportDelegate.getStagingRemotePath();
    }

    public void setStagingRemotePath(String stagingRemotePath) {
        this.myTransportDelegate.setStagingRemotePath(stagingRemotePath);
    }

    public boolean isDeployAllowed() {
        return this.myTransportDelegate.isDeployAllowed();
    }

    public String prepareDeployment(String sourcePath, boolean prepareNameOnly) throws RuntimeConfigurationException {
        return this.myTransportDelegate.prepareDeployment(sourcePath, prepareNameOnly);
    }

    @Override
    public boolean isUseJmx() {
        return super.isUseJmx() && this.hasDeployments();
    }

    public boolean hasDeployments() {
        return !this.getCommonModel().getDeploymentModels().isEmpty();
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.isVersion5OrHigher()) {
            super.checkConfiguration();
            if (this.hasDeployments() && this.myJndiPort <= 0) {
                throw new RuntimeConfigurationError(TomcatBundle.message("error.jmx.port.not.specified", new Object[0]));
            }
            this.myTransportDelegate.checkConfiguration();
        } else if (this.hasDeployments()) {
            throw new RuntimeConfigurationError(TomcatBundle.message("error.remote.deploy.not.supported.for.under.v5", new Object[0]));
        }
    }

    public SettingsEditor<CommonModel> getEditor() {
        return new TomcatRemoteRunConfigurationEditor();
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element dataElement = element.getChild(DATA_ELEMENT);
        if (dataElement == null) {
            return;
        }
        TomcatRemoteModelData settings = (TomcatRemoteModelData)((Object)XmlSerializer.deserialize((Element)dataElement, TomcatRemoteModelData.class));
        if (settings == null) {
            return;
        }
        this.myTransportDelegate.readFromData((SimpleRemoteServerModelData)settings);
        this.myJndiPort = settings.getJndiPort();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        TomcatRemoteModelData settings = new TomcatRemoteModelData();
        this.myTransportDelegate.writeToData((SimpleRemoteServerModelData)settings);
        settings.setJndiPort(this.myJndiPort);
        Element dataElement = XmlSerializer.serialize((Object)((Object)settings), (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        element.addContent(dataElement);
    }

    public Object clone() throws CloneNotSupportedException {
        TomcatRemoteModel result = (TomcatRemoteModel)((Object)super.clone());
        result.myTransportDelegate = ((SimpleRemoteServerModelDelegate)this.myTransportDelegate.clone()).init((SimpleRemoteServerModel)result);
        return result;
    }

    @Tag(value="data")
    public static class TomcatRemoteModelData
    extends SimpleRemoteServerModelData {
        @Tag(value="jndi-port")
        private int myJndiPort = 1099;

        public int getJndiPort() {
            return this.myJndiPort;
        }

        public void setJndiPort(int jndiPort) {
            this.myJndiPort = jndiPort;
        }
    }
}

