/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.css.CssFileType;
import icons.SassIcons;
import java.nio.charset.Charset;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSBundle;
import org.jetbrains.plugins.scss.SCSSLanguage;

public class SCSSFileType
extends LanguageFileType {
    public static final SCSSFileType SCSS = new SCSSFileType();
    @NonNls
    public static final String DEFAULT_EXTENSION = "scss";
    @NonNls
    private static final String NAME = "SCSS";
    @NonNls
    private static final String DESCRIPTION = SASSBundle.message("filetype.description.scss");

    protected SCSSFileType() {
        super((Language)SCSSLanguage.INSTANCE);
    }

    @NotNull
    public String getName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/SCSSFileType", "getName"));
        }
        return NAME;
    }

    @NotNull
    public String getDescription() {
        String string = DESCRIPTION;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/SCSSFileType", "getDescription"));
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        if (DEFAULT_EXTENSION == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/SCSSFileType", "getDefaultExtension"));
        }
        return DEFAULT_EXTENSION;
    }

    @Nullable
    public Icon getIcon() {
        return SassIcons.Sass;
    }

    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/scss/SCSSFileType", "getCharset"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/plugins/scss/SCSSFileType", "getCharset"));
        }
        Charset charset = CssFileType.getCharsetFromCssContent((byte[])content);
        return charset != null ? charset.name() : null;
    }

    public Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile file, @NotNull CharSequence content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/plugins/scss/SCSSFileType", "extractCharsetFromFileContent"));
        }
        return CssFileType.getCharsetFromCssContent((CharSequence)content);
    }
}

