/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssHighlighterLexer;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.psi.SASSTokenTypes;
import org.jetbrains.plugins.scss.lexer.SCSSLexer;
import org.jetbrains.plugins.scss.lexer.SCSSTokenTypes;

public class SCSSHighlightingLexer
extends CssHighlighterLexer {
    private final SCSSLexer lookAheadLexer;
    private int blockNestingDepth;
    private boolean myInVariableDeclaration;
    private boolean myAfterPercent;
    private static final int BLOCK_LEVEL_MASK = 15;
    private static final int IN_DECLARATION_FLAG = 16;
    private static final int AFTER_PERCENT_FLAG = 32;

    public SCSSHighlightingLexer(@NotNull Set<String> propertyValues) {
        if (propertyValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyValues", "org/jetbrains/plugins/scss/lexer/SCSSHighlightingLexer", "<init>"));
        }
        super((Lexer)new SCSSLexer(), propertyValues);
        this.blockNestingDepth = 0;
        this.myInVariableDeclaration = false;
        this.myAfterPercent = false;
        this.lookAheadLexer = new SCSSLexer();
    }

    protected void initState(int initialState) {
        super.initState(initialState);
        int state = initialState >> 20;
        this.blockNestingDepth = state & 0xF;
        this.myInVariableDeclaration = (state & 0x10) != 0;
        this.myAfterPercent = (state & 0x20) != 0;
    }

    public int getState() {
        int state = 0;
        state |= this.myAfterPercent ? 32 : 0;
        state |= this.myInVariableDeclaration ? 16 : 0;
        return super.getState() | (state |= this.blockNestingDepth <= 15 ? this.blockNestingDepth : 15) << 20;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/plugins/scss/lexer/SCSSHighlightingLexer", "start"));
        }
        super.start(buffer, startOffset, endOffset, initialState);
        this.lookAheadLexer.start(this.getDelegate().getBufferSequence(), this.getDelegate().getTokenStart(), this.getDelegate().getBufferEnd(), this.getDelegate().getState());
    }

    public void advance() {
        IElementType tokenType = this.getTokenType();
        if (tokenType == CssElementTypes.CSS_LBRACE && !this.myAfterKeyframes) {
            ++this.blockNestingDepth;
        }
        if (tokenType == CssElementTypes.CSS_RBRACE && !this.myInKeyframes && this.blockNestingDepth > 0) {
            --this.blockNestingDepth;
        }
        if (tokenType == SCSSTokenTypes.VARIABLE) {
            this.myInPropertyValue = true;
            this.myInVariableDeclaration = true;
        }
        this.myAfterPercent = this.getDelegate().getTokenType() == CssElementTypes.CSS_PERCENT;
        super.advance();
        if (!this.myInPropertyValue) {
            this.myInVariableDeclaration = false;
        }
        this.myInsideBlock = this.blockNestingDepth > 0;
    }

    public IElementType getTokenType() {
        String tokenText;
        if (this.lastElementType != null) {
            return this.lastElementType;
        }
        IElementType type = this.getDelegate().getTokenType();
        if (SCSSTokenTypes.KEYWORDS.contains(type)) {
            this.lastElementType = type;
            return this.lastElementType;
        }
        if (type == CssElementTypes.CSS_PERCENT && this.lookAhead(1) == CssElementTypes.CSS_IDENT) {
            return CssElementTypes.CSS_IDENT;
        }
        if (type == CssElementTypes.CSS_IDENT && !this.myInKeyframes && ("from".equals(tokenText = this.getCurrentTokenText()) || "through".equals(tokenText) || "to".equals(tokenText))) {
            this.lastElementType = SCSSTokenTypes.KEYWORD;
            return this.lastElementType;
        }
        if (type == CssElementTypes.CSS_IDENT && this.lookAhead(1) == CssElementTypes.CSS_LPAREN) {
            return CssElementTypes.CSS_FUNCTION_TOKEN;
        }
        return super.getTokenType();
    }

    public boolean isPropertyNameAllowed() {
        return super.isPropertyNameAllowed() && !this.myAfterPercent && this.lookAhead(1) == SASSTokenTypes.COLON;
    }

    protected Lexer getLookAheadLexer() {
        return this.lookAheadLexer;
    }

    public boolean isPropertyValueAllowed() {
        return !(!this.myInPropertyValue && this.myFunctionNestingDepth <= 0 || !this.myInsideBlock && !this.myInVariableDeclaration && !this.myAfterMediaOrSupports || this.lookAhead(1) == SASSTokenTypes.COLON);
    }

    public boolean isSelectorAllowed() {
        boolean propertyRuleset = this.lookAhead(1) == SASSTokenTypes.COLON && this.lookAhead(2) == CssElementTypes.CSS_LBRACE;
        return !this.myInPropertyValue && this.myFunctionNestingDepth <= 0 && !this.myAfterMediaOrSupports && !propertyRuleset && !this.isTerminatedDeclaration();
    }

    protected boolean isAndOrIdentifier(IElementType type, String tokenText) {
        return type == SCSSTokenTypes.AND || type == SCSSTokenTypes.OR;
    }
}

