/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.javascript.nodejs.PackageJsonField;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharSequenceReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonData {
    private static final Logger LOG = Logger.getInstance(PackageJsonData.class);
    private final String myDescription;
    private final Map<String, PackageJsonField> myTypeByDependencyNameMap;
    private final Set<String> myScopes;

    private PackageJsonData(@NotNull Holder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/javascript/nodejs/PackageJsonData", "<init>"));
        }
        this.myDescription = holder.myDescription;
        HashMap typeByDependencyNameMap = ContainerUtil.newHashMap();
        HashSet scopes = ContainerUtil.newHashSet();
        for (Map.Entry entry : holder.myDependenciesByType.entrySet()) {
            for (String dependencyName : (List)entry.getValue()) {
                typeByDependencyNameMap.put(dependencyName, entry.getKey());
                PackageJsonData.addScope(dependencyName, scopes);
            }
        }
        this.myScopes = ImmutableSet.copyOf((Collection)scopes);
        this.myTypeByDependencyNameMap = ImmutableMap.copyOf((Map)typeByDependencyNameMap);
    }

    private static void addScope(@NotNull String dependencyName, @NotNull Set<String> scopes) {
        int slashInd;
        if (dependencyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyName", "com/intellij/javascript/nodejs/PackageJsonData", "addScope"));
        }
        if (scopes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopes", "com/intellij/javascript/nodejs/PackageJsonData", "addScope"));
        }
        if (dependencyName.startsWith("@") && (slashInd = dependencyName.indexOf(47, 1)) > 0) {
            scopes.add(dependencyName.substring(0, slashInd));
        }
    }

    public boolean containsDependencyWithScope(@NotNull String scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/javascript/nodejs/PackageJsonData", "containsDependencyWithScope"));
        }
        return this.myScopes.contains(scope);
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public boolean isDependencyOfAnyType(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/nodejs/PackageJsonData", "isDependencyOfAnyType"));
        }
        return this.myTypeByDependencyNameMap.containsKey(name);
    }

    @NotNull
    public Set<String> getAllDependencies() {
        Set<String> set = this.myTypeByDependencyNameMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/PackageJsonData", "getAllDependencies"));
        }
        return set;
    }

    @NotNull
    public static PackageJsonData parse(@NotNull VirtualFile packageJsonFile, @Nullable Document packageJsonDocument) {
        if (packageJsonFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJsonFile", "com/intellij/javascript/nodejs/PackageJsonData", "parse"));
        }
        CharSequence text = PackageJsonData.loadText(packageJsonFile, packageJsonDocument);
        if (text != null) {
            PackageJsonData packageJsonData;
            block5: {
                try {
                    Holder holder = PackageJsonData.doParse(packageJsonFile, text);
                    packageJsonData = new PackageJsonData(holder);
                    if (packageJsonData != null) break block5;
                }
                catch (Exception e) {
                    LOG.warn("Failed to parse " + packageJsonFile.getPath() + ": " + e.getMessage());
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/PackageJsonData", "parse"));
            }
            return packageJsonData;
        }
        PackageJsonData packageJsonData = new PackageJsonData(new Holder());
        if (packageJsonData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/PackageJsonData", "parse"));
        }
        return packageJsonData;
    }

    @Nullable
    private static CharSequence loadText(@NotNull VirtualFile packageJsonFile, @Nullable Document packageJsonDocument) {
        if (packageJsonFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJsonFile", "com/intellij/javascript/nodejs/PackageJsonData", "loadText"));
        }
        if (packageJsonDocument != null) {
            return packageJsonDocument.getCharsSequence();
        }
        try {
            return VfsUtilCore.loadText((VirtualFile)packageJsonFile);
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    private static Holder doParse(@NotNull VirtualFile packageJson, @NotNull CharSequence text) throws IOException {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/PackageJsonData", "doParse"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/javascript/nodejs/PackageJsonData", "doParse"));
        }
        JsonReader reader = new JsonReader((Reader)new CharSequenceReader(text));
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            throw new IOException("Top level element should be object");
        }
        reader.beginObject();
        Holder holder = new Holder();
        EnumMap dependenciesByType = ContainerUtil.newEnumMap(PackageJsonField.class);
        while (reader.hasNext()) {
            String key = reader.nextName();
            if ("description".equals(key)) {
                holder.myDescription = PackageJsonData.tryGetString(reader);
                continue;
            }
            PackageJsonField dependencyType = PackageJsonField.findDependencyByName(key);
            if (dependencyType != null) {
                List<String> dependencies = PackageJsonData.readPackages(reader, packageJson, dependencyType);
                dependenciesByType.put(dependencyType, dependencies);
                continue;
            }
            reader.skipValue();
        }
        holder.myDependenciesByType = dependenciesByType;
        reader.endObject();
        Holder holder2 = holder;
        if (holder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/PackageJsonData", "doParse"));
        }
        return holder2;
    }

    @NotNull
    private static List<String> readPackages(@NotNull JsonReader reader, @NotNull VirtualFile packageJson, @NotNull PackageJsonField dependencyType) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/javascript/nodejs/PackageJsonData", "readPackages"));
        }
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/PackageJsonData", "readPackages"));
        }
        if (dependencyType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyType", "com/intellij/javascript/nodejs/PackageJsonData", "readPackages"));
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            LOG.warn("Failed to parse '" + (Object)((Object)dependencyType) + "' of " + packageJson.getPath() + ": expected " + JsonToken.BEGIN_OBJECT + ", actual " + reader.peek());
            reader.skipValue();
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/PackageJsonData", "readPackages"));
            }
            return list;
        }
        reader.beginObject();
        ArrayList packages = ContainerUtil.newArrayList();
        while (reader.hasNext()) {
            String key = reader.nextName();
            packages.add(key);
            reader.skipValue();
        }
        reader.endObject();
        ArrayList arrayList = packages;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/PackageJsonData", "readPackages"));
        }
        return arrayList;
    }

    @Nullable
    private static String tryGetString(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/javascript/nodejs/PackageJsonData", "tryGetString"));
        }
        if (reader.peek() == JsonToken.STRING) {
            return reader.nextString();
        }
        reader.skipValue();
        return null;
    }

    private static class Holder {
        private String myDescription;
        private Map<PackageJsonField, List<String>> myDependenciesByType = Collections.emptyMap();

        private Holder() {
        }
    }
}

