/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeModulesLibraryDirectory {
    private final VirtualFile myNodeModulesDir;
    private final String myLibraryName;
    private volatile ScriptingLibraryModel myLibraryModel;

    public NodeModulesLibraryDirectory(@NotNull VirtualFile nodeModulesDir, @NotNull String libraryName) {
        if (nodeModulesDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesDir", "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory", "<init>"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory", "<init>"));
        }
        this.myNodeModulesDir = nodeModulesDir;
        this.myLibraryName = libraryName;
    }

    @NotNull
    public VirtualFile getNodeModulesDir() {
        VirtualFile virtualFile = this.myNodeModulesDir;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory", "getNodeModulesDir"));
        }
        return virtualFile;
    }

    public boolean isForApplicationCode() {
        VirtualFile parent = this.myNodeModulesDir.getParent();
        if (parent != null) {
            VirtualFile packageJson = parent.findChild("package.json");
            return packageJson == null || packageJson.isValid() && packageJson.isDirectory();
        }
        return false;
    }

    @NotNull
    public String getLibraryName() {
        String string = this.myLibraryName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory", "getLibraryName"));
        }
        return string;
    }

    @Nullable
    public ScriptingLibraryModel getLibraryModel() {
        return this.myLibraryModel;
    }

    public void setLibraryModel(@NotNull ScriptingLibraryModel libraryModel) {
        if (libraryModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryModel", "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory", "setLibraryModel"));
        }
        this.myLibraryModel = libraryModel;
    }
}

